/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern {
    private char[] qualification;
    private char[] decodedQualification;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char classOrInterface, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        this.qualification = isCaseSensitive ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase(simpleName);
        this.classOrInterface = classOrInterface;
        this.needsResolve = qualification != null;
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        this.decodedClassOrInterface = word[9];
        int oldSlash = 10;
        int slash = CharOperation.indexOf('/', word, oldSlash + 1);
        char[] pkgName = slash == oldSlash + 1 ? CharOperation.NO_CHAR : CharOperation.subarray(word, oldSlash + 1, slash);
        int n = slash + 1;
        slash = CharOperation.indexOf('/', word, slash + 1);
        this.decodedSimpleName = CharOperation.subarray(word, n, slash);
        char[][] enclosingTypeNames = slash + 1 < size ? (slash + 3 == size && word[slash + 1] == IIndexConstants.ONE_ZERO[0] ? IIndexConstants.ONE_ZERO_CHAR : CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, size - 1))) : CharOperation.NO_CHAR_CHAR;
        this.decodedQualification = CharOperation.concatWith(pkgName, enclosingTypeNames, '.');
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[] typeName = (char[])type.getName().clone();
        CharOperation.replace(typeName, '/', '.');
        if (!this.matchesType(this.simpleName, this.qualification, typeName)) {
            return false;
        }
        switch (this.classOrInterface) {
            case 'C': {
                if (!type.isInterface()) break;
                return false;
            }
            case 'I': {
                if (type.isInterface()) break;
                return false;
            }
        }
        return true;
    }

    protected boolean matchIndexEntry() {
        switch (this.classOrInterface) {
            case 'C': 
            case 'I': {
                if (this.classOrInterface == this.decodedClassOrInterface) break;
                return false;
            }
        }
        if (this.qualification != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.qualification, this.decodedQualification, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.qualification, this.decodedQualification, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.qualification, this.decodedQualification, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        if (this.simpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public int matchLevel(Binding binding) {
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding type = (TypeBinding)binding;
        switch (this.classOrInterface) {
            case 'C': {
                if (!type.isInterface()) break;
                return 0;
            }
            case 'I': {
                if (type.isInterface()) break;
                return 0;
            }
        }
        return this.matchLevelForType(this.simpleName, this.qualification, type);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        switch (this.classOrInterface) {
            case 'C': {
                buffer.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'I': {
                buffer.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            default: {
                buffer.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            buffer.append(this.qualification);
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

