/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.cocoon.util.ClassUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractStreamSource
extends AbstractLogEnabled
implements ModifiableSource {
    private static Class jtidyClass;
    private static Properties xmlProperties;
    public static TransformerFactory transformerFactory;
    protected ComponentManager manager;

    protected AbstractStreamSource(ComponentManager manager) {
        this.manager = manager;
    }

    protected boolean isHTMLContent() {
        return false;
    }

    public InputSource getInputSource() throws IOException, ProcessingException {
        InputStream stream = this.getInputStream();
        if (jtidyClass != null && this.isHTMLContent()) {
            try {
                Object xhtmlconvert = jtidyClass.newInstance();
                Method m = jtidyClass.getMethod("setXmlOut", Class.forName("java.lang.Boolean"));
                m.invoke(xhtmlconvert, new Boolean(true));
                m = jtidyClass.getMethod("setXHTML", Class.forName("java.lang.Boolean"));
                m.invoke(xhtmlconvert, new Boolean(true));
                m = jtidyClass.getMethod("setShowWarnings", Class.forName("java.lang.Boolean"));
                m.invoke(xhtmlconvert, new Boolean(false));
                m = jtidyClass.getMethod("parseDOM", Class.forName("java.io.InputStream"), Class.forName("java.io.OutputStream"));
                Document doc = (Document)m.invoke(xhtmlconvert, stream, null);
                StringWriter writer = new StringWriter();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperties(xmlProperties);
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                String xmlstring = writer.toString();
                InputSource newObject = new InputSource(new StringReader(xmlstring));
                newObject.setSystemId(this.getSystemId());
                return newObject;
            }
            catch (Exception ignore) {
                this.refresh();
                stream = this.getInputStream();
            }
        }
        InputSource newObject = new InputSource(stream);
        newObject.setSystemId(this.getSystemId());
        return newObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        SAXParser parser = null;
        try {
            try {
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(this.getInputSource(), handler);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.getSystemId(), e);
            }
            Object var5_3 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (parser == null) throw throwable;
            this.manager.release((Component)parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    public boolean exists() {
        try {
            InputStream stream = this.getInputStream();
            stream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void recycle() {
    }

    public void refresh() {
    }

    static {
        transformerFactory = TransformerFactory.newInstance();
        jtidyClass = null;
        try {
            jtidyClass = ClassUtils.loadClass((String)"org.w3c.tidy.Tidy");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        xmlProperties = new Properties();
        xmlProperties.put("method", "xml");
        xmlProperties.put("omit-xml-declaration", "no");
    }
}

