/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.impl;

import org.apache.excalibur.event.DequeueInterceptor;
import org.apache.excalibur.event.EnqueuePredicate;
import org.apache.excalibur.event.PreparedEnqueue;
import org.apache.excalibur.event.Queue;
import org.apache.excalibur.event.SinkException;
import org.apache.excalibur.event.impl.NullDequeueInterceptor;
import org.apache.excalibur.event.impl.NullEnqueuePredicate;

public abstract class AbstractQueue
implements Queue {
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    protected long m_timeout = 0L;
    protected EnqueuePredicate m_predicate = new NullEnqueuePredicate();
    protected DequeueInterceptor m_interceptor = new NullDequeueInterceptor();

    public int canAccept() {
        return this.maxSize() > 0 ? this.maxSize() - this.size() : this.maxSize();
    }

    public int maxSize() {
        return -1;
    }

    public boolean isFull() {
        return this.maxSize() != -1 && this.maxSize() - this.size() <= 0;
    }

    public void setTimeout(long millis) {
        this.m_timeout = millis > 0L ? millis : 0L;
    }

    protected void block(Object lock) {
        if (this.m_timeout > 0L) {
            long start = System.currentTimeMillis();
            long end = start + this.m_timeout;
            while (start < end || this.size() > 0) {
                try {
                    lock.wait(this.m_timeout);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    public void setEnqueuePredicate(EnqueuePredicate predicate) {
        if (null == predicate) {
            throw new NullPointerException("predicate");
        }
        this.m_predicate = predicate;
    }

    public EnqueuePredicate getEnqueuePredicate() {
        return this.m_predicate;
    }

    public void setDequeueInterceptor(DequeueInterceptor executable) {
        if (null == executable) {
            throw new NullPointerException("executable");
        }
        this.m_interceptor = executable;
    }

    public DequeueInterceptor getDequeueInterceptor() {
        return this.m_interceptor;
    }

    public abstract int size();

    public abstract Object[] dequeue(int var1);

    public abstract Object[] dequeueAll();

    public abstract Object dequeue();

    public abstract PreparedEnqueue prepareEnqueue(Object[] var1) throws SinkException;

    public abstract boolean tryEnqueue(Object var1);

    public abstract void enqueue(Object[] var1) throws SinkException;

    public abstract void enqueue(Object var1) throws SinkException;
}

