/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.env.WhichConstant;
import org.apache.env.WhichFactory;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public class Which {
    public static final String SEPARATOR = ";";
    public static final String DEFAULT_PROJECTS = "XmlCommons;Xerces;Xalan;Crimson;Ant";
    protected StringBuffer optionsBuf = new StringBuffer();
    protected StringBuffer projectsBuf = new StringBuffer();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);

    public static void main(String[] stringArray) {
        Which which = new Which();
        which.doMain(stringArray);
    }

    public void doMain(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            this.outWriter.println(this.usage());
            this.outWriter.println("Bad argument or help (?) asked for, aborting");
            return;
        }
        Hashtable hashtable = new Hashtable();
        int n = Which.which(hashtable, this.projectsBuf.toString(), this.optionsBuf.toString());
        this.reportProjectsInfo(hashtable, this.optionsBuf.toString(), n, this.outWriter);
    }

    public static int which(Hashtable hashtable, String string, String string2) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        Which.getGeneralInfo(hashtable, string2);
        int n = Which.getProjectsInfo(hashtable, string, string2);
        hashtable.put("Which.status", WhichConstant.ITEM_DESC[n]);
        return n;
    }

    public static void getGeneralInfo(Hashtable hashtable, String string) {
        hashtable.put("Which.version", Which.getVersion());
        WhichJar.getClasspathInfo(hashtable, string);
        try {
            hashtable.put("java.version", System.getProperty("java.version"));
            hashtable.put("file.encoding", System.getProperty("file.encoding"));
            hashtable.put("java.vendor", System.getProperty("java.vendor"));
            hashtable.put("os.name", System.getProperty("os.name"));
        }
        catch (Exception exception) {
            hashtable.put("Which.error", "Accessing System.getProperty(...) threw: " + exception.toString());
        }
        try {
            hashtable.put("java.runtime.name", System.getProperty("java.runtime.name"));
        }
        catch (Exception exception) {
            hashtable.put("Which.error11x", "Accessing System.getProperty(java.runtime.name) threw: " + exception.toString());
        }
    }

    public static int getProjectsInfo(Hashtable hashtable, String string, String string2) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, Object>();
        }
        if (null == string || string.length() < 1) {
            string = DEFAULT_PROJECTS;
            hashtable.put("Which.special-note", "No -projects provided, using DEFAULT_PROJECTS");
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                WhichProject whichProject = WhichFactory.newWhichProject(string3, string2);
                int n2 = whichProject.getInfo(hashtable2, string2);
                hashtable2.put(string3 + ".status", WhichConstant.ITEM_DESC[n2]);
                hashtable.put(string3 + ".hashinfo", hashtable2);
                n = Math.max(n2, n);
            }
            catch (Exception exception) {
                hashtable.put(string3 + WhichConstant.ITEM_DESC[5], "newWhichProject threw: " + exception.toString());
                exception.printStackTrace();
                n = Math.max(5, n);
            }
        }
        return n;
    }

    public void reportProjectsInfo(Hashtable hashtable, String string, int n, PrintWriter printWriter) {
        this.reportHashtable(hashtable, "Which report", printWriter);
    }

    protected void reportHashtable(Hashtable hashtable, String string, PrintWriter printWriter) {
        Object object;
        Object object2;
        printWriter.println("#---- BEGIN: " + string);
        if (null == hashtable) {
            return;
        }
        Enumeration<Object> enumeration = hashtable.keys();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = object2.toString();
            Object v = hashtable.get(object2);
            if (v instanceof Hashtable) {
                vector.addElement(object);
                vector.addElement((Hashtable)v);
                continue;
            }
            printWriter.println((String)object + "=" + v);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (Hashtable)enumeration.nextElement();
            this.reportHashtable((Hashtable)object, (String)object2, printWriter);
        }
        printWriter.println("#----   END: " + string);
    }

    protected String usage() {
        return "Which: find classes and jars in your environment\nusage: java org.apache.env.Which [-options] [project;org.MyWhichProject]\n";
    }

    protected boolean parseArgs(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].indexOf("?") > -1) {
                return false;
            }
            if (stringArray[n2].startsWith("-")) {
                this.optionsBuf.append(stringArray[n2]);
                this.optionsBuf.append(SEPARATOR);
            } else {
                this.projectsBuf.append(stringArray[n2]);
                this.projectsBuf.append(SEPARATOR);
            }
            ++n2;
        }
        return true;
    }

    public static String getVersion() {
        return "Which.java:($Revision: 1.4 $) " + WhichJar.getVersion();
    }
}

