/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.HyphenationTree;
import org.apache.fop.messaging.MessageHandler;

public class Hyphenator {
    static HashMap hyphenTrees = new HashMap();
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$fop$layout$hyphenation$Hyphenator;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
        this.remainCharCount = leftMin;
        this.pushCharCount = rightMin;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country) {
        String hyphenDir;
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = key + "_" + country;
        }
        if (hyphenTrees.containsKey(key)) {
            return (HyphenationTree)hyphenTrees.get(key);
        }
        if (hyphenTrees.containsKey(lang)) {
            return (HyphenationTree)hyphenTrees.get(lang);
        }
        HyphenationTree hTree = Hyphenator.getFopHyphenationTree(key);
        if (hTree == null && (hyphenDir = Configuration.getStringValue("hyphenation-dir")) != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, hyphenDir);
        }
        if (hTree != null) {
            hyphenTrees.put(key, hTree);
        } else {
            MessageHandler.errorln("Couldn't find hyphenation pattern " + key);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = (class$java$lang$Thread == null ? (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is == null) {
            is = (class$org$apache$fop$layout$hyphenation$Hyphenator == null ? (class$org$apache$fop$layout$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.layout.hyphenation.Hyphenator")) : class$org$apache$fop$layout$hyphenation$Hyphenator).getResourceAsStream("/hyph/" + key + ".hyp");
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        InputStream is;
        ObjectInputStream ois;
        HyphenationTree hTree;
        block15: {
            block16: {
                hTree = null;
                ois = null;
                is = null;
                is = Hyphenator.getResourceStream(key);
                if (is != null) break block15;
                if (key.length() != 5) break block16;
                is = Hyphenator.getResourceStream(key.substring(0, 2));
                if (is != null) {
                    MessageHandler.errorln("Couldn't find hyphenation pattern  " + key + "\nusing general language pattern " + key.substring(0, 2) + " instead.");
                    break block15;
                }
                if (errorDump) {
                    MessageHandler.errorln("Couldn't find precompiled fop hyphenation pattern " + key + ".hyp");
                }
                HyphenationTree hyphenationTree = null;
                Object var6_7 = null;
                if (ois == null) return hyphenationTree;
                try {
                    ois.close();
                    return hyphenationTree;
                }
                catch (IOException e2) {
                    MessageHandler.errorln("can't close hyphenation object stream");
                }
                return hyphenationTree;
            }
            if (errorDump) {
                MessageHandler.errorln("Couldn't find precompiled fop hyphenation pattern " + key + ".hyp");
            }
            HyphenationTree hyphenationTree = null;
            Object var6_8 = null;
            if (ois == null) return hyphenationTree;
            try {
                ois.close();
                return hyphenationTree;
            }
            catch (IOException e2) {
                MessageHandler.errorln("can't close hyphenation object stream");
            }
            return hyphenationTree;
        }
        ois = new ObjectInputStream(is);
        hTree = (HyphenationTree)ois.readObject();
        Object var6_9 = null;
        if (ois == null) return hTree;
        try {
            ois.close();
            return hTree;
        }
        catch (IOException e2) {
            MessageHandler.errorln("can't close hyphenation object stream");
        }
        return hTree;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var6_10 = null;
                if (ois == null) return hTree;
                try {
                    ois.close();
                    return hTree;
                }
                catch (IOException e2) {
                    MessageHandler.errorln("can't close hyphenation object stream");
                }
                return hTree;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e2) {
                MessageHandler.errorln("can't close hyphenation object stream");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getUserHyphenationTree(String key, String hyphenDir) {
        HyphenationTree hTree = null;
        File hyphenFile = new File(hyphenDir, key + ".hyp");
        if (hyphenFile.exists()) {
            ObjectInputStream ois = null;
            ois = new ObjectInputStream(new FileInputStream(hyphenFile));
            hTree = (HyphenationTree)ois.readObject();
            Object var7_6 = null;
            if (ois == null) return hTree;
            try {
                ois.close();
                return hTree;
            }
            catch (IOException e2) {}
            return hTree;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var7_7 = null;
                    if (ois == null) return hTree;
                    try {
                        ois.close();
                        return hTree;
                    }
                    catch (IOException e2) {}
                    return hTree;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (ois == null) throw throwable;
                try {
                    ois.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        hyphenFile = new File(hyphenDir, key + ".xml");
        if (hyphenFile.exists()) {
            hTree = new HyphenationTree();
            if (errorDump) {
                MessageHandler.errorln("reading " + hyphenDir + key + ".xml");
            }
            try {
                hTree.loadPatterns(hyphenFile.getPath());
                if (!errorDump) return hTree;
                System.out.println("Stats: ");
                hTree.printStats();
                return hTree;
            }
            catch (HyphenationException ex) {
                if (!errorDump) return null;
                MessageHandler.errorln("Can't load user patterns from xml file " + hyphenDir + key + ".xml");
                return null;
            }
        }
        if (!errorDump) return null;
        MessageHandler.errorln("Tried to load " + hyphenFile.toString() + "\nCannot find compiled nor xml file for " + "hyphenation pattern" + key);
        return null;
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            MessageHandler.errorln("Error building hyphenation tree for language " + lang);
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, char[] word, int offset, int len, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            MessageHandler.errorln("Error building hyphenation tree for language " + lang);
            return null;
        }
        return hTree.hyphenate(word, offset, len, leftMin, rightMin);
    }

    public void setMinRemainCharCount(int min) {
        this.remainCharCount = min;
    }

    public void setMinPushCharCount(int min) {
        this.pushCharCount = min;
    }

    public void setLanguage(String lang, String country) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
    }

    public Hyphenation hyphenate(char[] word, int offset, int len) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, offset, len, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String word) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, this.remainCharCount, this.pushCharCount);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

