/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.util.CookieTools;

public class WarpResponse
extends HttpResponseBase {
    private Stream localstream = new Stream(this);
    private WarpPacket packet;
    private WarpConnection connection;

    public WarpResponse() {
        this.setStream(this.localstream);
    }

    public void recycle() {
        super.recycle();
        this.localstream.recycle();
        this.setStream(this.localstream);
    }

    public void setPacket(WarpPacket warpPacket) {
        this.packet = warpPacket;
    }

    public WarpPacket getPacket() {
        return this.packet;
    }

    public void setConnection(WarpConnection warpConnection) {
        this.connection = warpConnection;
    }

    public WarpConnection getConnection() {
        return this.connection;
    }

    public void finishResponse() throws IOException {
        super.finishResponse();
        this.localstream.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendHeaders() throws IOException {
        String string;
        Cookie cookie;
        Object object;
        Object object2;
        HttpSession httpSession;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            this.committed = true;
            return;
        }
        this.packet.reset();
        this.packet.setType(32);
        this.packet.writeUnsignedShort(this.status);
        this.packet.writeString(this.message);
        this.connection.send(this.packet);
        if (this.getContentType() != null) {
            this.packet.reset();
            this.packet.setType(33);
            this.packet.writeString("Content-Type");
            this.packet.writeString(this.getContentType());
            this.connection.send(this.packet);
        }
        if (this.getContentLength() >= 0) {
            this.packet.reset();
            this.packet.setType(33);
            this.packet.writeString("Content-Length");
            this.packet.writeString(Integer.toString(this.getContentLength()));
            this.connection.send(this.packet);
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            httpSession = this.headers.keySet().iterator();
            while (httpSession.hasNext()) {
                object2 = (String)httpSession.next();
                object = (ArrayList)this.headers.get(object2);
                cookie = ((ArrayList)object).iterator();
                while (cookie.hasNext()) {
                    string = (String)cookie.next();
                    this.packet.reset();
                    this.packet.setType(33);
                    this.packet.writeString((String)object2);
                    this.packet.writeString(string);
                    this.connection.send(this.packet);
                }
            }
        }
        hashMap = (HttpServletRequest)this.request.getRequest();
        httpSession = hashMap.getSession(false);
        if (httpSession != null && httpSession.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            object2 = new Cookie("JSESSIONID", httpSession.getId());
            object2.setMaxAge(-1);
            object = null;
            if (this.context != null) {
                object = this.context.getPath();
            }
            if (object != null && ((String)object).length() > 0) {
                object2.setPath((String)object);
            } else {
                object2.setPath("/");
            }
            if (hashMap.isSecure()) {
                object2.setSecure(true);
            }
            this.addCookie((Cookie)object2);
        }
        object2 = this.cookies;
        synchronized (object2) {
            object = this.cookies.iterator();
            while (object.hasNext()) {
                cookie = (Cookie)object.next();
                string = CookieTools.getCookieHeaderName((Cookie)cookie);
                StringBuffer stringBuffer = new StringBuffer();
                CookieTools.getCookieHeaderValue((Cookie)cookie, (StringBuffer)stringBuffer);
                this.packet.reset();
                this.packet.setType(33);
                this.packet.writeString(string);
                this.packet.writeString(stringBuffer.toString());
                this.connection.send(this.packet);
            }
        }
        this.packet.reset();
        this.packet.setType(47);
        this.connection.send(this.packet);
        this.committed = true;
    }

    protected class Stream
    extends OutputStream {
        private WarpResponse response = null;
        private WarpPacket packet = null;
        private boolean closed = false;

        protected Stream(WarpResponse warpResponse2) {
            this.response = warpResponse2;
            this.packet = new WarpPacket();
        }

        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.size >= this.packet.buffer.length) {
                this.flush();
            }
            this.packet.buffer[this.packet.size++] = (byte)n;
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.setType(48);
            this.response.getConnection().send(this.packet);
            this.packet.reset();
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.flush();
            this.packet.setType(63);
            this.response.getConnection().send(this.packet);
            this.packet.reset();
        }

        public void finish() throws IOException {
            if (this.closed) {
                return;
            }
            this.close();
        }

        public void recycle() {
            this.packet.reset();
            this.closed = false;
        }
    }
}

