/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.excalibur.store.Store;

public class CacheImpl
extends AbstractLogEnabled
implements Cache,
ThreadSafe,
Composable,
Disposable,
Parameterizable {
    protected Store store;
    protected ComponentManager manager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        this.manager.release((Component)this.store);
        this.store = null;
        this.manager = null;
    }

    public void store(Serializable key, CachedResponse response) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Caching new response for " + key);
        }
        try {
            this.store.store((Object)key, (Object)response);
        }
        catch (IOException ioe) {
            throw new ProcessingException("Unable to cache response.", ioe);
        }
    }

    public CachedResponse get(Serializable key) {
        CachedResponse r = (CachedResponse)this.store.get((Object)key);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Cached response for " + key + " : " + (r == null ? "not found" : "found"));
        }
        return r;
    }

    public void remove(Serializable key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing cached response for " + key);
        }
        this.store.remove((Object)key);
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Clearing cache");
        }
        this.store.clear();
    }

    public boolean containsKey(Serializable key) {
        return this.store.containsKey((Object)key);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        String storeName = parameters.getParameter("store", Store.TRANSIENT_STORE);
        try {
            this.store = (Store)this.manager.lookup(storeName);
        }
        catch (ComponentException ce) {
            throw new ParameterException("Unable to lookup store: " + storeName, (Throwable)ce);
        }
    }
}

