/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.selection.SwitchSelector;
import org.apache.cocoon.sitemap.PatternException;

public class SwitchSelectNode
extends SimpleSelectorProcessingNode
implements ParameterizableProcessingNode,
Composable,
Disposable {
    private Map parameters;
    protected SwitchSelector threadSafeSelector;
    private ProcessingNode[][] whenNodes;
    private VariableResolver[] whenTests;
    private ProcessingNode[] otherwhiseNodes;
    private ComponentManager manager;

    public SwitchSelectNode(String name) throws PatternException {
        super(name);
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setCases(ProcessingNode[][] whenNodes, VariableResolver[] whenTests, ProcessingNode[] otherwhiseNodes) {
        this.whenNodes = whenNodes;
        this.whenTests = whenTests;
        this.otherwhiseNodes = otherwhiseNodes;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.setSelector((ComponentSelector)manager.lookup(Selector.ROLE + "Selector"));
        this.threadSafeSelector = (SwitchSelector)this.getThreadSafeComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        Map objectModel = env.getObjectModel();
        Parameters resolvedParams = VariableResolver.buildParameters(this.parameters, context, objectModel);
        if (this.threadSafeSelector != null) {
            Object ctx = this.threadSafeSelector.getSelectorContext(objectModel, resolvedParams);
            for (int i = 0; i < this.whenTests.length; ++i) {
                if (!this.threadSafeSelector.select(this.whenTests[i].resolve(context, objectModel), ctx)) continue;
                return this.invokeNodes(this.whenNodes[i], env, context);
            }
            if (this.otherwhiseNodes != null) {
                return this.invokeNodes(this.otherwhiseNodes, env, context);
            }
            return false;
        }
        SwitchSelector selector = (SwitchSelector)this.selector.select((Object)this.componentName);
        Object ctx = selector.getSelectorContext(objectModel, resolvedParams);
        try {
            boolean bl;
            for (int i = 0; i < this.whenTests.length; ++i) {
                if (!selector.select(this.whenTests[i].resolve(context, objectModel), ctx)) continue;
                boolean bl2 = this.invokeNodes(this.whenNodes[i], env, context);
                return bl2;
            }
            if (this.otherwhiseNodes != null) {
                bl = this.invokeNodes(this.otherwhiseNodes, env, context);
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            this.selector.release((Component)selector);
        }
    }

    public void dispose() {
        if (this.threadSafeSelector != null) {
            this.selector.release((Component)this.threadSafeSelector);
        }
        this.manager.release((Component)this.selector);
        this.selector = null;
    }
}

