/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.TraxErrorHandler;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractTextSerializer
extends AbstractSerializer
implements Configurable,
CacheableProcessingComponent,
Contextualizable {
    private SAXTransformerFactory tfactory = null;
    protected Properties format = new Properties();
    private static Map needsNamespaceCache = new HashMap();
    private NamespaceAsAttributes namespacePipe;

    public void setConsumer(XMLConsumer consumer) {
        if (this.namespacePipe == null) {
            super.setConsumer(consumer);
        } else {
            this.namespacePipe.setConsumer(consumer);
            super.setConsumer(this.namespacePipe);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        if (this.namespacePipe == null) {
            super.setContentHandler(handler);
        } else {
            this.namespacePipe.setContentHandler(handler);
            super.setContentHandler(this.namespacePipe);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        if (this.namespacePipe == null) {
            super.setLexicalHandler(handler);
        } else {
            this.namespacePipe.setLexicalHandler(handler);
            super.setLexicalHandler(this.namespacePipe);
        }
    }

    protected SAXTransformerFactory getTransformerFactory() {
        return this.tfactory;
    }

    protected TransformerHandler getTransformerHandler() throws TransformerException {
        return this.getTransformerFactory().newTransformerHandler();
    }

    public void setOutputStream(OutputStream out) throws IOException {
        super.setOutputStream(out);
    }

    public void contextualize(Context context) throws ContextException {
        String defaultEncoding = (String)context.get((Object)"default-encoding");
        if (defaultEncoding != null) {
            this.format.setProperty("encoding", defaultEncoding);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void configure(Configuration conf) throws ConfigurationException {
        cdataSectionElements = conf.getChild("cdata-section-elements");
        dtPublic = conf.getChild("doctype-public");
        dtSystem = conf.getChild("doctype-system");
        encoding = conf.getChild("encoding");
        indent = conf.getChild("indent");
        mediaType = conf.getChild("media-type");
        method = conf.getChild("method");
        omitXMLDeclaration = conf.getChild("omit-xml-declaration");
        standAlone = conf.getChild("standalone");
        version = conf.getChild("version");
        if (!cdataSectionElements.getLocation().equals("-")) {
            this.format.put("cdata-section-elements", cdataSectionElements.getValue());
        }
        if (!dtPublic.getLocation().equals("-")) {
            this.format.put("doctype-public", dtPublic.getValue());
        }
        if (!dtSystem.getLocation().equals("-")) {
            this.format.put("doctype-system", dtSystem.getValue());
        }
        if (!encoding.getLocation().equals("-")) {
            this.format.put("encoding", encoding.getValue());
        }
        if (!indent.getLocation().equals("-")) {
            this.format.put("indent", indent.getValue());
        }
        if (!mediaType.getLocation().equals("-")) {
            this.format.put("media-type", mediaType.getValue());
        }
        if (!method.getLocation().equals("-")) {
            this.format.put("method", method.getValue());
        }
        if (!omitXMLDeclaration.getLocation().equals("-")) {
            this.format.put("omit-xml-declaration", omitXMLDeclaration.getValue());
        }
        if (!standAlone.getLocation().equals("-")) {
            this.format.put("standalone", standAlone.getValue());
        }
        if (!version.getLocation().equals("-")) {
            this.format.put("version", version.getValue());
        }
        if ((tFactoryConf = conf.getChild("transformer-factory", false)) != null) {
            tFactoryClass = tFactoryConf.getValue();
            try {
                this.tfactory = (SAXTransformerFactory)ClassUtils.newInstance(tFactoryClass);
                if (!this.getLogger().isDebugEnabled()) ** GOTO lbl51
                this.getLogger().debug("Using transformer factory " + tFactoryClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load transformer factory " + tFactoryClass, (Throwable)e);
            }
        } else {
            this.tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
lbl51:
        // 3 sources

        this.tfactory.setErrorListener(new TraxErrorHandler(this.getLogger()));
        try {
            if (this.needsNamespacesAsAttributes()) {
                this.namespacePipe = new NamespaceAsAttributes();
                this.namespacePipe.enableLogging(this.getLogger());
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Cannot know if transformer needs namespaces attributes - assuming NO.", (Throwable)e);
        }
    }

    public void recycle() {
        super.recycle();
        if (this.namespacePipe != null) {
            this.namespacePipe.recycle();
        }
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    protected boolean needsNamespacesAsAttributes() throws Exception {
        SAXTransformerFactory factory = this.getTransformerFactory();
        Boolean cacheValue = (Boolean)needsNamespaceCache.get(factory.getClass().getName());
        if (cacheValue != null) {
            return cacheValue;
        }
        StringWriter writer = new StringWriter();
        String uri = "namespaceuri";
        String prefix = "nsp";
        String check = "xmlns:" + prefix + "='" + uri + "'";
        TransformerHandler handler = this.getTransformerHandler();
        handler.getTransformer().setOutputProperties(this.format);
        handler.setResult(new StreamResult(writer));
        handler.startDocument();
        handler.startPrefixMapping(prefix, uri);
        handler.startElement(uri, "element", "", new AttributesImpl());
        handler.endPrefixMapping(prefix);
        handler.endDocument();
        String text = writer.toString();
        boolean needsIt = text.replace('\"', '\'').indexOf(check) == -1;
        String msg = needsIt ? " needs namespace attributes (will be slower)." : " handles correctly namespaces.";
        this.getLogger().debug("Trax handler " + handler.getClass().getName() + msg);
        needsNamespaceCache.put(factory.getClass().getName(), new Boolean(needsIt));
        return needsIt;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public static class NamespaceAsAttributes
    extends AbstractXMLPipe {
        private List prefixList = new ArrayList();
        private List uriList = new ArrayList();
        private Map uriToPrefixMap = new HashMap();
        private Map prefixToUriMap = new HashMap();
        private boolean hasMappings = false;

        public void startDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            super.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (uri != null && !prefix.startsWith("xml")) {
                this.hasMappings = true;
                this.prefixList.add(prefix);
                this.uriList.add(uri);
                if (prefix.length() > 0) {
                    this.uriToPrefixMap.put(uri, prefix + ":");
                } else {
                    this.uriToPrefixMap.put(uri, prefix);
                }
                this.prefixToUriMap.put(prefix, uri);
            }
            super.startPrefixMapping(prefix, uri);
        }

        public void startElement(String eltUri, String eltLocalName, String eltQName, Attributes attrs) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = (String)this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            if (this.hasMappings) {
                AttributesImpl newAttrs = null;
                int mappingCount = this.prefixList.size();
                int attrCount = attrs.getLength();
                for (int mapping = 0; mapping < mappingCount; ++mapping) {
                    String uri = (String)this.uriList.get(mapping);
                    String prefix = (String)this.prefixList.get(mapping);
                    String qName = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                    boolean found = false;
                    for (int attr = 0; attr < attrCount; ++attr) {
                        if (!qName.equals(attrs.getQName(attr))) continue;
                        if (!uri.equals(attrs.getValue(attr))) {
                            this.getLogger().error("URI in prefix mapping and attribute do not match : '" + uri + "' - '" + attrs.getURI(attr) + "'");
                            throw new SAXException("URI in prefix mapping and attribute do not match");
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (newAttrs == null) {
                        newAttrs = attrCount == 0 ? new AttributesImpl() : new AttributesImpl(attrs);
                    }
                    if (prefix.equals("")) {
                        newAttrs.addAttribute("http://www.w3.org/XML/1998/namespace", "xmlns", "xmlns", "CDATA", uri);
                        continue;
                    }
                    newAttrs.addAttribute("http://www.w3.org/XML/1998/namespace", prefix, qName, "CDATA", uri);
                }
                this.clearMappings();
                super.startElement(eltUri, eltLocalName, eltQName, newAttrs == null ? attrs : newAttrs);
            } else {
                super.startElement(eltUri, eltLocalName, eltQName, attrs);
            }
        }

        public void endElement(String eltUri, String eltLocalName, String eltQName) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = (String)this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            super.endElement(eltUri, eltLocalName, eltQName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            int pos;
            if (this.prefixToUriMap.containsKey(prefix)) {
                this.uriToPrefixMap.remove(this.prefixToUriMap.get(prefix));
                this.prefixToUriMap.remove(prefix);
            }
            if (this.hasMappings && (pos = this.prefixList.lastIndexOf(prefix)) != -1) {
                this.prefixList.remove(pos);
                this.uriList.remove(pos);
            }
            super.endPrefixMapping(prefix);
        }

        public void endDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            super.endDocument();
        }

        private void clearMappings() {
            this.hasMappings = false;
            this.prefixList.clear();
            this.uriList.clear();
        }
    }
}

