/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.xpointer.XPointer;
import org.apache.cocoon.components.xpointer.XPointerContext;
import org.apache.cocoon.components.xpointer.parser.ParseException;
import org.apache.cocoon.components.xpointer.parser.XPointerFrameworkParser;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLBaseSupport;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XIncludeTransformer
extends AbstractTransformer
implements Composable {
    protected SourceResolver resolver;
    protected ComponentManager manager;
    private XIncludePipe xIncludePipe;
    public static final String XMLBASE_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLBASE_ATTRIBUTE = "base";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    public static final String XINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String XINCLUDE_FALLBACK_ELEMENT = "fallback";
    public static final String XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE = "href";
    public static final String XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE = "parse";

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        this.xIncludePipe = new XIncludePipe();
        this.xIncludePipe.enableLogging(this.getLogger());
        this.xIncludePipe.init(null);
        super.setConsumer(this.xIncludePipe);
    }

    public void setConsumer(XMLConsumer consumer) {
        this.xIncludePipe.setConsumer(consumer);
    }

    public void setContentHandler(ContentHandler handler) {
        this.xIncludePipe.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.xIncludePipe.setLexicalHandler(handler);
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void recycle() {
        this.resolver = null;
        this.xIncludePipe = null;
        super.recycle();
    }

    private class XIncludePipe
    extends AbstractXMLPipe {
        private XMLBaseSupport xmlBaseSupport;
        private int xIncludeLevel = 0;
        private boolean useFallback = false;
        private int fallbackLevel;
        private Exception fallBackException;
        private Locator locator;
        private String href;
        private XIncludePipe parent;

        private XIncludePipe() {
        }

        public void init(String uri) {
            this.href = uri;
            this.xmlBaseSupport = new XMLBaseSupport(XIncludeTransformer.this.resolver, this.getLogger());
        }

        public void setParent(XIncludePipe parent) {
            this.parent = parent;
        }

        public XIncludePipe getParent() {
            return this.parent;
        }

        public String getHref() {
            return this.href;
        }

        public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
            if (this.xIncludeLevel == 1 && this.useFallback && uri.equals(XIncludeTransformer.XINCLUDE_NAMESPACE_URI) && name.equals(XIncludeTransformer.XINCLUDE_FALLBACK_ELEMENT)) {
                ++this.fallbackLevel;
                this.useFallback = false;
                this.fallBackException = null;
                return;
            }
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                ++this.xIncludeLevel;
                return;
            }
            this.xmlBaseSupport.startElement(uri, name, raw, attr);
            if (XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT.equals(name) && XIncludeTransformer.XINCLUDE_NAMESPACE_URI.equals(uri)) {
                String href = attr.getValue("", XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE);
                String parse = attr.getValue("", XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE);
                if (null == parse) {
                    parse = "xml";
                }
                ++this.xIncludeLevel;
                try {
                    this.processXIncludeElement(href, parse);
                }
                catch (ProcessingException e) {
                    this.getLogger().debug("Rethrowing exception", (Throwable)((Object)e));
                    throw new SAXException((Exception)((Object)e));
                }
                catch (IOException e) {
                    this.getLogger().debug("Rethrowing exception", (Throwable)e);
                    throw new SAXException(e);
                }
                return;
            }
            super.startElement(uri, name, raw, attr);
        }

        public void endElement(String uri, String name, String raw) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                --this.xIncludeLevel;
                if (this.xIncludeLevel == 0) {
                    this.xmlBaseSupport.endElement(uri, name, raw);
                }
                if (this.xIncludeLevel == 0 && this.useFallback) {
                    this.useFallback = false;
                    Exception localFallBackException = this.fallBackException;
                    this.fallBackException = null;
                    this.fallbackLevel = 0;
                    this.getLogger().error("Exception occured during xinclude processing, and did not find a fallback element.", (Throwable)localFallBackException);
                    throw new SAXException("Exception occured during xinclude processing, and did not find a fallback element: " + localFallBackException.getMessage());
                }
                return;
            }
            if (this.fallbackLevel > 0) {
                --this.fallbackLevel;
                if (this.fallbackLevel == 0) {
                    return;
                }
            }
            this.xmlBaseSupport.endElement(uri, name, raw);
            super.endElement(uri, name, raw);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.endPrefixMapping(prefix);
        }

        public void characters(char[] c, int start, int len) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.characters(c, start, len);
        }

        public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.ignorableWhitespace(c, start, len);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.processingInstruction(target, data);
        }

        public void skippedEntity(String name) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.skippedEntity(name);
        }

        public void startEntity(String name) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.startEntity(name);
        }

        public void endEntity(String name) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.endEntity(name);
        }

        public void startCDATA() throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.startCDATA();
        }

        public void endCDATA() throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.endCDATA();
        }

        public void comment(char[] ch, int start, int len) throws SAXException {
            if (this.xIncludeLevel > 0 && this.fallbackLevel < 1) {
                return;
            }
            super.comment(ch, start, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDocumentLocator(Locator locator) {
            block7: {
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("setDocumentLocator called " + locator.getSystemId());
                    }
                    if (locator.getSystemId() == null) break block7;
                    Source source = XIncludeTransformer.this.resolver.resolveURI(locator.getSystemId());
                    try {
                        this.xmlBaseSupport.setDocumentLocation(source.getURI());
                        if (this.href == null) {
                            this.href = source.getURI();
                        }
                    }
                    finally {
                        XIncludeTransformer.this.resolver.release(source);
                    }
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("Error in XIncludeTransformer while trying to resolve base URL for document", (Throwable)e);
                }
            }
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void processXIncludeElement(String href, String parse) throws SAXException, ProcessingException, IOException {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processing XInclude element: href=" + href + ", parse=" + parse);
            }
            Source url = null;
            String suffix = "";
            try {
                try {
                    String canonicURI;
                    int fragmentIdentifierPos = href.indexOf(35);
                    if (fragmentIdentifierPos != -1) {
                        suffix = href.substring(fragmentIdentifierPos + 1);
                        href = href.substring(0, fragmentIdentifierPos);
                    }
                    if (href.equals("")) {
                        if (this.href == null) {
                            throw new SAXException("XIncludeTransformer: encountered empty href (= href pointing to the current document) but the location of the current document is unknown.");
                        }
                        int fragmentIdentifierPos2 = this.href.indexOf(35);
                        href = fragmentIdentifierPos2 != -1 ? this.href.substring(0, fragmentIdentifierPos2) : this.href;
                    }
                    url = this.xmlBaseSupport.makeAbsolute(href);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("URL: " + url.getURI() + "\nSuffix: " + suffix);
                    }
                    if (this.isLoopInclusion(canonicURI = url.getURI() + (suffix.length() > 0 ? "#" + suffix : ""))) {
                        throw new ProcessingException("Detected loop inclusion of " + canonicURI);
                    }
                    if (parse.equals("text")) {
                        this.getLogger().debug("Parse type is text");
                        InputStream input = url.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                        char[] ary = new char[1024];
                        if (reader != null) {
                            int read;
                            while ((read = reader.read(ary)) != -1) {
                                super.characters(ary, 0, read);
                            }
                            ((Reader)reader).close();
                        }
                    } else if (parse.equals("xml")) {
                        XIncludePipe subPipe = new XIncludePipe();
                        subPipe.enableLogging(this.getLogger());
                        subPipe.init(canonicURI);
                        subPipe.setConsumer(this.xmlConsumer);
                        subPipe.setParent(this);
                        this.getLogger().debug("Parse type is XML");
                        try {
                            if (suffix.length() > 0) {
                                XPointer xpointer = XPointerFrameworkParser.parse(NetUtils.decodePath(suffix));
                                XPointerContext context = new XPointerContext(suffix, url, subPipe, this.getLogger(), XIncludeTransformer.this.manager);
                                xpointer.process(context);
                            } else {
                                SourceUtil.toSAX(url, new IncludeXMLConsumer(subPipe));
                            }
                            if (this.locator != null) {
                                this.xmlConsumer.setDocumentLocator(this.locator);
                            }
                        }
                        catch (ResourceNotFoundException e) {
                            this.useFallback = true;
                            this.fallBackException = new CascadingException("Resouce not found: " + url.getURI());
                            this.getLogger().error("xIncluded resource not found: " + url.getURI(), (Throwable)((Object)e));
                        }
                        catch (ParseException e) {
                            this.useFallback = true;
                            this.fallBackException = new CascadingException("Error parsing xPointer expression", (Throwable)e);
                            this.fallBackException.fillInStackTrace();
                            this.getLogger().error("Error parsing XPointer expression, will try to use fallback.", (Throwable)e);
                        }
                        catch (SAXException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)e);
                            throw e;
                        }
                        catch (ProcessingException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)((Object)e));
                            throw e;
                        }
                        catch (MalformedURLException e) {
                            this.useFallback = true;
                            this.fallBackException = e;
                            this.getLogger().error("Error processing an xInclude, will try to use fallback.", (Throwable)e);
                        }
                        catch (IOException e) {
                            this.useFallback = true;
                            this.fallBackException = e;
                            this.getLogger().error("Error processing an xInclude, will try to use fallback.", (Throwable)e);
                        }
                    }
                    Object var12_22 = null;
                    if (url == null) return;
                }
                catch (SourceException se) {
                    throw SourceUtil.handle(se);
                }
            }
            catch (Throwable throwable) {
                Object var12_23 = null;
                if (url == null) throw throwable;
                XIncludeTransformer.this.resolver.release(url);
                throw throwable;
            }
            XIncludeTransformer.this.resolver.release(url);
        }

        public boolean isLoopInclusion(String uri) {
            if (uri.equals(this.href)) {
                return true;
            }
            for (XIncludePipe parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!uri.equals(parent.getHref())) continue;
                return true;
            }
            return false;
        }
    }
}

