/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.jxpath;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMFactory
extends AbstractFactory {
    public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
        this.addDOMElement((Element)parent, index, name);
        return true;
    }

    private void addDOMElement(Element parent, int index, String tag) {
        int pos = tag.indexOf(58);
        String prefix = null;
        if (pos != -1) {
            prefix = tag.substring(0, pos);
        }
        String uri = this.getNamespaceURI(parent, prefix);
        int count = 0;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(tag)) continue;
            ++count;
        }
        while (count <= index) {
            Element newElement = parent.getOwnerDocument().createElementNS(uri, tag);
            parent.appendChild(newElement);
            ++count;
        }
    }

    public String getNamespaceURI(Element element, String prefix) {
        String nsAttr;
        String string = nsAttr = prefix == null ? "xmlns" : "xmlns:" + prefix;
        for (Node tmp = element; tmp != null && tmp.getNodeType() == 1; tmp = tmp.getParentNode()) {
            element = tmp;
            if (prefix == null ? element.getPrefix() == null : prefix.equals(element.getPrefix())) {
                return element.getNamespaceURI();
            }
            String namespace = tmp.getAttribute(nsAttr);
            if (namespace == null) continue;
            return namespace;
        }
        return null;
    }

    public boolean declareVariable(JXPathContext context, String name) {
        return false;
    }
}

