/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractConfigurableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class SessionPropagatorAction
extends AbstractConfigurableAction
implements ThreadSafe {
    private Object[] defaults = new Object[0];

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.defaults = this.settings.keySet().toArray();
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Request req = ObjectModelHelper.getRequest(objectModel);
        HashMap<String, String> actionMap = new HashMap<String, String>();
        Session session = req.getSession(false);
        if (session == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No session object");
            }
            return null;
        }
        try {
            String value;
            String sessionParamName;
            int i;
            String[] names = parameters.getNames();
            for (i = 0; i < names.length; ++i) {
                sessionParamName = names[i];
                value = parameters.getParameter(sessionParamName);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Propagating value " + value + " to session attribute " + sessionParamName);
                }
                session.setAttribute(sessionParamName, value);
                actionMap.put(sessionParamName, value);
            }
            for (i = 0; i < this.defaults.length; ++i) {
                if (actionMap.containsKey(this.defaults[i])) continue;
                sessionParamName = (String)this.defaults[i];
                value = parameters.getParameter(sessionParamName);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Propagating value " + value + " to session attribute " + sessionParamName);
                }
                session.setAttribute(sessionParamName, value);
                actionMap.put(sessionParamName, value);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("All params propagated to session");
            }
            return Collections.unmodifiableMap(actionMap);
        }
        catch (Exception e) {
            this.getLogger().warn("exception: ", (Throwable)e);
            return null;
        }
    }
}

