/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.output;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.modules.output.AbstractOutputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Session;

public class SessionAttributeOutputModule
extends AbstractOutputModule
implements OutputModule {
    public final String PREFIX = "org.apache.cocoon.components.modules.output.OutputModule";
    public final String TRANS_PREFIX = "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.transient";
    public final String ROLLBACK_LIST = "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.rollback";

    public void setAttribute(Configuration modeConf, Map objectModel, String name, Object value) {
        if (this.settings.get("isolation-level", "0").equals("1")) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("setting transient ['" + name + "'] to ['" + value + "']");
            }
            this.transientSetAttribute(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.transient", name, value);
        } else {
            Session session = ObjectModelHelper.getRequest(objectModel).getSession();
            if (!this.attributeExists(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.rollback", name = this.getName(name))) {
                Object tmp = session.getAttribute(name);
                this.transientSetAttribute(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.rollback", name, tmp);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("setting ['" + name + "'] to ['" + value + "']");
            }
            session.setAttribute(name, value);
        }
    }

    public void rollback(Configuration modeConf, Map objectModel, Exception e) {
        String prefix;
        if (this.settings.get("isolation-level", "0").equals("1")) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("rolling back");
            }
            this.rollback(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.transient");
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("start rolling back");
            }
            Session session = ObjectModelHelper.getRequest(objectModel).getSession();
            Map tmp = this.prepareCommit(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.rollback");
            if (tmp != null) {
                Map rollbackList = tmp;
                Iterator iter = rollbackList.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object val = rollbackList.get(key);
                    if (val != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("rolling back ['" + key + "'] to ['" + val + "']");
                        }
                        session.setAttribute(key, val);
                        continue;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("rolling back ['" + key + "']");
                    }
                    session.removeAttribute(key);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done rolling back");
        }
        if ((prefix = (String)this.settings.get("key-prefix", "org.apache.cocoon.components.modules.output.OutputModule")) != "") {
            ObjectModelHelper.getRequest(objectModel).getSession().setAttribute(prefix + ":", e.getMessage());
        } else {
            ObjectModelHelper.getRequest(objectModel).getSession().setAttribute("errorMessage", e.getMessage());
        }
    }

    public void commit(Configuration modeConf, Map objectModel) {
        if (this.settings.get("isolation-level", "0").equals("1")) {
            Map aMap;
            Logger logger = this.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("prepare commit");
            }
            if ((aMap = this.prepareCommit(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.transient")) == null) {
                return;
            }
            Iterator iter = aMap.keySet().iterator();
            if (!iter.hasNext()) {
                return;
            }
            String prefix = (String)this.settings.get("key-prefix", "org.apache.cocoon.components.modules.output.OutputModule");
            prefix = prefix != "" ? prefix + ":" : null;
            Session session = ObjectModelHelper.getRequest(objectModel).getSession();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = aMap.get(key);
                if (prefix != null) {
                    key = prefix + key;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("committing ['" + key + "'] to ['" + value + "']");
                }
                session.setAttribute(key, value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("done commit");
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("commit");
            }
            this.prepareCommit(objectModel, "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.rollback");
        }
    }

    protected String getName(String name) {
        String prefix = (String)this.settings.get("key-prefix", "org.apache.cocoon.components.modules.output.OutputModule");
        return prefix == "" ? name : prefix + ":" + name;
    }
}

