/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.ContainerNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelinesNode;

public class PipelinesNodeBuilder
extends ContainerNodeBuilder
implements ThreadSafe {
    public ProcessingNode buildNode(Configuration config) throws Exception {
        Configuration child = config.getChild("component-configurations", false);
        if (child != null) {
            this.checkNamespace(child);
            this.treeBuilder.getProcessor().setComponentConfigurations(child);
        }
        PipelinesNode node = new PipelinesNode();
        this.treeBuilder.setupNode(node, config);
        Configuration[] childConfigs = config.getChildren();
        ArrayList<ProcessingNode> children = new ArrayList<ProcessingNode>();
        HandleErrorsNode handler = null;
        for (int i = 0; i < childConfigs.length; ++i) {
            Configuration childConfig = childConfigs[i];
            if (!this.isChild(childConfig)) continue;
            ProcessingNodeBuilder builder = this.treeBuilder.createNodeBuilder(childConfig);
            if (builder instanceof HandleErrorsNodeBuilder) {
                handler = (HandleErrorsNode)builder.buildNode(childConfig);
                continue;
            }
            children.add(builder.buildNode(childConfig));
        }
        if (children.size() == 0) {
            String msg = "There must be at least one pipeline at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
        node.setChildren(PipelinesNodeBuilder.toNodeArray(children));
        node.setErrorHandler(handler);
        return node;
    }
}

