/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class MethodDeclaration
extends BodyDeclaration {
    private static final int LEGAL_MODIFIERS = 3391;
    private boolean isConstructor = false;
    private int modifiers = 0;
    private SimpleName methodName = null;
    private ASTNode.NodeList parameters;
    private Type returnType;
    private int extraArrayDimensions;
    private ASTNode.NodeList thrownExceptions;
    private Block optionalBody;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    MethodDeclaration(AST ast) {
        super(ast);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.SingleVariableDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.parameters = new ASTNode.NodeList(true, clazz);
        this.returnType = null;
        this.extraArrayDimensions = 0;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.Name");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.thrownExceptions = new ASTNode.NodeList(false, clazz2);
        this.optionalBody = null;
    }

    public int getNodeType() {
        return 31;
    }

    ASTNode clone(AST target) {
        MethodDeclaration result = new MethodDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        result.setModifiers(this.getModifiers());
        result.setConstructor(this.isConstructor());
        result.setReturnType((Type)ASTNode.copySubtree(target, this.getReturnType()));
        result.setExtraDimensions(this.getExtraDimensions());
        result.setName((SimpleName)this.getName().clone(target));
        result.parameters().addAll(ASTNode.copySubtrees(target, this.parameters()));
        result.thrownExceptions().addAll(ASTNode.copySubtrees(target, this.thrownExceptions()));
        result.setBody((Block)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            this.acceptChild(visitor, this.getReturnType());
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.parameters);
            this.acceptChildren(visitor, this.thrownExceptions);
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.modifying();
        this.isConstructor = isConstructor;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        if ((modifiers & 0xFFFFF2C0) != 0) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.modifiers = modifiers;
    }

    public SimpleName getName() {
        if (this.methodName == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.methodName;
    }

    public void setName(SimpleName methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.methodName, methodName, false);
        this.methodName = methodName;
    }

    public List parameters() {
        return this.parameters;
    }

    public List thrownExceptions() {
        return this.thrownExceptions;
    }

    public Type getReturnType() {
        if (this.returnType == null) {
            long count = this.getAST().modificationCount();
            this.setReturnType(this.getAST().newPrimitiveType(PrimitiveType.VOID));
            this.getAST().setModificationCount(count);
        }
        return this.returnType;
    }

    public void setReturnType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.returnType, type, false);
        this.returnType = type;
    }

    public int getExtraDimensions() {
        return this.extraArrayDimensions;
    }

    public void setExtraDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.extraArrayDimensions = dimensions;
    }

    public Block getBody() {
        return this.optionalBody;
    }

    public void setBody(Block body) {
        this.replaceChild(this.optionalBody, body, true);
        this.optionalBody = body;
    }

    public IMethodBinding resolveBinding() {
        return this.getAST().getBindingResolver().resolveMethod(this);
    }

    void appendDebugString(StringBuffer buffer) {
        buffer.append("MethodDeclaration[");
        buffer.append(this.isConstructor() ? "constructor " : "method ");
        buffer.append(this.getName().getIdentifier());
        buffer.append("(");
        Iterator it = this.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration d = (SingleVariableDeclaration)it.next();
            d.getType().appendPrintString(buffer);
            if (!it.hasNext()) continue;
            buffer.append(";");
        }
        buffer.append(")");
        if (!this.isConstructor()) {
            buffer.append(" returns ");
            this.getReturnType().appendPrintString(buffer);
        }
        buffer.append("]");
    }

    int memSize() {
        return super.memSize() + 32;
    }

    int treeSize() {
        return this.memSize() + (this.getJavadoc() == null ? 0 : this.getJavadoc().treeSize()) + (this.methodName == null ? 0 : this.getName().treeSize()) + (this.returnType == null ? 0 : this.getReturnType().treeSize()) + this.parameters.listSize() + this.thrownExceptions.listSize() + (this.optionalBody == null ? 0 : this.getBody().treeSize());
    }
}

