/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Type;

public class PrimitiveType
extends Type {
    public static final Code INT = new Code("int");
    public static final Code CHAR = new Code("char");
    public static final Code BOOLEAN = new Code("boolean");
    public static final Code SHORT = new Code("short");
    public static final Code LONG = new Code("long");
    public static final Code FLOAT = new Code("float");
    public static final Code DOUBLE = new Code("double");
    public static final Code BYTE = new Code("byte");
    public static final Code VOID = new Code("void");
    private Code typeCode = INT;
    private static final Map CODES = new HashMap(20);

    static {
        Code[] ops = new Code[]{INT, BYTE, CHAR, BOOLEAN, SHORT, LONG, FLOAT, DOUBLE, VOID};
        int i = 0;
        while (i < ops.length) {
            CODES.put(ops[i].toString(), ops[i]);
            ++i;
        }
    }

    public static Code toCode(String token) {
        return (Code)CODES.get(token);
    }

    PrimitiveType(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 39;
    }

    ASTNode clone(AST target) {
        PrimitiveType result = new PrimitiveType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setPrimitiveTypeCode(this.getPrimitiveTypeCode());
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public Code getPrimitiveTypeCode() {
        return this.typeCode;
    }

    public void setPrimitiveTypeCode(Code typeCode) {
        if (typeCode == null) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.typeCode = typeCode;
    }

    int memSize() {
        return 40;
    }

    int treeSize() {
        return this.memSize();
    }

    public static class Code {
        private String name;

        Code(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

