/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.complete;

import org.eclipse.jdt.internal.codeassist.complete.CompletionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CompletionOnQualifiedNameReference
extends QualifiedNameReference {
    public char[] completionIdentifier;
    public long[] sourcePositions;

    public CompletionOnQualifiedNameReference(char[][] previousIdentifiers, char[] completionIdentifier, long[] positions) {
        super(previousIdentifiers, (int)(positions[0] >>> 32), (int)positions[positions.length - 1]);
        this.completionIdentifier = completionIdentifier;
        this.sourcePositions = positions;
    }

    public CompletionOnQualifiedNameReference(char[][] previousIdentifiers, char[] completionIdentifier, int sourceStart, int sourceEnd) {
        super(previousIdentifiers, sourceStart, sourceEnd);
        this.completionIdentifier = completionIdentifier;
        this.sourcePositions = new long[]{((long)sourceStart << 32) + (long)sourceEnd};
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.binding = scope.getBinding(this.tokens, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding instanceof ProblemFieldBinding) {
                scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
            } else if (this.binding instanceof ProblemReferenceBinding) {
                scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
            } else {
                scope.problemReporter().unresolvableReference(this, this.binding);
            }
            throw new CompletionNodeFound();
        }
        throw new CompletionNodeFound(this, this.binding, scope);
    }

    public String toStringExpression() {
        StringBuffer buffer = new StringBuffer("<CompleteOnName:");
        int i = 0;
        while (i < this.tokens.length) {
            buffer.append(this.tokens[i]);
            buffer.append(".");
            ++i;
        }
        buffer.append(this.completionIdentifier).append(">");
        return buffer.toString();
    }
}

