/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IDebugRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public Parser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;
    public static IDebugRequestor DebugRequestor = null;

    public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, final ICompilerRequestor requestor, IProblemFactory problemFactory) {
        this.options = new CompilerOptions(settings);
        this.requestor = DebugRequestor == null ? requestor : new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(result);
                }
                requestor.acceptResult(result);
            }
        };
        this.problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, environment);
        this.parser = new Parser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants, this.options.sourceLevel >= 3);
    }

    public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, final ICompilerRequestor requestor, IProblemFactory problemFactory, boolean parseLiteralExpressionsAsConstants) {
        this.options = new CompilerOptions(settings);
        this.requestor = DebugRequestor == null ? requestor : new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(result);
                }
                requestor.acceptResult(result);
            }
        };
        this.problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, environment);
        this.parser = new Parser(this.problemReporter, parseLiteralExpressionsAsConstants, this.options.sourceLevel >= 3);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(ICompilationUnit sourceUnit) {
        CompilationResult unitResult = new CompilationResult(sourceUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        try {
            CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
            if (this.options.verbose) {
                String count = String.valueOf(this.totalUnits + 1);
                System.out.println(Util.bind("compilation.request", new String[]{count, count, new String(sourceUnit.getFileName())}));
            }
            this.lookupEnvironment.buildTypeBindings(parsedUnit);
            this.addCompilationUnit(sourceUnit, parsedUnit);
            this.lookupEnvironment.completeTypeBindings(parsedUnit);
        }
        catch (AbortCompilationUnit e) {
            if (unitResult.compilationUnit == sourceUnit) {
                this.requestor.acceptResult(unitResult.tagAsAccepted());
            }
            throw e;
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        this.problemReporter.abortDueToInternalError(Util.bind("abort.againstSourceModel ", String.valueOf(sourceTypes[0].getName()), String.valueOf(sourceTypes[0].getFileName())));
    }

    protected void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
        int size = this.unitsToProcess.length;
        if (this.totalUnits == size) {
            this.unitsToProcess = new CompilationUnitDeclaration[size * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = parsedUnit;
    }

    protected void beginToCompile(ICompilationUnit[] sourceUnits) {
        int maxUnits = sourceUnits.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[maxUnits];
        int i = 0;
        while (i < maxUnits) {
            Object var6_6;
            CompilationResult unitResult = new CompilationResult(sourceUnits[i], i, maxUnits, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnits[i], unitResult) : this.parser.dietParse(sourceUnits[i], unitResult);
                if (this.options.verbose) {
                    System.out.println(Util.bind("compilation.request", new String[]{String.valueOf(i + 1), String.valueOf(maxUnits), new String(sourceUnits[i].getFileName())}));
                }
                this.lookupEnvironment.buildTypeBindings(parsedUnit);
                this.addCompilationUnit(sourceUnits[i], parsedUnit);
            }
            catch (Throwable throwable) {
                var6_6 = null;
                sourceUnits[i] = null;
                throw throwable;
            }
            var6_6 = null;
            sourceUnits[i] = null;
            ++i;
        }
        this.lookupEnvironment.completeTypeBindings();
    }

    public void compile(ICompilationUnit[] sourceUnits) {
        CompilationUnitDeclaration unit = null;
        int i = 0;
        try {
            try {
                this.beginToCompile(sourceUnits);
                while (i < this.totalUnits) {
                    Object var4_4;
                    unit = this.unitsToProcess[i];
                    try {
                        if (this.options.verbose) {
                            System.out.println(Util.bind("compilation.process", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                        }
                        this.process(unit, i);
                    }
                    catch (Throwable throwable) {
                        var4_4 = null;
                        unit.cleanUp();
                        if (this.options.verbose) {
                            System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                        }
                        throw throwable;
                    }
                    var4_4 = null;
                    unit.cleanUp();
                    if (this.options.verbose) {
                        System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                    }
                    this.unitsToProcess[i] = null;
                    this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
                    ++i;
                }
            }
            catch (AbortCompilation e) {
                this.handleInternalException(e, unit);
            }
            catch (Error e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
            catch (RuntimeException e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.reset();
            throw throwable;
        }
        Object var6_11 = null;
        this.reset();
        if (this.options.verbose) {
            if (this.totalUnits > 1) {
                System.out.println(Util.bind("compilation.units", String.valueOf(this.totalUnits)));
            } else {
                System.out.println(Util.bind("compilation.unit", String.valueOf(this.totalUnits)));
            }
        }
    }

    protected void getMethodBodies(CompilationUnitDeclaration unit, int place) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        if (place < this.parseThreshold) {
            return;
        }
        this.parser.scanner.setSource(unit.compilationResult.compilationUnit.getContents());
        if (unit.types != null) {
            int i = unit.types.length;
            while (--i >= 0) {
                unit.types[i].parseMethod(this.parser, unit);
            }
        }
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        internalException.printStackTrace();
        if (unit != null) {
            result = unit.compilationResult;
        }
        if (result == null && this.unitsToProcess != null && this.totalUnits > 0) {
            result = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (result != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            internalException.printStackTrace(writer);
            StringBuffer buffer = stringWriter.getBuffer();
            String[] pbArguments = new String[]{String.valueOf(Util.bind("compilation.internalError")) + "\n" + buffer.toString()};
            result.record(this.problemReporter.createProblem(result.getFileName(), 0, pbArguments, pbArguments, 1, 0, 0, 0, unit, result), unit);
            if (!result.hasBeenAccepted) {
                this.requestor.acceptResult(result.tagAsAccepted());
            }
        }
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        if (abortException.isSilent) {
            if (abortException.silentException == null) {
                return;
            }
            throw abortException.silentException;
        }
        CompilationResult result = abortException.compilationResult;
        if (result == null && unit != null) {
            result = unit.compilationResult;
        }
        if (result == null && this.unitsToProcess != null && this.totalUnits > 0) {
            result = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (result != null && !result.hasBeenAccepted) {
            if (abortException.problemId != 0) {
                result.record(this.problemReporter.createProblem(result.getFileName(), abortException.problemId, abortException.problemArguments, abortException.messageArguments, 1, 0, 0, 0, unit, result), unit);
            } else if (abortException.exception != null) {
                this.handleInternalException(abortException.exception, null, result);
                return;
            }
            if (!result.hasBeenAccepted) {
                this.requestor.acceptResult(result.tagAsAccepted());
            }
        } else {
            abortException.printStackTrace();
        }
    }

    public void process(CompilationUnitDeclaration unit, int i) {
        this.getMethodBodies(unit, i);
        if (unit.scope != null) {
            unit.scope.faultInTypes();
        }
        if (unit.scope != null) {
            unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
        }
        unit.resolve();
        unit.analyseCode();
        unit.generateCode();
        if (this.options.produceReferenceInfo && unit.scope != null) {
            unit.scope.storeDependencyInfo();
        }
        unit.compilationResult.totalUnitsKnown = this.totalUnits;
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
        if (DebugRequestor != null) {
            DebugRequestor.reset();
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        CompilationUnitDeclaration unit = null;
        try {
            this.parseThreshold = 0;
            this.beginToCompile(new ICompilationUnit[]{sourceUnit});
            unit = this.unitsToProcess[0];
            this.getMethodBodies(unit, 0);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                if (analyzeCode) {
                    unit.analyseCode();
                }
                if (generateCode) {
                    unit.generateCode();
                }
            }
            this.unitsToProcess[0] = null;
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }
}

