/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.IQueryResult;
import org.eclipse.jdt.internal.core.index.impl.JarFileEntryDocument;
import org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

class AddJarFileToIndex
extends IndexRequest {
    IFile resource;

    public AddJarFileToIndex(IFile resource, IndexManager manager) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
    }

    public AddJarFileToIndex(IPath indexPath, IndexManager manager) {
        super(indexPath, manager);
    }

    public boolean belongsTo(String projectNameOrJarPath) {
        return super.belongsTo(projectNameOrJarPath) || projectNameOrJarPath.equals(this.indexPath.toString());
    }

    public boolean equals(Object o) {
        if (o instanceof AddJarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals((Object)((AddJarFileToIndex)o).resource);
            }
            if (this.indexPath != null) {
                return this.indexPath.equals((Object)((AddJarFileToIndex)o).indexPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.indexPath != null) {
            return this.indexPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            ZipFile zip;
            ReadWriteMonitor monitor;
            block40: {
                block38: {
                    block39: {
                        IIndex index = this.manager.getIndex(this.indexPath, false, false);
                        if (index != null) {
                            if (!JobManager.VERBOSE) return true;
                            JobManager.verbose("-> no indexing required (index already exists) for " + this.indexPath);
                            return true;
                        }
                        index = this.manager.getIndex(this.indexPath, true, true);
                        if (index == null) {
                            if (!JobManager.VERBOSE) return true;
                            JobManager.verbose("-> index could not be created for " + this.indexPath);
                            return true;
                        }
                        monitor = this.manager.getMonitorFor(index);
                        if (monitor == null) {
                            if (!JobManager.VERBOSE) return true;
                            JobManager.verbose("-> index for " + this.indexPath + " just got deleted");
                            return true;
                        }
                        zip = null;
                        try {
                            int max;
                            Path zipFilePath = null;
                            monitor.enterWrite();
                            if (this.resource != null) {
                                IPath location = this.resource.getLocation();
                                if (location == null) {
                                    Object var17_9 = null;
                                    if (zip == null) break block38;
                                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                    }
                                    break block39;
                                }
                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + location);
                                }
                                zip = new ZipFile(location.toFile());
                                zipFilePath = (Path)this.resource.getFullPath().makeRelative();
                            } else {
                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.indexPath);
                                }
                                zip = new ZipFile(this.indexPath.toFile());
                                zipFilePath = (Path)this.indexPath;
                            }
                            if (JobManager.VERBOSE) {
                                JobManager.verbose("-> indexing " + zip.getName());
                            }
                            long initialTime = System.currentTimeMillis();
                            IQueryResult[] results = index.queryInDocumentNames("");
                            int n = max = results == null ? 0 : results.length;
                            if (max != 0) {
                                boolean needToReindex;
                                String EXISTS = "OK";
                                String DELETED = "DELETED";
                                SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                                int i = 0;
                                while (true) {
                                    if (i >= max) break;
                                    indexedFileNames.put(results[i].getPath(), DELETED);
                                    ++i;
                                }
                                Enumeration<? extends ZipEntry> e = zip.entries();
                                while (true) {
                                    if (!e.hasMoreElements()) {
                                        boolean bl = needToReindex = indexedFileNames.elementSize != max;
                                    }
                                    ZipEntry ze = e.nextElement();
                                    if (!Util.isClassFileName(ze.getName())) continue;
                                    JarFileEntryDocument entryDocument = new JarFileEntryDocument(ze, null, zipFilePath);
                                    indexedFileNames.put(entryDocument.getName(), EXISTS);
                                }
                                if (!needToReindex) {
                                    Object[] valueTable = indexedFileNames.valueTable;
                                    int i2 = 0;
                                    int l = valueTable.length;
                                    while (i2 < l) {
                                        if (valueTable[i2] == DELETED) {
                                            needToReindex = true;
                                            break;
                                        }
                                        ++i2;
                                    }
                                    if (!needToReindex) {
                                        if (JobManager.VERBOSE) {
                                            JobManager.verbose("-> no indexing required (index is consistent with library) for " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                        }
                                        Object var17_10 = null;
                                        if (zip != null) {
                                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                            }
                                            zip.close();
                                        }
                                        monitor.exitWrite();
                                        return true;
                                    }
                                }
                            }
                            index = this.manager.recreateIndex(this.indexPath);
                            Enumeration<? extends ZipEntry> e = zip.entries();
                            while (true) {
                                if (!e.hasMoreElements()) {
                                    this.manager.saveIndex(index);
                                    if (JobManager.VERBOSE) {
                                        JobManager.verbose("-> done indexing of " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                    }
                                    break block40;
                                }
                                if (this.isCancelled) {
                                    if (JobManager.VERBOSE) {
                                        JobManager.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                                    }
                                    Object var17_11 = null;
                                    if (zip != null) {
                                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                        }
                                        zip.close();
                                    }
                                    monitor.exitWrite();
                                    return false;
                                }
                                ZipEntry ze = e.nextElement();
                                if (!Util.isClassFileName(ze.getName())) continue;
                                byte[] classFileBytes = Util.getZipEntryByteContent(ze, zip);
                                index.add(new JarFileEntryDocument(ze, classFileBytes, zipFilePath), new BinaryIndexer(true));
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_12 = null;
                            if (zip != null) {
                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                }
                                zip.close();
                            }
                            monitor.exitWrite();
                            throw throwable;
                        }
                    }
                    zip.close();
                }
                monitor.exitWrite();
                return false;
            }
            Object var17_13 = null;
            if (zip != null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                }
                zip.close();
            }
            monitor.exitWrite();
            return true;
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> failed to index " + this.indexPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.indexPath);
            return false;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.indexPath.toString();
    }
}

