/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.excalibur.logger.factory.FormatterFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.net.SMTPOutputLogTarget;

public class SMTPTargetFactory
extends AbstractTargetFactory {
    public final LogTarget createTarget(Configuration config) throws ConfigurationException {
        try {
            return new SMTPOutputLogTarget(this.getSession(config), this.getToAddresses(config), this.getFromAddress(config), this.getSubject(config), this.getMaxSize(config), this.getFormatter(config));
        }
        catch (ContextException ce) {
            throw new ConfigurationException("Cannot find Session object in application context", (Throwable)ce);
        }
        catch (AddressException ae) {
            throw new ConfigurationException("Cannot create address", (Throwable)ae);
        }
    }

    protected Formatter getFormatter(Configuration config) {
        Configuration confFormat = config.getChild("format");
        if (null != confFormat) {
            FormatterFactory formatterFactory = new FormatterFactory();
            return formatterFactory.createFormatter(confFormat);
        }
        return null;
    }

    protected Session getSession(Configuration config) throws ContextException, ConfigurationException {
        Configuration sessionConfig = config.getChild("session", false);
        if (null == sessionConfig) {
            String contextkey = this.m_configuration.getAttribute("context-key", "session-context");
            if (this.m_context == null) {
                throw new ConfigurationException("Context not available");
            }
            return (Session)this.m_context.get((Object)contextkey);
        }
        return Session.getInstance((Properties)Parameters.toProperties((Parameters)Parameters.fromConfiguration((Configuration)sessionConfig)));
    }

    private String getSubject(Configuration config) throws ConfigurationException {
        return config.getChild("subject").getValue();
    }

    private int getMaxSize(Configuration config) throws ConfigurationException {
        return config.getChild("maximum-size").getValueAsInteger();
    }

    private Address[] getToAddresses(Configuration config) throws ConfigurationException, AddressException {
        Configuration[] toAddresses = config.getChildren("to");
        Address[] addresses = new Address[toAddresses.length];
        int i = 0;
        while (i < toAddresses.length) {
            addresses[i] = this.createAddress(toAddresses[i].getValue());
            ++i;
        }
        return addresses;
    }

    private Address getFromAddress(Configuration config) throws ConfigurationException, AddressException {
        return this.createAddress(config.getChild("from").getValue());
    }

    protected Address createAddress(String address) throws AddressException {
        return new InternetAddress(address);
    }
}

