/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;
import org.xml.sax.XMLReader;

public class AWTStarter
extends CommandLineStarter {
    PreviewDialog frame;
    AWTRenderer renderer;
    protected Driver driver;
    protected XMLReader parser;
    public static final String TRANSLATION_PATH = "/org/apache/fop/viewer/resources/";
    private Translator resource;

    public AWTStarter(CommandLineOptions commandLineOptions) throws FOPException {
        super(commandLineOptions);
        this.init();
    }

    private void init() throws FOPException {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String language = this.commandLineOptions.getLanguage();
        if (language == null) {
            try {
                language = System.getProperty("user.language");
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        this.resource = this.getResourceBundle("/org/apache/fop/viewer/resources/resources." + language);
        UserMessage.setTranslator(this.getResourceBundle("/org/apache/fop/viewer/resources/messages." + language));
        this.resource.setMissingEmphasized(false);
        this.renderer = new AWTRenderer(this.resource);
        this.frame = this.createPreviewDialog(this.renderer, this.resource);
        this.renderer.setProgressListener(this.frame);
        this.renderer.setComponent(this.frame);
        this.driver = new Driver();
        this.driver.setLogger((Logger)new ConsoleLogger(1));
        if (this.errorDump) {
            this.driver.setErrorDump(true);
        }
        this.driver.setRenderer(this.renderer);
        this.frame.progress(this.resource.getString("Init parser") + " ...");
        this.parser = this.inputHandler.getParser();
        if (this.parser == null) {
            throw new FOPException("Unable to create SAX parser");
        }
    }

    public void run() throws FOPException {
        this.driver.reset();
        try {
            this.frame.progress(this.resource.getString("Build FO tree") + " ...");
            this.driver.render(this.parser, this.inputHandler.getInputSource());
            this.frame.progress(this.resource.getString("Show"));
            this.frame.showPage();
        }
        catch (Exception e) {
            this.frame.reportException(e);
            if (e instanceof FOPException) {
                throw (FOPException)e;
            }
            throw new FOPException(e);
        }
    }

    protected PreviewDialog createPreviewDialog(AWTRenderer renderer, Translator res) {
        PreviewDialog frame = new PreviewDialog(this, renderer, res);
        frame.validate();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                System.exit(0);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        return frame;
    }

    private SecureResourceBundle getResourceBundle(String path) {
        InputStream in = null;
        try {
            URL url = this.getClass().getResource(path);
            if (url == null) {
                path = path.substring(0, path.lastIndexOf(".")) + ".en";
                url = this.getClass().getResource(path);
            }
            in = url.openStream();
        }
        catch (Exception ex) {
            this.log.error("Can't find URL to: <" + path + "> " + ex.getMessage(), (Throwable)ex);
        }
        return new SecureResourceBundle(in);
    }
}

