/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.txt.TXTStream;
import org.apache.fop.svg.SVGArea;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class TXTRenderer
extends PrintRenderer {
    TXTStream currentStream;
    public static final String encodingOptionName = "txt.encoding";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private int pageHeight = 7920;
    public int curdiv = 0;
    private int divisions = -1;
    private int paperheight = -1;
    public int orientation = -1;
    public int topmargin = -1;
    public int leftmargin = -1;
    private int fullmargin = 0;
    final boolean debug = false;
    StringBuffer[] charData;
    StringBuffer[] decoData;
    public float textCPI = 16.67f;
    public float textLPI = 8.0f;
    int maxX = (int)(8.5f * this.textCPI + 1.0f);
    int maxY = (int)(11.0f * this.textLPI + 1.0f);
    float xFactor;
    float yFactor;
    public String lineEnding = "\r\n";
    public String pageEnding = "\f";
    public boolean suppressGraphics = false;
    boolean firstPage = false;
    protected Map options;

    public void setOptions(Map options) {
        this.options = options;
    }

    public void setProducer(String producer) {
    }

    void addStr(int row, int col, String str, boolean ischar) {
        StringBuffer sb;
        if (this.suppressGraphics && !ischar) {
            return;
        }
        if (row < 0) {
            row = 0;
        }
        if ((sb = ischar ? this.charData[row] : this.decoData[row]) == null) {
            sb = new StringBuffer();
        }
        if (col + str.length() > this.maxX) {
            col = this.maxX - str.length();
        }
        if (col < 0) {
            col = 0;
            if (str.length() > this.maxX) {
                str = str.substring(0, this.maxX);
            }
        }
        int countr = sb.length();
        while (countr < col) {
            sb.append(' ');
            ++countr;
        }
        int countr2 = col;
        while (countr2 < col + str.length()) {
            if (countr2 >= sb.length()) {
                sb.append(str.charAt(countr2 - col));
            } else {
                sb.setCharAt(countr2, str.charAt(countr2 - col));
            }
            ++countr2;
        }
        if (ischar) {
            this.charData[row] = sb;
        } else {
            this.decoData[row] = sb;
        }
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, PDFPathPaint stroke) {
        if (x1 == x2) {
            this.addRect(x1, y1, th, y2 - y1 + 1, stroke, stroke);
        } else if (y1 == y2) {
            this.addRect(x1, y1, x2 - x1 + 1, th, stroke, stroke);
        }
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, int rs, PDFPathPaint stroke) {
        PDFColor lstroke = null;
        lstroke = rs == 27 ? new PDFColor(0.7f, 0.7f, 0.7f) : (PDFColor)stroke;
        if (x1 == x2) {
            this.addRect(x1, y1, th, y2 - y1 + 1, lstroke, lstroke);
        } else if (y1 == y2) {
            this.addRect(x1, y1, x2 - x1 + 1, th, lstroke, lstroke);
        }
    }

    protected void addLine(float x1, float y1, float x2, float y2, PDFColor sc, float sw) {
    }

    private void xferLineBytes(int startpos, int bitcount, List save, int start2) {
    }

    protected void addRect(int x, int y, int w, int h, PDFPathPaint stroke) {
        if (h < 0) {
            h *= -1;
        }
        if (h < 720 || w < 720) {
            if (w < 720) {
                w = 720;
            }
            if (h < 720) {
                h = 720;
            }
            this.addRect(x, y, w, h, stroke, stroke);
        } else {
            this.addRect(x, y, w, 720, stroke, stroke);
            this.addRect(x, y, 720, h, stroke, stroke);
            this.addRect(x + w - 720, y, 720, h, stroke, stroke);
            this.addRect(x, y - h + 720, w, 720, stroke, stroke);
        }
    }

    protected void addRect(int x, int y, int w, int h, PDFPathPaint stroke, PDFPathPaint fill) {
        int countr;
        if (w == 0 || h == 0) {
            return;
        }
        if (h < 0) {
            h *= -1;
        }
        int row = (int)((float)((this.pageHeight - y / 100) * 100) * this.yFactor);
        int col = (int)((float)x * this.xFactor);
        PDFColor sc = (PDFColor)stroke;
        PDFColor fc = (PDFColor)fill;
        sc.setColorSpace(2);
        fc.setColorSpace(2);
        int lineshade = (int)(100.0 - ((double)0.3f * sc.red() + (double)0.59f * sc.green() + (double)0.11f * sc.blue()) * 100.0);
        int fillshade = (int)(100.0 - ((double)0.3f * fc.red() + (double)0.59f * fc.green() + (double)0.11f * fc.blue()) * 100.0);
        char fillchar = ' ';
        if (fillshade >= 75) {
            fillchar = '#';
        } else if (fillshade >= 50) {
            fillchar = '*';
        } else if (fillshade >= 25) {
            fillchar = ':';
        }
        if (fillchar != ' ') {
            StringBuffer linefill = new StringBuffer();
            int sw = (int)((float)w * this.xFactor);
            int sh = (int)((float)h * this.yFactor);
            if (sw == 0 || sh == 0) {
                fillchar = fillshade >= 50 ? (h > w ? (char)'|' : '-') : (h > w ? (char)':' : '.');
            }
            if (sw == 0) {
                linefill.append(fillchar);
            } else {
                int countr2 = 0;
                while (countr2 < sw) {
                    linefill.append(fillchar);
                    ++countr2;
                }
            }
            if (sh == 0) {
                this.addStr(row, col, linefill.toString(), false);
            } else {
                countr = 0;
                while (countr < sh) {
                    this.addStr(row + countr, col, linefill.toString(), false);
                    ++countr;
                }
            }
        }
        if (lineshade >= 25) {
            char vlinechar = '|';
            char hlinechar = '-';
            if (lineshade < 50) {
                vlinechar = ':';
                hlinechar = '.';
            }
            StringBuffer linefill = new StringBuffer();
            int sw = (int)((float)w * this.xFactor);
            countr = 0;
            while (countr < sw) {
                linefill.append(hlinechar);
                ++countr;
            }
            int sh = (int)((float)h * this.yFactor);
            if (w > h) {
                int countr3 = 1;
                while (countr3 < sh - 1) {
                    this.addStr(row + countr3, col, String.valueOf(vlinechar), false);
                    this.addStr(row + countr3, col + sw, String.valueOf(vlinechar), false);
                    ++countr3;
                }
                this.addStr(row, col, linefill.toString(), false);
                this.addStr(row + sh, col, linefill.toString(), false);
            } else {
                this.addStr(row, col, linefill.toString(), false);
                this.addStr(row + sh, col, linefill.toString(), false);
                int countr4 = 1;
                while (countr4 < sh - 1) {
                    this.addStr(row + countr4, col, String.valueOf(vlinechar), false);
                    this.addStr(row + countr4, col + sw, String.valueOf(vlinechar), false);
                    ++countr4;
                }
            }
        }
    }

    protected void addRect(float x, float y, float w, float h, float rx, float ry, PDFColor fc, PDFColor sc, float sw) {
    }

    protected void addPolyline(List points, int posx, int posy, PDFColor fc, PDFColor sc, float sw, boolean close) {
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
    }

    boolean printBMP(FopImage img, int x, int y, int w, int h) throws FopImageException {
        int namew;
        this.addRect(x, y, w, h, new PDFColor(1.0, 1.0, 1.0), new PDFColor(0.0, 0.0, 0.0));
        int nameh = (int)((float)h * this.yFactor / 2.0f);
        if (nameh > 0 && (namew = (int)((float)w * this.xFactor)) > 4) {
            String iname = img.getURL();
            if (iname.length() >= namew) {
                this.addStr((int)((float)((this.pageHeight - y / 100) * 100) * this.yFactor) + nameh, (int)((float)x * this.xFactor), iname.substring(iname.length() - namew), true);
            } else {
                this.addStr((int)((float)((this.pageHeight - y / 100) * 100) * this.yFactor) + nameh, (int)((float)x * this.xFactor + (float)((namew - iname.length()) / 2)), iname, true);
            }
        }
        return true;
    }

    public void renderImageArea(ImageArea area) {
        int x = this.currentAreaContainerXPosition + area.getXOffset();
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= h;
        FopImage img = area.getImage();
        try {
            this.printBMP(img, x, y, w, h);
        }
        catch (FopImageException e) {
            this.log.error("TXTRenderer.renderImageArea() printing BMP (" + e.toString() + ").", (Throwable)e);
        }
    }

    public void renderImage(FontState fontState, String href, float x, float y, float width, float height) {
        block4: {
            try {
                FopImage img;
                if (href.indexOf(":") == -1) {
                    href = "file:" + href;
                }
                if ((img = FopImageFactory.Make(href)) == null) break block4;
                if (img instanceof SVGImage) {
                    SVGSVGElement svg = ((SVGImage)img).getSVGDocument().getRootElement();
                    this.renderSVG(fontState, svg, (int)x * 1000, (int)y * 1000);
                    break block4;
                }
                this.printBMP(img, (int)x, (int)y, (int)width, (int)height);
            }
            catch (Exception e) {
                this.log.error("could not add image to SVG: " + href, (Throwable)e);
            }
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        this.currentXPosition += area.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (area.getAlign()) {
            case 106: {
                break;
            }
            case 30: {
                break;
            }
        }
        switch (area.getVerticalAlign()) {
            case 9: {
                break;
            }
            case 65: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                break;
            }
            case 115: {
                break;
            }
            case 114: {
                break;
            }
            case 116: {
                break;
            }
        }
        switch (area.scalingMethod()) {
            case 122: {
                break;
            }
        }
        switch (area.getOverflow()) {
            case 8: 
            case 101: 
            case 125: {
                break;
            }
        }
        area.getObject().render(this);
        this.currentXPosition += area.getEffectiveWidth();
    }

    void renderSVG(FontState fontState, SVGSVGElement svg, int x, int y) {
    }

    public void renderSVGArea(SVGArea area) {
        int x = this.currentAreaContainerXPosition;
        int y = this.currentYPosition;
        SVGSVGElement svg = ((SVGDocument)area.getSVGDocument()).getRootElement();
        int w = (int)(svg.getWidth().getBaseVal().getValue() * 1000.0f);
        int h = (int)(svg.getHeight().getBaseVal().getValue() * 1000.0f);
        this.renderSVG(area.getFontState(), svg, x, y);
    }

    private void setFont(String name, float size) {
    }

    public void renderWordArea(WordArea area) {
        int rx = this.currentXPosition;
        int bl = this.currentYPosition;
        String s = area.getText();
        this.addStr((int)((float)((this.pageHeight - bl / 100) * 100) * this.yFactor) - 1, (int)((float)rx * this.xFactor), s, true);
        this.currentXPosition += area.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace space) {
        this.currentXPosition += space.getSize();
    }

    public void renderPage(Page page) {
        this.maxX = (int)(this.textCPI * (float)page.getWidth() / 72000.0f + 1.0f);
        this.maxY = (int)(this.textLPI * (float)page.getHeight() / 72000.0f + 1.0f);
        this.xFactor = (float)(this.maxX - 1) / (float)page.getWidth();
        this.yFactor = (float)(this.maxY - 1) / (float)page.getHeight();
        this.charData = new StringBuffer[this.maxY + 1];
        this.decoData = new StringBuffer[this.maxY + 1];
        this.pageHeight = this.paperheight > 0 ? this.paperheight : page.getHeight() / 100;
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderRegions(page);
        int row = 0;
        while (row <= this.maxY) {
            StringBuffer cr = this.charData[row];
            StringBuffer dr = this.decoData[row];
            StringBuffer outr = null;
            if (cr != null && dr == null) {
                outr = cr;
            } else if (dr != null && cr == null) {
                outr = dr;
            } else if (cr != null && dr != null) {
                int len = dr.length();
                if (cr.length() > len) {
                    len = cr.length();
                }
                outr = new StringBuffer();
                int countr = 0;
                while (countr < len) {
                    if (countr < cr.length() && cr.charAt(countr) != ' ') {
                        outr.append(cr.charAt(countr));
                    } else if (countr < dr.length()) {
                        outr.append(dr.charAt(countr));
                    } else {
                        outr.append(' ');
                    }
                    ++countr;
                }
            }
            if (outr != null) {
                this.currentStream.add(outr.toString());
            }
            if (row < this.maxY) {
                this.currentStream.add(this.lineEnding);
            }
            ++row;
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        String encoding;
        this.log.info("rendering areas to TEXT");
        this.currentStream = new TXTStream(outputStream);
        if (this.options != null && (encoding = (String)this.options.get(encodingOptionName)) != null) {
            try {
                byte[] buff = " ".getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                this.log.warn("Encoding '" + encoding + "' is not supported, so defaulted to " + DEFAULT_ENCODING);
                encoding = DEFAULT_ENCODING;
            }
        } else {
            encoding = DEFAULT_ENCODING;
        }
        this.currentStream.setEncoding(encoding);
        this.firstPage = true;
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.log.info("writing out TEXT");
        outputStream.flush();
    }

    public void render(Page page, OutputStream outputStream) {
        this.idReferences = page.getIDReferences();
        if (this.firstPage) {
            this.firstPage = false;
        } else {
            this.currentStream.add(this.pageEnding);
        }
        this.renderPage(page);
        this.currentStream.add(this.lineEnding);
    }
}

