/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class CocoonToAvalonSource
implements Source,
XMLizable,
Recyclable {
    protected org.apache.cocoon.environment.Source source;
    protected String protocol;

    public CocoonToAvalonSource(String location, org.apache.cocoon.environment.Source source) {
        this.source = source;
        int pos = location.indexOf(58);
        this.protocol = location.substring(0, pos);
    }

    public String getScheme() {
        return this.protocol;
    }

    public boolean exists() {
        try {
            this.getInputStream();
            return true;
        }
        catch (Exception local) {
            return false;
        }
    }

    public InputStream getInputStream() throws IOException, SourceException {
        try {
            return this.source.getInputStream();
        }
        catch (ResourceNotFoundException rnfe) {
            throw new SourceNotFoundException("Source not found.", (Throwable)rnfe);
        }
        catch (ProcessingException pe) {
            throw new SourceException("ProcessingException", (Throwable)pe);
        }
    }

    public String getURI() {
        return this.source.getSystemId();
    }

    public SourceValidity getValidity() {
        if (this.source.getLastModified() > 0L) {
            return new TimeStampValidity(this.source.getLastModified());
        }
        return null;
    }

    public void refresh() {
        if (this.source instanceof ModifiableSource) {
            ((ModifiableSource)this.source).refresh();
        }
    }

    public String getMimeType() {
        return null;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        this.source.toSAX(contentHandler);
    }

    public void recycle() {
        this.source.recycle();
    }

    public long getContentLength() {
        return this.source.getContentLength();
    }

    public long getLastModified() {
        return this.source.getLastModified();
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return 0L;
    }

    public Iterator getParameterNames() {
        return Collections.EMPTY_LIST.iterator();
    }
}

