/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.IndexIterator;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.Page;
import java.io.IOException;
import java.util.Stack;

public class BTreeIterator
implements IndexIterator {
    private boolean m_valid = true;
    private BTreeIndex m_index;
    private Stack m_pageStack;
    private Page m_currentPage;
    private int m_currentIndex;

    public BTreeIterator(BTreeIndex bTreeIndex) throws IOException, ClassNotFoundException {
        this.m_index = bTreeIndex;
        this.m_pageStack = new Stack();
        this.m_currentPage = this.m_index.readRoot();
        this.m_currentIndex = -1;
        this.m_valid = this.m_currentPage.m_header.m_numKeys < 1 ? false : this.moveNext();
    }

    public BTreeIterator(BTreeIterator bTreeIterator) throws IOException, ClassNotFoundException {
        this.m_index = bTreeIterator.m_index;
        this.m_pageStack = (Stack)bTreeIterator.m_pageStack.clone();
        this.m_currentPage = this.m_index.readRoot();
        this.m_currentIndex = bTreeIterator.m_currentIndex;
    }

    public long getRecPtr() throws IOException {
        long l = -1L;
        if (this.m_valid) {
            l = this.m_currentPage.m_recPtr[this.m_currentIndex];
        }
        return l;
    }

    public Object getKey() throws IOException {
        KeyObject keyObject = null;
        if (this.m_valid) {
            try {
                keyObject = this.m_currentPage.m_key[this.m_currentIndex];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return keyObject;
    }

    public boolean moveNext() throws IOException, ClassNotFoundException {
        if (!this.m_valid) {
            return false;
        }
        ++this.m_currentIndex;
        boolean bl = false;
        if (this.m_currentIndex == this.m_currentPage.m_header.m_numKeys && this.m_currentPage.m_link[this.m_currentIndex] != -1L) {
            this.m_pageStack.push(new PagePointer(this.m_currentPage, this.m_currentIndex));
            this.m_currentPage = this.m_index.read(this.m_currentPage.m_link[this.m_currentIndex]);
            this.m_currentIndex = 0;
        }
        while (this.m_currentIndex >= this.m_currentPage.m_header.m_numKeys) {
            if (this.m_pageStack.empty()) {
                return false;
            }
            PagePointer pagePointer = (PagePointer)this.m_pageStack.pop();
            this.m_currentPage = pagePointer.m_page;
            this.m_currentIndex = pagePointer.m_index;
            bl = true;
        }
        try {
            if (!bl) {
                while (this.m_currentPage.m_link[this.m_currentIndex] != -1L) {
                    this.m_pageStack.push(new PagePointer(this.m_currentPage, this.m_currentIndex));
                    this.m_currentPage = this.m_index.read(this.m_currentPage.m_link[this.m_currentIndex]);
                    this.m_currentIndex = 0;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean movePrevious() throws IOException, ClassNotFoundException {
        if (!this.m_valid) {
            return false;
        }
        boolean bl = false;
        while (this.m_currentIndex == 0) {
            if (this.m_pageStack.empty()) {
                return false;
            }
            PagePointer pagePointer = (PagePointer)this.m_pageStack.pop();
            this.m_currentPage = pagePointer.m_page;
            this.m_currentIndex = pagePointer.m_index;
            bl = true;
        }
        --this.m_currentIndex;
        if (this.m_currentPage.m_link[this.m_currentIndex] != -1L) {
            this.m_pageStack.push(new PagePointer(this.m_currentPage, this.m_currentIndex));
            this.m_currentPage = this.m_index.read(this.m_currentPage.m_link[this.m_currentIndex]);
            this.m_currentIndex = this.m_currentPage.m_header.m_numKeys - 1;
        }
        return true;
    }

    public boolean moveFirst() throws IOException, ClassNotFoundException {
        if (!this.m_valid) {
            return false;
        }
        this.m_pageStack = new Stack();
        this.m_currentPage = this.m_index.readRoot();
        this.m_currentIndex = -1;
        this.moveNext();
        return true;
    }

    public boolean moveLast() throws IOException, ClassNotFoundException {
        if (!this.m_valid) {
            return false;
        }
        this.m_pageStack = new Stack();
        this.m_currentPage = this.m_index.readRoot();
        this.m_currentIndex = -1;
        while (this.moveNext()) {
        }
        return true;
    }

    public boolean moveTo(KeyObject keyObject) throws IOException, ClassNotFoundException {
        return this.moveTo(keyObject, false);
    }

    public boolean moveTo(KeyObject keyObject, boolean bl) throws IOException, ClassNotFoundException {
        if (!this.m_valid) {
            return false;
        }
        this.m_pageStack = new Stack();
        this.m_currentPage = this.m_index.readRoot();
        this.m_currentIndex = -1;
        return this.search(keyObject, this.m_currentPage, bl);
    }

    private boolean search(KeyObject keyObject, Page page, boolean bl) throws IOException, ClassNotFoundException {
        int n;
        if (page.m_header.m_numKeys == 0) {
            return false;
        }
        int n2 = 99;
        for (n = 0; n != page.m_header.m_numKeys; ++n) {
            n2 = page.m_key[n].compareTo(keyObject);
            if (n2 == 0) {
                this.m_currentPage = page;
                this.m_currentIndex = n;
                return true;
            }
            if (n2 != -1) break;
        }
        if (page.m_link[n] == -1L) {
            if (bl) {
                if (n2 == 1) {
                    this.m_currentPage = page;
                    this.m_currentIndex = n;
                    return true;
                }
                return false;
            }
            return false;
        }
        this.m_pageStack.push(new PagePointer(page, n));
        return this.search(keyObject, this.m_index.read(page.m_link[n]), bl);
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public void invalidate() {
        this.m_valid = false;
    }

    private class PagePointer {
        public Page m_page;
        public int m_index;

        public PagePointer(Page page, int n) {
            this.m_page = page;
            this.m_index = n;
        }
    }
}

