/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.KeyObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LongKey
extends KeyObject {
    static final long serialVersionUID = 3500210952961277131L;
    private long m_key;

    public LongKey(long l) {
        this.m_key = l;
    }

    public LongKey() {
        this.m_key = 0L;
    }

    public int compareTo(KeyObject keyObject) {
        if (keyObject instanceof LongKey) {
            long l = this.m_key - ((LongKey)keyObject).m_key;
            if (l == 0L) {
                return 0;
            }
            if (l < 0L) {
                return -1;
            }
            return 1;
        }
        return 99;
    }

    public KeyObject makeNullKey() {
        LongKey longKey = new LongKey();
        longKey.m_key = -1L;
        return longKey;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Long(this.m_key));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_key = (Long)objectInput.readObject();
    }

    public long longValue() {
        return this.m_key;
    }

    public String toString() {
        return Long.toString(this.m_key);
    }

    public int hashCode() {
        return (int)this.m_key;
    }
}

