/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.ObjectBytesInputStream;
import com.coyotegulch.jisp.ObjectDatabaseCallback;
import com.coyotegulch.jisp.RecordFilter;
import com.coyotegulch.jisp.SerialObjectInputStream;
import com.coyotegulch.jisp.SerialObjectOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ObjectDatabaseFile {
    protected static final long DEL_LIST_END = -1L;
    protected static final byte IS_DELETED = 0;
    protected static final byte IS_ACTIVE = 1;
    protected RandomAccessFile m_dataFile;
    protected String m_fileName;
    protected long m_firstDeleted;
    protected RecordFilter m_filter;

    public ObjectDatabaseFile(String string, boolean bl) throws IOException {
        if (bl) {
            File file = new File(string);
            file.delete();
        }
        this.m_fileName = new String(string);
        this.m_dataFile = new RandomAccessFile(string, "rw");
        this.m_filter = null;
        this.constructorHelper();
    }

    public ObjectDatabaseFile(File file, boolean bl) throws IOException {
        if (bl) {
            file.delete();
        }
        this.m_fileName = new String(file.getName());
        this.m_dataFile = new RandomAccessFile(file, "rw");
        this.constructorHelper();
    }

    private void constructorHelper() throws IOException {
        if (this.m_dataFile.length() == 0L) {
            this.m_dataFile.writeLong(-1L);
            this.m_firstDeleted = -1L;
        } else {
            this.m_firstDeleted = this.m_dataFile.readLong();
        }
    }

    public long writeObject(Serializable serializable) throws IOException {
        long l;
        int n;
        SerialObjectOutputStream serialObjectOutputStream = new SerialObjectOutputStream();
        ObjectOutputStream objectOutputStream = this.createObjectOutputStream(serialObjectOutputStream);
        if (this.m_filter == null) {
            objectOutputStream.writeObject(serializable);
        } else {
            objectOutputStream.writeObject(this.m_filter.filterEncode(serializable));
        }
        objectOutputStream.flush();
        int n2 = n = serialObjectOutputStream.getSize();
        if (this.m_firstDeleted == -1L) {
            l = this.m_dataFile.length();
            this.m_dataFile.seek(l);
        } else {
            long l2 = -1L;
            l = this.m_firstDeleted;
            while (true) {
                this.m_dataFile.seek(l);
                byte by = this.m_dataFile.readByte();
                this.m_dataFile.readInt();
                n2 = this.m_dataFile.readInt();
                long l3 = this.m_dataFile.readLong();
                if (by == 1) {
                    throw new IOException("corrupt delete list");
                }
                if (n2 >= n) {
                    if (l2 == -1L) {
                        this.m_firstDeleted = l3;
                        this.m_dataFile.seek(0L);
                        this.m_dataFile.writeLong(this.m_firstDeleted);
                    } else {
                        this.m_dataFile.seek(l2 + 1L + 4L + 4L);
                        this.m_dataFile.writeLong(l3);
                    }
                    this.m_dataFile.seek(l);
                    break;
                }
                l2 = l;
                if (l3 == -1L) {
                    l = this.m_dataFile.length();
                    this.m_dataFile.seek(l);
                    break;
                }
                l = l3;
            }
        }
        this.m_dataFile.writeByte(1);
        this.m_dataFile.writeInt(n);
        this.m_dataFile.writeInt(n2);
        this.m_dataFile.writeLong(-1L);
        serialObjectOutputStream.writeTo(this.m_dataFile);
        return l;
    }

    public void rewriteObject(Serializable serializable) throws IOException {
        int n;
        SerialObjectOutputStream serialObjectOutputStream = new SerialObjectOutputStream();
        ObjectOutputStream objectOutputStream = this.createObjectOutputStream(serialObjectOutputStream);
        if (this.m_filter == null) {
            objectOutputStream.writeObject(serializable);
        } else {
            objectOutputStream.writeObject(this.m_filter.filterEncode(serializable));
        }
        objectOutputStream.flush();
        int n2 = n = serialObjectOutputStream.getSize();
        this.m_dataFile.writeByte(1);
        this.m_dataFile.writeInt(n);
        this.m_dataFile.writeInt(n2);
        this.m_dataFile.writeLong(-1L);
        serialObjectOutputStream.writeTo(this.m_dataFile);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        int n;
        int n2;
        while ((n2 = this.m_dataFile.readByte()) != 1) {
            this.m_dataFile.skipBytes(4);
            n = this.m_dataFile.readInt();
            this.m_dataFile.skipBytes(n + 8);
        }
        n2 = this.m_dataFile.readInt();
        n = this.m_dataFile.readInt();
        this.m_dataFile.skipBytes(8);
        byte[] byArray = new byte[n2];
        this.m_dataFile.readFully(byArray);
        int n3 = n - n2;
        if (n3 > 0) {
            this.m_dataFile.skipBytes(n3);
        }
        ObjectBytesInputStream objectBytesInputStream = new ObjectBytesInputStream(byArray);
        SerialObjectInputStream serialObjectInputStream = new SerialObjectInputStream(objectBytesInputStream);
        Object object = serialObjectInputStream.readObject();
        if (this.m_filter == null) {
            return object;
        }
        return this.m_filter.filterDecode(object);
    }

    public void delete() throws IOException {
        long l = this.m_dataFile.getFilePointer();
        byte by = this.m_dataFile.readByte();
        if (by == 0) {
            return;
        }
        this.m_dataFile.seek(l);
        this.m_dataFile.writeByte(0);
        this.m_dataFile.skipBytes(8);
        this.m_dataFile.writeLong(this.m_firstDeleted);
        this.m_firstDeleted = l;
        this.m_dataFile.seek(0L);
        this.m_dataFile.writeLong(this.m_firstDeleted);
    }

    public void rewind() throws IOException {
        this.m_dataFile.seek(8L);
    }

    public void skip() throws IOException {
        this.m_dataFile.skipBytes(5);
        int n = this.m_dataFile.readInt();
        this.m_dataFile.skipBytes(8 + n);
    }

    public void compact(ObjectDatabaseCallback objectDatabaseCallback) throws IOException, ClassNotFoundException {
        File file = new File("TMP" + System.currentTimeMillis());
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.writeLong(-1L);
        try {
            while (true) {
                byte by = this.m_dataFile.readByte();
                int n = this.m_dataFile.readInt();
                int n2 = this.m_dataFile.readInt();
                if (by == 0) {
                    this.m_dataFile.skipBytes(8 + n2);
                    continue;
                }
                this.m_dataFile.skipBytes(8);
                byte[] byArray = new byte[n];
                this.m_dataFile.readFully(byArray);
                int n3 = n2 - n;
                if (n3 > 0) {
                    this.m_dataFile.skipBytes(n3);
                }
                long l = randomAccessFile.getFilePointer();
                randomAccessFile.writeByte(1);
                randomAccessFile.writeInt(n);
                randomAccessFile.writeInt(n);
                randomAccessFile.writeLong(-1L);
                randomAccessFile.write(byArray);
                ObjectBytesInputStream objectBytesInputStream = new ObjectBytesInputStream(byArray);
                SerialObjectInputStream serialObjectInputStream = new SerialObjectInputStream(objectBytesInputStream);
                if (objectDatabaseCallback == null) continue;
                objectDatabaseCallback.compactNotify(l, serialObjectInputStream.readObject());
            }
        }
        catch (EOFException eOFException) {
            this.m_dataFile.close();
            File file2 = new File(this.m_fileName);
            file2.delete();
            randomAccessFile.close();
            file.renameTo(new File(this.m_fileName));
            this.m_dataFile = new RandomAccessFile(this.m_fileName, "rw");
            this.constructorHelper();
            return;
        }
    }

    public void assignFilter(RecordFilter recordFilter) {
        this.m_filter = recordFilter;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.m_dataFile.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.m_dataFile.getFilePointer();
    }

    public void seek(long l) throws IOException {
        this.m_dataFile.seek(l);
    }

    public long length() throws IOException {
        return this.m_dataFile.length();
    }

    public void close() throws IOException {
        this.m_dataFile.close();
    }

    protected ObjectInputStream createObjectInputStream(InputStream inputStream) throws IOException {
        return new ObjectInputStream(inputStream);
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream outputStream) throws IOException {
        return new ObjectOutputStream(outputStream);
    }
}

