/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component.servlet;

import org.apache.avalon.excalibur.component.servlet.AbstractReferenceProxy;
import org.apache.avalon.excalibur.component.servlet.ComponentManagerReferenceProxy;
import org.apache.avalon.excalibur.component.servlet.InstrumentManagerReferenceProxy;
import org.apache.avalon.excalibur.component.servlet.LoggerManagerReferenceProxy;
import org.apache.avalon.excalibur.component.servlet.ReferenceProxy;
import org.apache.avalon.excalibur.component.servlet.ServiceManagerReferenceProxy;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.instrument.InstrumentManager;

abstract class AbstractReferenceProxyLatch
extends AbstractLogEnabled {
    private String m_name;
    private int m_waitingProxies;
    private boolean m_triggerRequested;

    public ReferenceProxy createProxy(Object object, String name) {
        AbstractReferenceProxy proxy;
        this.m_name = name;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating a proxy named '" + this.m_name + "' for a " + object.getClass().getName());
        }
        if (object instanceof LoggerManager) {
            proxy = new LoggerManagerReferenceProxy((LoggerManager)object, this, name);
        } else if (object instanceof ServiceManager) {
            proxy = new ServiceManagerReferenceProxy((ServiceManager)object, this, name);
        } else if (object instanceof ComponentManager) {
            proxy = new ComponentManagerReferenceProxy((ComponentManager)object, this, name);
        } else if (object instanceof InstrumentManager) {
            proxy = new InstrumentManagerReferenceProxy((InstrumentManager)object, this, name);
        } else {
            throw new IllegalArgumentException("Don't know how to create a proxy for a " + object.getClass().getName());
        }
        ++this.m_waitingProxies;
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTrigger() {
        block13: {
            block12: {
                int waitingProxies;
                AbstractReferenceProxyLatch abstractReferenceProxyLatch = this;
                synchronized (abstractReferenceProxyLatch) {
                    waitingProxies = this.m_waitingProxies;
                }
                if (waitingProxies > 0) {
                    System.gc();
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                AbstractReferenceProxyLatch abstractReferenceProxyLatch2 = this;
                synchronized (abstractReferenceProxyLatch2) {
                    this.m_triggerRequested = true;
                    waitingProxies = this.m_waitingProxies;
                }
                if (waitingProxies <= 0) break block12;
                if (!this.getLogger().isDebugEnabled()) break block13;
                this.getLogger().debug("Trigger requested.  " + waitingProxies + " proxies have not yet been finalized.");
                break block13;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Trigger requested.  All proxies have been finalized.");
            }
            try {
                this.triggered();
            }
            catch (Exception e) {
                this.getLogger().error("Encountered an unexpected error in the trigger callback:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFinalized(AbstractReferenceProxy proxy) {
        block8: {
            AbstractReferenceProxyLatch abstractReferenceProxyLatch = this;
            synchronized (abstractReferenceProxyLatch) {
                --this.m_waitingProxies;
                if (this.m_waitingProxies > 0) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("The proxy named '" + proxy.getName() + "' was finalized.  " + this.m_waitingProxies + " proxies remaining.");
                    }
                    return;
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The proxy named '" + proxy.getName() + "' was finalized.  " + "All proxies have been finalized.");
            }
            if (!this.m_triggerRequested) break block8;
            try {
                this.triggered();
            }
            catch (Exception e) {
                this.getLogger().error("Encountered an unexpected error in the trigger callback:", (Throwable)e);
            }
        }
    }

    public abstract void triggered() throws Exception;
}

