/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.AboutDialog;
import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.FirstTimeDialog;
import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.JBackpack;
import ch.fhnw.jbackpack.LogLevel;
import ch.fhnw.jbackpack.PreferencesDialog;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.OperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.SwingHelpUtilities;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class BackupFrame
extends JFrame {
    public static final String ICON_PATH = "/ch/fhnw/jbackpack/icons/32x32/icon.png";
    private static final Logger LOGGER = Logger.getLogger(BackupFrame.class.getName());
    private static final Logger UTIL_LOGGER = Logger.getLogger(ProcessExecutor.class.getPackage().getName());
    private static final Logger GLOBAL_LOGGER = Logger.getLogger(BackupFrame.class.getPackage().getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final String PROFILES_PATH = "profiles_path";
    private static final String RECENT_PROFILE = "recent_profile_";
    private static final String LOGGING_LEVEL = "logging_level";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final int RECENT_PROFILES_LIMIT = 4;
    private final ConsoleHandler consoleHandler;
    private final List<String> recentProfiles;
    private final Preferences preferences = Preferences.userNodeForPackage(JBackpack.class);
    private FileHandler fileHandler;
    private LogLevel logLevel;
    private String profilesPath;
    private boolean recentProfilesHaveChanged;
    private HelpBroker helpbroker;
    private JMenuItem aboutMenuItem;
    private BackupMainPanel backupMainPanel;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JMenuBar menuBar;
    private JMenuItem newProfileMenuItem;
    private JMenuItem openProfileMenuItem;
    private JMenuItem preferencesMenuItem;
    private JMenuItem quitMenuItem;
    private JMenu recentProfilesMenu;
    private JMenuItem saveProfileMenuItem;

    public BackupFrame() {
        String recentProfile;
        int logLevelOrdinal = this.preferences.getInt(LOGGING_LEVEL, LogLevel.INFO.ordinal());
        GLOBAL_LOGGER.setUseParentHandlers(false);
        UTIL_LOGGER.setUseParentHandlers(false);
        SimpleFormatter formatter = new SimpleFormatter();
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setFormatter(formatter);
        GLOBAL_LOGGER.addHandler(this.consoleHandler);
        UTIL_LOGGER.addHandler(this.consoleHandler);
        try {
            this.fileHandler = new FileHandler("%t/jbackpack_" + System.getProperty("user.name"), 50000000, 2, true);
            this.fileHandler.setFormatter(formatter);
            GLOBAL_LOGGER.addHandler(this.fileHandler);
            UTIL_LOGGER.addHandler(this.fileHandler);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        this.setLogLevel(LogLevel.values()[logLevelOrdinal]);
        LOGGER.info("*********** Starting JBackpack ***********");
        this.recentProfiles = new ArrayList<String>();
        this.initComponents();
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newProfileMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, menuShortcutKeyMask));
        this.openProfileMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, menuShortcutKeyMask));
        this.saveProfileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, menuShortcutKeyMask));
        this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, menuShortcutKeyMask));
        if (CurrentOperatingSystem.OS != OperatingSystem.Mac_OS_X) {
            this.fileMenu.setMnemonic(BUNDLE.getString("BackupFrame.fileMenu.mnemonic").charAt(0));
            this.newProfileMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.newProfileMenuItem.mnemonic").charAt(0));
            this.openProfileMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.openProfileMenuItem.mnemonic").charAt(0));
            this.recentProfilesMenu.setMnemonic(BUNDLE.getString("BackupFrame.recentProfilesMenu.mnemonic").charAt(0));
            this.saveProfileMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.saveProfileMenuItem.mnemonic").charAt(0));
            this.preferencesMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.preferencesMenuItem.mnemonic").charAt(0));
            this.quitMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.quitMenuItem.mnemonic").charAt(0));
            this.helpMenu.setMnemonic(BUNDLE.getString("BackupFrame.helpMenu.mnemonic").charAt(0));
            this.helpMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.helpMenuItem.mnemonic").charAt(0));
            this.aboutMenuItem.setMnemonic(BUNDLE.getString("BackupFrame.aboutMenuItem.mnemonic").charAt(0));
        }
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/icon.png")).getImage());
        icons.add(new ImageIcon(this.getClass().getResource(ICON_PATH)).getImage());
        Image dockImage = new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/128x128/icon.png")).getImage();
        icons.add(dockImage);
        icons.add(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/256x256/icon.png")).getImage());
        icons.add(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/512x512/icon.png")).getImage());
        this.setIconImages(icons);
        this.setupOSXApplication(dockImage);
        this.init();
        this.profilesPath = this.preferences.get(PROFILES_PATH, USER_HOME);
        for (int i = 0; i < 4 && (recentProfile = this.preferences.get(RECENT_PROFILE + i, null)) != null; ++i) {
            this.recentProfiles.add(recentProfile);
            this.recentProfilesHaveChanged = true;
        }
        try {
            String plaf;
            SwingHelpUtilities.setContentViewerUI("ch.fhnw.util.ExternalLinkContentViewerUI");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            switch (CurrentOperatingSystem.OS) {
                case Mac_OS_X: {
                    plaf = "aqua";
                    break;
                }
                case Windows: {
                    plaf = "windows";
                    break;
                }
                default: {
                    plaf = "nimbus";
                }
            }
            URL helpSetURL = HelpSet.findHelpSet(classLoader, "ch/fhnw/jbackpack/help/" + plaf + "/HelpSet.hs");
            HelpSet helpSet = new HelpSet(classLoader, helpSetURL);
            this.helpbroker = helpSet.createHelpBroker();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "could not init Java help", exception);
        }
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.backupMainPanel = new BackupMainPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newProfileMenuItem = new JMenuItem();
        this.openProfileMenuItem = new JMenuItem();
        this.recentProfilesMenu = new JMenu();
        this.saveProfileMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.preferencesMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.quitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("BackupFrame.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                BackupFrame.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                BackupFrame.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.backupMainPanel.setName("backupMainPanel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.backupMainPanel, gridBagConstraints);
        this.fileMenu.setText(bundle.getString("BackupFrame.fileMenu.text"));
        this.fileMenu.setName("fileMenu");
        this.newProfileMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/filenew.png")));
        this.newProfileMenuItem.setText(bundle.getString("BackupFrame.newProfileMenuItem.text"));
        this.newProfileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.newProfileMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newProfileMenuItem);
        this.openProfileMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.openProfileMenuItem.setText(bundle.getString("BackupFrame.openProfileMenuItem.text"));
        this.openProfileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.openProfileMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProfileMenuItem);
        this.recentProfilesMenu.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/bookmark.png")));
        this.recentProfilesMenu.setText(bundle.getString("BackupFrame.recentProfilesMenu.text"));
        this.recentProfilesMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                BackupFrame.this.recentProfilesMenuMenuSelected(evt);
            }
        });
        this.fileMenu.add(this.recentProfilesMenu);
        this.saveProfileMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/filesaveas.png")));
        this.saveProfileMenuItem.setText(bundle.getString("BackupFrame.saveProfileMenuItem.text"));
        this.saveProfileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.saveProfileMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProfileMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.preferencesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/configure.png")));
        this.preferencesMenuItem.setText(bundle.getString("BackupFrame.preferencesMenuItem.text"));
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.preferencesMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.preferencesMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.quitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/exit.png")));
        this.quitMenuItem.setText(bundle.getString("BackupFrame.quitMenuItem.text"));
        this.quitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.quitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.quitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText(bundle.getString("BackupFrame.helpMenu.text"));
        this.helpMenu.setName("helpMenu");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/help.png")));
        this.helpMenuItem.setText(bundle.getString("BackupFrame.helpMenuItem.text"));
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.aboutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/info.png")));
        this.aboutMenuItem.setText(bundle.getString("BackupFrame.aboutMenuItem.text"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void quitMenuItemActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.exit();
    }

    private void saveProfileMenuItemActionPerformed(ActionEvent evt) {
        String title = BUNDLE.getString("Save_Profile");
        File selectedFile = null;
        if (CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X) {
            FileDialog fileDialog = new FileDialog((Frame)this, title, 1);
            fileDialog.setDirectory(this.profilesPath);
            fileDialog.setVisible(true);
            String directory = fileDialog.getDirectory();
            String file = fileDialog.getFile();
            if (directory != null && file != null) {
                selectedFile = new File(directory + file);
            }
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(title);
            fileChooser.setCurrentDirectory(new File(this.profilesPath));
            if (0 == fileChooser.showSaveDialog(this)) {
                selectedFile = fileChooser.getSelectedFile();
            }
        }
        if (selectedFile != null) {
            this.backupMainPanel.savePreferences();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(selectedFile);
                this.preferences.exportNode(fileOutputStream);
                this.addToRecentProFiles(selectedFile.getPath());
                JOptionPane.showMessageDialog(this, BUNDLE.getString("Profile_Saved"), BUNDLE.getString("Information"), 1, IconManager.INFORMATION_ICON);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                this.savingProfileFailed(ex);
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                this.savingProfileFailed(ex);
            }
            this.profilesPath = selectedFile.getParent();
        }
    }

    private void openProfileMenuItemActionPerformed(ActionEvent evt) {
        String title = BUNDLE.getString("Load_Profile");
        File selectedFile = null;
        if (CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X) {
            FileDialog fileDialog = new FileDialog((Frame)this, title, 0);
            fileDialog.setDirectory(this.profilesPath);
            fileDialog.setVisible(true);
            String directory = fileDialog.getDirectory();
            String file = fileDialog.getFile();
            if (directory != null && file != null) {
                selectedFile = new File(directory + file);
            }
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(title);
            fileChooser.setCurrentDirectory(new File(this.profilesPath));
            if (0 == fileChooser.showOpenDialog(this)) {
                selectedFile = fileChooser.getSelectedFile();
            }
        }
        if (selectedFile != null) {
            this.openProfile(selectedFile);
        }
    }

    private void recentProfilesMenuMenuSelected(MenuEvent evt) {
        if (this.recentProfilesHaveChanged) {
            this.recentProfilesMenu.removeAll();
            for (String recentProfile : this.recentProfiles) {
                JMenuItem newRecentProFileMenuItem = new JMenuItem(recentProfile);
                newRecentProFileMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        JMenuItem menuItem = (JMenuItem)event.getSource();
                        String path = menuItem.getText();
                        File file = new File(path);
                        BackupFrame.this.openProfile(file);
                    }
                });
                this.recentProfilesMenu.add(newRecentProFileMenuItem);
            }
            this.recentProfilesHaveChanged = false;
        }
    }

    private void newProfileMenuItemActionPerformed(ActionEvent evt) {
        this.backupMainPanel.clearSettings();
    }

    private void preferencesMenuItemActionPerformed(ActionEvent evt) {
        this.configure();
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        this.helpbroker.setCurrentID("JBackpack");
        this.helpbroker.setSize(new Dimension(800, 600));
        this.helpbroker.setDisplayed(true);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        this.about();
    }

    private void formWindowOpened(WindowEvent evt) {
        String localDestination = this.preferences.get("local_destination_directory", null);
        String remoteDestination = this.preferences.get("ssh_directory", null);
        if (localDestination == null && remoteDestination == null) {
            FirstTimeDialog dialog = new FirstTimeDialog(this);
            dialog.setVisible(true);
        }
    }

    private void configure() {
        String logFileName = null;
        try {
            Field filesField = FileHandler.class.getDeclaredField("files");
            filesField.setAccessible(true);
            File[] files = (File[])filesField.get(this.fileHandler);
            logFileName = files[0].getPath();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        PreferencesDialog preferencesDialog = new PreferencesDialog((Frame)this, logFileName, this.logLevel, this.backupMainPanel.isPlainBackupWarningSelected());
        preferencesDialog.setVisible(true);
        if (preferencesDialog.okPressed()) {
            this.setLogLevel(preferencesDialog.getLogLevel());
            this.backupMainPanel.setPlainBackupWarning(preferencesDialog.isShowPlainBackupWarningSelected());
        }
    }

    private void about() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setVisible(true);
    }

    private void setupOSXApplication(Image image) {
        if (CurrentOperatingSystem.OS != OperatingSystem.Mac_OS_X) {
            return;
        }
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Object application = applicationClass.newInstance();
            Object listener = Proxy.newProxyInstance(applicationListenerClass.getClassLoader(), new Class[]{applicationListenerClass}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) {
                    if (method.getName().equals("handleQuit")) {
                        BackupFrame.this.exit();
                    }
                    if (method.getName().equals("handlePreferences")) {
                        BackupFrame.this.configure();
                    }
                    if (method.getName().equals("handleAbout")) {
                        BackupFrame.this.about();
                        this.setHandled(args[0], Boolean.TRUE);
                    }
                    return null;
                }

                private void setHandled(Object event, Boolean value) {
                    try {
                        Method handleMethod = event.getClass().getMethod("setHandled", Boolean.TYPE);
                        handleMethod.invoke(event, value);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, null, exception);
                    }
                }
            });
            Method addApplicationListenerMethod = applicationClass.getMethod("addApplicationListener", applicationListenerClass);
            addApplicationListenerMethod.invoke(application, listener);
            Method enablePreferenceMethod = applicationClass.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            enablePreferenceMethod.invoke(application, Boolean.TRUE);
            Method setDockIconImageMethod = applicationClass.getMethod("setDockIconImage", Image.class);
            setDockIconImageMethod.invoke(application, image);
            this.fileMenu.remove(this.jSeparator1);
            this.fileMenu.remove(this.preferencesMenuItem);
            this.fileMenu.remove(this.jSeparator2);
            this.fileMenu.remove(this.quitMenuItem);
            this.helpMenu.remove(this.aboutMenuItem);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void savingProfileFailed(Exception exception) {
        String errorMessage = BUNDLE.getString("Error_Saving_Profile");
        errorMessage = MessageFormat.format(errorMessage, exception.toString());
        JOptionPane.showMessageDialog(this, errorMessage, BUNDLE.getString("Error"), 0);
    }

    private void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        Level level = logLevel.getLevel();
        GLOBAL_LOGGER.setLevel(level);
        UTIL_LOGGER.setLevel(level);
        this.consoleHandler.setLevel(level);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(level);
        }
    }

    private void init() {
        this.backupMainPanel.setParentFrame(this);
        this.backupMainPanel.init();
    }

    private void addToRecentProFiles(String path) {
        boolean entryExists = false;
        int existingIndex = 0;
        for (int i = 0; i < this.recentProfiles.size(); ++i) {
            if (!path.equals(this.recentProfiles.get(i))) continue;
            entryExists = true;
            existingIndex = i;
            break;
        }
        if (entryExists) {
            this.recentProfiles.add(0, this.recentProfiles.remove(existingIndex));
        } else {
            this.recentProfiles.add(0, path);
            int size = this.recentProfiles.size();
            if (size > 4) {
                this.recentProfiles.remove(size - 1);
            }
        }
        this.recentProfilesHaveChanged = true;
        this.savePreferences();
    }

    private void openProfile(File profile) {
        try {
            FileInputStream fileInputStream = new FileInputStream(profile);
            this.preferences.clear();
            Preferences.importPreferences(fileInputStream);
            this.backupMainPanel.setPreferences();
            this.backupMainPanel.maybeUnlock(false);
            this.addToRecentProFiles(profile.getPath());
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            this.openProfileFailed(profile.getPath());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            this.openProfileFailed(profile.getPath());
        }
        catch (InvalidPreferencesFormatException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            this.openProfileFailed(profile.getPath());
        }
    }

    private void openProfileFailed(String path) {
        String errorMessage = BUNDLE.getString("Error_Opening_Settings");
        errorMessage = MessageFormat.format(errorMessage, path);
        JOptionPane.showMessageDialog(this, errorMessage, BUNDLE.getString("Error"), 0);
        this.recentProfiles.remove(path);
        this.recentProfilesHaveChanged = true;
    }

    private void exit() {
        this.backupMainPanel.savePreferences();
        this.savePreferences();
        System.exit(0);
    }

    private void savePreferences() {
        int i;
        this.preferences.put(PROFILES_PATH, this.profilesPath);
        for (i = 0; i < this.recentProfiles.size(); ++i) {
            String recentFile = this.recentProfiles.get(i);
            this.preferences.put(RECENT_PROFILE + i, recentFile);
        }
        for (i = this.recentProfiles.size(); i < 4; ++i) {
            this.preferences.remove(RECENT_PROFILE + i);
        }
        this.preferences.putInt(LOGGING_LEVEL, this.logLevel.ordinal());
    }
}

