/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupServerCheckSwingWorker;
import ch.fhnw.jbackpack.ChangePasswordDialog;
import ch.fhnw.jbackpack.DecryptEncfsDialog;
import ch.fhnw.jbackpack.DecryptionCheckSwingWorker;
import ch.fhnw.jbackpack.DirectoryCheckDialog;
import ch.fhnw.jbackpack.EditReminderDialog;
import ch.fhnw.jbackpack.EncryptionCheckSwingWorker;
import ch.fhnw.jbackpack.ErrorDialog;
import ch.fhnw.jbackpack.FilenameCheckSwingWorker;
import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.JBackpack;
import ch.fhnw.jbackpack.JSqueezedLabel;
import ch.fhnw.jbackpack.NewEncfsDialog;
import ch.fhnw.jbackpack.PlaintextBackupWarningDialog;
import ch.fhnw.jbackpack.RdiffBackupRestore;
import ch.fhnw.jbackpack.SelectRestoreDirectoryDialog;
import ch.fhnw.jbackpack.SshPasswordDialog;
import ch.fhnw.jbackpack.UnlockEncfsDialog;
import ch.fhnw.jbackpack.chooser.ChrootFileSystemView;
import ch.fhnw.jbackpack.chooser.Increment;
import ch.fhnw.jbackpack.chooser.NoHiddenFilesSwingFileFilter;
import ch.fhnw.jbackpack.chooser.RdiffChooserPanel;
import ch.fhnw.jbackpack.chooser.RdiffFile;
import ch.fhnw.jbackpack.chooser.RdiffFileDatabase;
import ch.fhnw.jbackpack.chooser.SelectBackupDirectoryDialog;
import ch.fhnw.util.AutoStarter;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.OperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupMainPanel
extends JPanel
implements DocumentListener {
    public static final String SOURCE = "source";
    public static final String DESTINATION = "destination";
    public static final String LOCAL_DESTINATION_DIRECTORY = "local_destination_directory";
    public static final String SSH_SERVER = "ssh_server";
    public static final String SSH_USER = "ssh_user";
    public static final String SSH_BASE = "ssh_base";
    public static final String SSH_DIRECTORY = "ssh_directory";
    public static final String SMB_SERVER = "smb_server";
    public static final String SMB_SHARE = "smb_share";
    public static final String SMB_USER = "smb_user";
    public static final String SMB_DIRECTORY = "smb_directory";
    public static final String EXCLUDES = "excludes";
    public static final String EXCLUDES_LIST = "excludes_list";
    public static final String INCLUDES = "includes";
    public static final String INCLUDES_LIST = "includes_list";
    public static final String EXCLUDE_SYMLINKS = "exclude_symlinks";
    public static final String EXCLUDE_FIFOS = "exclude_fifos";
    public static final String EXCLUDE_OTHER_FILESYSTEMS = "exclude_other_filesystems";
    public static final String EXCLUDE_DEVICE_FILES = "exclude_device_files";
    public static final String EXCLUDE_SOCKETS = "exclude_sockets";
    public static final String COUNT_FILES = "count_files";
    public static final String PASSWORD_AUTHENTICATION = "password_authentication";
    public static final String PLAIN_BACKUP_WARNING = "show_plaintext_backup_warning_dialog";
    public static final String TEMPORARY_DIRECTORY = "temporary_directory";
    public static final String COMPRESS_BACKUP = "compress_backup";
    public static final String EXCLUDE_LARGE_FILES = "exclude_large_files";
    public static final String MAX_FILE_SIZE = "maximum_file_size";
    public static final String MAX_FILE_SIZE_UNIT = "maximum_file_size_unit";
    public static final String EXCLUDE_SMALL_FILES = "exclude_small_files";
    public static final String MIN_FILE_SIZE = "minimum_file_size";
    public static final String MIN_FILE_SIZE_UNIT = "minimum_file_size_unit";
    public static final String AUTO_DELETION_BY_NUMBER = "auto_deletion_by_number";
    public static final String AUTO_DELETION_NUMBER = "auto_deletion_number";
    public static final String AUTO_DELETION_BY_AGE = "auto_deletion_by_age";
    public static final String AUTO_DELETION_AGE = "auto_deletion_age";
    public static final String AUTO_DELETION_AGE_UNIT = "auto_deletion_age_unit";
    public static final String AUTO_DELETION_BY_SPACE = "auto_deletion_by_space";
    public static final String AUTO_DELETION_SPACE = "auto_deletion_space";
    public static final String AUTO_DELETION_SPACE_UNIT = "auto_deletion_space_unit";
    private static final Logger LOGGER = Logger.getLogger(BackupMainPanel.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String LOGIN = "login";
    private static final String LOGOUT = "logout";
    private static final String LOCK = "lock";
    private static final String UNLOCK = "unlock";
    private static final String ENCFS_SEARCH_STRING = "jbackpack_plain_";
    private static final NoHiddenFilesSwingFileFilter NO_HIDDEN_FILES_SWING_FILE_FILTER = NoHiddenFilesSwingFileFilter.getInstance();
    private final DateFormat timeFormat;
    private Frame parentFrame;
    private RdiffBackupRestore rdiffBackupRestore;
    private Map<String, JTextComponent> textComponentMap;
    private Map<String, JCheckBox> checkBoxMap;
    private Preferences preferences;
    private boolean processCancelled;
    private SwingWorker currentSwingWorker;
    private final ProcessExecutor processExecutor = new ProcessExecutor();
    private boolean sshfsMounted;
    private boolean smbfsMounted;
    private boolean destinationEncrypted;
    private String encfsMountPoint;
    private boolean commonDestinationOK;
    private boolean sshfsEnabled;
    private boolean smbfsEnabled = true;
    private boolean encfsEnabled;
    private boolean plainBackupWarning;
    private boolean showReminder;
    private int reminderTimeout;
    private JButton addExcludesButton;
    private JButton addIncludesButton;
    private JPanel advancedSettingsPanel;
    private ButtonGroup authenticationButtonGroup;
    private JCheckBox autoDeleteAgeCheckBox;
    private JComboBox autoDeleteAgeComboBox;
    private JSpinner autoDeleteAgeSpinner;
    private JCheckBox autoDeleteNumberCheckBox;
    private JLabel autoDeleteNumberLabel;
    private JSpinner autoDeleteNumberSpinner;
    private JPanel autoDeletionAgePanel;
    private JPanel autoDeletionHeaderPanel;
    private JLabel autoDeletionLabel;
    private JPanel autoDeletionNumberPanel;
    private JSeparator autoDeletionSeparator1;
    private JCheckBox autoDeletionSpaceCheckBox;
    private JComboBox autoDeletionSpaceComboBox;
    private JPanel autoDeletionSpacePanel;
    private JSpinner autoDeletionSpaceSpinner;
    private JButton backupButton;
    private JPanel backupCardPanel;
    private JPanel backupCheckBoxPanel;
    private JPanel backupConfigCardPanel;
    private JPanel backupConfigPanel;
    private JLabel backupDestinationLabel;
    private JLabel backupErrorLabel;
    private JPanel backupErrorPanel;
    private JPanel backupPanel;
    private JPanel backupReminderPanel;
    private JPanel backupRestoredPanel;
    private JButton backupSourceButton;
    private JLabel backupSourceLabel;
    private JTextField backupSourceTextField;
    private JButton cancelButton;
    private JButton changePasswordButton;
    private JPanel checkBoxPanel;
    private JCheckBox compressionCheckBox;
    private JButton continueButton;
    private JCheckBox countFilesCheckBox;
    private JRadioButton customTempDirRadioButton;
    private JButton decryptionButton;
    private JRadioButton defaultTempDirRadioButton;
    private JPanel destinationCardPanel;
    private JPanel destinationDirHeaderPanel;
    private ButtonGroup destinationLocationButtonGroup;
    private JPanel destinationRadioButtonPanel;
    private JSeparator destinationSeparator1;
    private JPanel directoriesPanel;
    private JButton encryptionButton;
    private JPanel encryptionCardPanel;
    private JLabel encryptionErrorLabel;
    private JPanel encryptionErrorPanel;
    private JPanel encryptionPanel;
    private JCheckBox excludeCheckBox;
    private JCheckBox excludeDeviceFilesCheckBox;
    private JCheckBox excludeFifosCheckBox;
    private JCheckBox excludeOtherFileSystemsCheckBox;
    private JCheckBox excludeSocketsCheckBox;
    private JCheckBox excludeSymlinksCheckBox;
    private JPanel excludesPanel;
    private JScrollPane excludesScrollPane;
    private JTextArea excludesTextArea;
    private JPanel filePatternsPanel;
    private JLabel filenameLabel;
    private JCheckBox includesCheckBox;
    private JPanel includesPanel;
    private JScrollPane includesScrollPane;
    private JTextArea includesTextArea;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator8;
    private JRadioButton localRadioButton;
    private JButton localStorageButton;
    private JPanel localStoragePanel;
    private JTextField localStorageTextField;
    private JButton lockButton;
    private JTabbedPane mainTabbedPane;
    private JCheckBox maxSizeCheckBox;
    private JComboBox maxSizeComboBox;
    private JTextField maxSizeTextField;
    private JCheckBox minSizeCheckBox;
    private JComboBox minSizeComboBox;
    private JTextField minSizeTextField;
    private JPanel noExcludesPanel;
    private JRadioButton otherDirectoryRadioButton;
    private JRadioButton otherSourceRadioButton;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JButton quitButton;
    private RdiffChooserPanel rdiffChooserPanel;
    private JButton reminderButton;
    private JLabel reminderLabel;
    private JTextField reminderTextField;
    private JButton restoreButton;
    private JPanel restoreButtonPanel;
    private JPanel restoreCardPanel;
    private JLabel restoreErrorLabel;
    private JPanel restoreErrorPanel;
    private ButtonGroup restoreLocationButtonGroup;
    private JPanel restorePanel;
    private JLabel restoredLabel;
    private JButton restoredOKButton;
    private JSeparator separator1;
    private JPanel sessionStatisticsPanel;
    private JCheckBox shutdownCheckBox;
    private JLabel shutdownLabel;
    private JPanel shutdownPanel;
    private JPasswordField shutdownPasswordField;
    private JPanel smbLocalHeaderPanel;
    private JLabel smbLocalLabel;
    private JSeparator smbLocalSeparator;
    private JButton smbLogInOutButton;
    private JPanel smbLoginPanel;
    private JProgressBar smbLoginProgressBar;
    private JPasswordField smbPasswordField;
    private JLabel smbPasswordLabel;
    private JRadioButton smbRadioButton;
    private JPanel smbRemoteHeaderPanel;
    private JLabel smbRemoteLabel;
    private JSeparator smbRemoteSeparator;
    private JLabel smbServerLabel;
    private JTextField smbServerTextField;
    private JLabel smbShareLabel;
    private JTextField smbShareTextField;
    private JButton smbStorageButton;
    private JLabel smbStorageLabel;
    private JPanel smbStoragePanel;
    private JTextField smbStorageTextField;
    private JPasswordField smbSudoPasswordField;
    private JLabel smbSudoPasswordLabel;
    private JLabel smbUserLabel;
    private JTextField smbUserTextField;
    private ButtonGroup sourceDirButtonGroup;
    private JPanel sourceDirDetailsPanel;
    private JPanel sourceDirHeaderPanel;
    private JPanel sourceDirRadioButtonPanel;
    private JSeparator sourceDirSeparator1;
    private JRadioButton sourceDirectoryRadioButton;
    private JPanel sshAuthenticationPanel;
    private JLabel sshBaseDirLabel;
    private JTextField sshBaseDirTextField;
    private JButton sshLogInOutButton;
    private JProgressBar sshLoginProgressBar;
    private JPasswordField sshPasswordField;
    private JRadioButton sshPasswordRadioButton;
    private JRadioButton sshPublicKeyRadioButton;
    private JRadioButton sshRadioButton;
    private JLabel sshServerLabel;
    private JPanel sshServerPanel;
    private JTextField sshServerTextField;
    private JButton sshStorageButton;
    private JLabel sshStorageLabel;
    private JPanel sshStoragePanel;
    private JTextField sshStorageTextField;
    private JLabel sshUserNameLabel;
    private JTextField sshUserNameTextField;
    private JLabel statisticsLabel;
    private JTextArea statisticsTextField;
    private JScrollPane statisticsTextFieldScrollPane;
    private JLabel storageUsageLabel;
    private JProgressBar storageUsageProgressBar;
    private JButton tempDirBrowseButton;
    private ButtonGroup tempDirButtonGroup;
    private JPanel tempDirDetailsPanel;
    private JPanel tempDirHeaderPanel;
    private JLabel tempDirLabel;
    private JPanel tempDirRadioButtonPanel;
    private JSeparator tempDirSeparator1;
    private JTextField tempDirTextField;
    private JLabel timeLabel;
    private JPanel unlockPanel;
    private JRadioButton userHomeRadioButton;

    public BackupMainPanel() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("LC_ALL", "C");
        this.processExecutor.setEnvironment(environment);
        this.initComponents();
        this.systemCheck();
        this.sshLogInOutButton.setActionCommand(LOGIN);
        this.smbLogInOutButton.setActionCommand(LOGIN);
        this.lockButton.setActionCommand(UNLOCK);
        this.timeFormat = new SimpleDateFormat("HH:mm:ss");
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.textComponentMap = new HashMap<String, JTextComponent>();
        this.textComponentMap.put(LOCAL_DESTINATION_DIRECTORY, this.localStorageTextField);
        this.textComponentMap.put(SSH_SERVER, this.sshServerTextField);
        this.textComponentMap.put(SSH_USER, this.sshUserNameTextField);
        this.textComponentMap.put(SSH_BASE, this.sshBaseDirTextField);
        this.textComponentMap.put(SSH_DIRECTORY, this.sshStorageTextField);
        this.textComponentMap.put(SMB_SERVER, this.smbServerTextField);
        this.textComponentMap.put(SMB_SHARE, this.smbShareTextField);
        this.textComponentMap.put(SMB_USER, this.smbUserTextField);
        this.textComponentMap.put(SMB_DIRECTORY, this.smbStorageTextField);
        this.textComponentMap.put(EXCLUDES_LIST, this.excludesTextArea);
        this.textComponentMap.put(INCLUDES_LIST, this.includesTextArea);
        this.textComponentMap.put(MAX_FILE_SIZE, this.maxSizeTextField);
        this.textComponentMap.put(MIN_FILE_SIZE, this.minSizeTextField);
        this.checkBoxMap = new HashMap<String, JCheckBox>();
        this.checkBoxMap.put(EXCLUDES, this.excludeCheckBox);
        this.checkBoxMap.put(INCLUDES, this.includesCheckBox);
        this.checkBoxMap.put(EXCLUDE_LARGE_FILES, this.maxSizeCheckBox);
        this.checkBoxMap.put(EXCLUDE_SMALL_FILES, this.minSizeCheckBox);
        this.checkBoxMap.put(EXCLUDE_OTHER_FILESYSTEMS, this.excludeOtherFileSystemsCheckBox);
        this.checkBoxMap.put(EXCLUDE_SYMLINKS, this.excludeSymlinksCheckBox);
        this.checkBoxMap.put(EXCLUDE_DEVICE_FILES, this.excludeDeviceFilesCheckBox);
        this.checkBoxMap.put(EXCLUDE_SOCKETS, this.excludeSocketsCheckBox);
        this.checkBoxMap.put(EXCLUDE_FIFOS, this.excludeFifosCheckBox);
        this.checkBoxMap.put(AUTO_DELETION_BY_NUMBER, this.autoDeleteNumberCheckBox);
        this.checkBoxMap.put(AUTO_DELETION_BY_AGE, this.autoDeleteAgeCheckBox);
        this.checkBoxMap.put(AUTO_DELETION_BY_SPACE, this.autoDeletionSpaceCheckBox);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.restoreErrorLabel.setIcon(IconManager.ERROR_ICON);
        this.backupErrorLabel.setIcon(IconManager.ERROR_ICON);
        this.encryptionErrorLabel.setIcon(IconManager.ERROR_ICON);
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        String[] sizeStrings = new String[]{BUNDLE.getString("Byte"), "KiB", "MiB", "GiB", "TiB"};
        this.maxSizeComboBox.setModel(new DefaultComboBoxModel<String>(sizeStrings));
        this.minSizeComboBox.setModel(new DefaultComboBoxModel<String>(sizeStrings));
        this.autoDeletionSpaceComboBox.setModel(new DefaultComboBoxModel<String>(sizeStrings));
        Dimension preferredSize = this.autoDeleteNumberSpinner.getPreferredSize();
        preferredSize.width = 60;
        this.autoDeleteNumberSpinner.setPreferredSize(preferredSize);
        this.autoDeleteAgeSpinner.setPreferredSize(preferredSize);
        preferredSize = this.autoDeletionSpaceSpinner.getPreferredSize();
        preferredSize.width = 80;
        this.autoDeletionSpaceSpinner.setPreferredSize(preferredSize);
        String[] ageStrings = new String[]{BUNDLE.getString("Days"), BUNDLE.getString("Weeks"), BUNDLE.getString("Months"), BUNDLE.getString("Years")};
        this.autoDeleteAgeComboBox.setModel(new DefaultComboBoxModel<String>(ageStrings));
        preferredSize = this.sourceDirSeparator1.getPreferredSize();
        preferredSize.width = 20;
        this.sourceDirSeparator1.setPreferredSize(preferredSize);
        this.destinationSeparator1.setPreferredSize(preferredSize);
        this.autoDeletionSeparator1.setPreferredSize(preferredSize);
        this.tempDirSeparator1.setPreferredSize(preferredSize);
        this.smbRemoteSeparator.setPreferredSize(preferredSize);
        this.smbLocalSeparator.setPreferredSize(preferredSize);
        switch (CurrentOperatingSystem.OS) {
            case Mac_OS_X: 
            case Windows: {
                this.smbRemoteHeaderPanel.setVisible(false);
                this.smbLocalHeaderPanel.setVisible(false);
                this.smbSudoPasswordLabel.setVisible(false);
                this.smbSudoPasswordField.setVisible(false);
            }
        }
    }

    public void init() {
        this.localStorageTextField.getDocument().addDocumentListener(this);
        this.sshStorageTextField.getDocument().addDocumentListener(this);
        this.smbStorageTextField.getDocument().addDocumentListener(this);
        this.tempDirTextField.getDocument().addDocumentListener(this);
        this.preferences = Preferences.userNodeForPackage(JBackpack.class);
        this.setPreferences();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File sourceDirectory;
                String sourcePath = BackupMainPanel.this.backupSourceTextField.getText();
                if (!(BackupMainPanel.this.checkSourceCommon(sourcePath, sourceDirectory = new File(sourcePath)) && BackupMainPanel.this.checkDestinationCommon() && BackupMainPanel.this.checkSourceBackup(sourceDirectory) && BackupMainPanel.this.checkSourceRestore(sourceDirectory))) {
                    BackupMainPanel.this.mainTabbedPane.setSelectedComponent(BackupMainPanel.this.directoriesPanel);
                    BackupMainPanel.this.maybeUnlock(true);
                    return;
                }
                BackupMainPanel.this.backupButton.requestFocusInWindow();
            }
        });
    }

    public void setParentFrame(Frame parentFrame) {
        this.parentFrame = parentFrame;
        this.rdiffChooserPanel.setParentWindow(parentFrame);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public void clearSettings() {
        this.compressionCheckBox.setSelected(true);
        this.showReminder = false;
        this.reminderTimeout = 7;
        this.updateReminderTextField();
        this.excludeCheckBox.setSelected(false);
        this.excludesTextArea.setText(null);
        this.includesCheckBox.setSelected(false);
        this.includesTextArea.setText(null);
        this.excludeSymlinksCheckBox.setSelected(false);
        this.excludeFifosCheckBox.setSelected(false);
        this.excludeOtherFileSystemsCheckBox.setSelected(false);
        this.excludeDeviceFilesCheckBox.setSelected(false);
        this.excludeSocketsCheckBox.setSelected(false);
        this.countFilesCheckBox.setSelected(true);
        this.backupSourceTextField.setText(null);
        this.localStorageTextField.setText(null);
        this.sshStorageTextField.setText(null);
        this.localRadioButton.setSelected(true);
        this.sshUserNameTextField.setText(null);
        this.sshServerTextField.setText(null);
        this.sshPasswordField.setText(null);
        this.mainTabbedPaneStateChanged(null);
    }

    public final void setPreferences() {
        for (String key : this.textComponentMap.keySet()) {
            this.textComponentMap.get(key).setText(this.preferences.get(key, ""));
        }
        for (String key : this.checkBoxMap.keySet()) {
            boolean value = this.preferences.getBoolean(key, false);
            this.checkBoxMap.get(key).setSelected(value);
        }
        this.includesCheckBoxItemStateChanged(null);
        this.excludeCheckBoxItemStateChanged(null);
        this.autoDeleteNumberSpinner.setValue(this.preferences.getInt(AUTO_DELETION_NUMBER, 100));
        this.autoDeleteAgeSpinner.setValue(this.preferences.getInt(AUTO_DELETION_AGE, 1));
        this.autoDeletionSpaceSpinner.setValue(this.preferences.getInt(AUTO_DELETION_SPACE, 10));
        this.showReminder = this.preferences.getBoolean("show_reminder", false);
        this.reminderTimeout = this.preferences.getInt("reminder_timeout", Integer.MIN_VALUE);
        this.updateReminderTextField();
        String source = this.preferences.get(SOURCE, null);
        if (source == null) {
            this.userHomeRadioButton.setSelected(true);
        } else {
            this.otherSourceRadioButton.setSelected(true);
            this.backupSourceTextField.setText(source);
        }
        this.updateSourceDirState();
        String sshUser = this.sshUserNameTextField.getText();
        String sshServer = this.sshServerTextField.getText();
        try {
            this.setSshMounted(FileTools.isMounted(sshUser + '@' + sshServer + ':'));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        try {
            this.setSmbMounted(this.getSmbfsMountPoint() != null);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        String destination = this.preferences.get(DESTINATION, "local");
        if ("local".equals(destination)) {
            this.localRadioButton.setSelected(true);
        } else if ("ssh".equals(destination)) {
            if (this.sshfsEnabled) {
                this.sshRadioButton.setSelected(true);
            } else {
                this.localRadioButton.setSelected(true);
            }
        } else if ("smb".equals(destination)) {
            if (this.smbfsEnabled) {
                this.smbRadioButton.setSelected(true);
            } else {
                this.localRadioButton.setSelected(true);
            }
        }
        if (this.preferences.getBoolean(PASSWORD_AUTHENTICATION, true)) {
            this.sshPasswordRadioButton.setSelected(true);
        } else {
            this.sshPublicKeyRadioButton.setSelected(true);
        }
        this.countFilesCheckBox.setSelected(this.preferences.getBoolean(COUNT_FILES, true));
        this.plainBackupWarning = this.preferences.getBoolean(PLAIN_BACKUP_WARNING, true);
        String temporaryDirectory = this.preferences.get(TEMPORARY_DIRECTORY, null);
        if (temporaryDirectory == null) {
            this.customTempDirRadioButton.setSelected(false);
        } else {
            this.customTempDirRadioButton.setSelected(true);
            this.tempDirTextField.setText(temporaryDirectory);
        }
        this.updateTempDirState();
        this.compressionCheckBox.setSelected(this.preferences.getBoolean(COMPRESS_BACKUP, true));
        this.maxSizeComboBox.setSelectedIndex(this.preferences.getInt(MAX_FILE_SIZE_UNIT, 0));
        this.minSizeComboBox.setSelectedIndex(this.preferences.getInt(MIN_FILE_SIZE_UNIT, 0));
        this.autoDeleteAgeComboBox.setSelectedIndex(this.preferences.getInt(AUTO_DELETION_AGE_UNIT, 3));
        this.autoDeletionSpaceComboBox.setSelectedIndex(this.preferences.getInt(AUTO_DELETION_SPACE_UNIT, 3));
        this.mainTabbedPaneStateChanged(null);
    }

    public void savePreferences() {
        for (String key : this.textComponentMap.keySet()) {
            this.preferences.put(key, this.textComponentMap.get(key).getText());
        }
        for (String key : this.checkBoxMap.keySet()) {
            this.preferences.putBoolean(key, this.checkBoxMap.get(key).isSelected());
        }
        this.preferences.putBoolean(COMPRESS_BACKUP, this.compressionCheckBox.isSelected());
        this.preferences.putInt(AUTO_DELETION_NUMBER, ((Number)this.autoDeleteNumberSpinner.getValue()).intValue());
        this.preferences.putInt(AUTO_DELETION_AGE, ((Number)this.autoDeleteAgeSpinner.getValue()).intValue());
        this.preferences.putInt(AUTO_DELETION_SPACE, ((Number)this.autoDeletionSpaceSpinner.getValue()).intValue());
        if (this.localRadioButton.isSelected()) {
            this.preferences.put(DESTINATION, "local");
        } else if (this.sshRadioButton.isSelected()) {
            this.preferences.put(DESTINATION, "ssh");
        } else if (this.smbRadioButton.isSelected()) {
            this.preferences.put(DESTINATION, "smb");
        }
        if (this.userHomeRadioButton.isSelected()) {
            this.preferences.remove(SOURCE);
        } else {
            this.preferences.put(SOURCE, this.backupSourceTextField.getText());
        }
        this.preferences.putBoolean(PASSWORD_AUTHENTICATION, this.sshPasswordRadioButton.isSelected());
        this.preferences.putBoolean(COUNT_FILES, this.countFilesCheckBox.isSelected());
        this.preferences.putBoolean(PLAIN_BACKUP_WARNING, this.plainBackupWarning);
        if (this.defaultTempDirRadioButton.isSelected()) {
            this.preferences.remove(TEMPORARY_DIRECTORY);
        } else {
            this.preferences.put(TEMPORARY_DIRECTORY, this.tempDirTextField.getText());
        }
        this.preferences.putBoolean("show_reminder", this.showReminder);
        this.preferences.putInt("reminder_timeout", this.reminderTimeout);
        this.preferences.putInt(MAX_FILE_SIZE_UNIT, this.maxSizeComboBox.getSelectedIndex());
        this.preferences.putInt(MIN_FILE_SIZE_UNIT, this.minSizeComboBox.getSelectedIndex());
        this.preferences.putInt(AUTO_DELETION_AGE_UNIT, this.autoDeleteAgeComboBox.getSelectedIndex());
        this.preferences.putInt(AUTO_DELETION_SPACE_UNIT, this.autoDeletionSpaceComboBox.getSelectedIndex());
    }

    public String getEncfsMountPoint() {
        return this.encfsMountPoint;
    }

    public void setEncfsMountPoint(String encfsMountPoint) {
        this.encfsMountPoint = encfsMountPoint;
    }

    public void setDestinationEncrypted(boolean destinationEncrypted) {
        this.destinationEncrypted = destinationEncrypted;
    }

    public boolean checkDestinationCommon() {
        String remoteStorage;
        String sourcePath = this.backupSourceTextField.getText();
        File sourceDirectory = new File(sourcePath);
        this.commonDestinationOK = false;
        this.destinationEncrypted = false;
        if (this.sshRadioButton.isSelected()) {
            if (!this.sshfsMounted) {
                String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
                this.showErrorPanels("Error_Not_Logged_In", directoriesTabName);
                this.encryptionErrorLabel.setText(BUNDLE.getString("Not_Logged_In"));
                this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
                return false;
            }
            remoteStorage = this.sshStorageTextField.getText();
            if (remoteStorage.length() == 0) {
                String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
                this.showErrorPanels("Error_No_Destination_Directory_Long", directoriesTabName);
                this.encryptionErrorLabel.setText(BUNDLE.getString("Error_No_Destination_Directory"));
                this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
                return false;
            }
        }
        if (this.smbRadioButton.isSelected()) {
            if (!this.smbfsMounted) {
                String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
                this.showErrorPanels("Error_Not_Logged_In", directoriesTabName);
                this.encryptionErrorLabel.setText(BUNDLE.getString("Not_Logged_In"));
                this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
                return false;
            }
            remoteStorage = this.smbStorageTextField.getText();
            if (remoteStorage.length() == 0) {
                String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
                this.showErrorPanels("Error_No_Destination_Directory_Long", directoriesTabName);
                this.encryptionErrorLabel.setText(BUNDLE.getString("Error_No_Destination_Directory"));
                this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
                return false;
            }
        }
        String destinationPath = this.getRawBackupDestination();
        if (CurrentOperatingSystem.OS != OperatingSystem.Windows && this.encfsEnabled && FileTools.isEncFS(destinationPath)) {
            this.showCard(this.encryptionCardPanel, "unlockPanel");
            this.destinationEncrypted = true;
            try {
                destinationPath = this.encfsMountPoint = FileTools.getEncfsMountPoint(ENCFS_SEARCH_STRING);
            }
            catch (IOException ex) {
                this.encfsMountPoint = null;
                LOGGER.log(Level.WARNING, null, ex);
            }
            if (this.encfsMountPoint == null) {
                this.updateLockButton(false);
                String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
                this.showErrorPanels("Error_Destination_Locked", directoriesTabName);
                return false;
            }
            this.updateLockButton(true);
        } else {
            this.showCard(this.encryptionCardPanel, "encryptionPanel");
        }
        File destinationDirectory = null;
        if (destinationPath != null) {
            destinationDirectory = new File(destinationPath);
        }
        if (destinationDirectory == null || destinationDirectory.getPath().length() == 0) {
            String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
            this.showErrorPanels("Error_No_Destination_Directory_Long", directoriesTabName);
            this.encryptionErrorLabel.setText(BUNDLE.getString("Error_No_Destination_Directory"));
            this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
            return false;
        }
        if (!destinationDirectory.exists()) {
            this.showErrorPanels("Error_Destination_Directory_Does_Not_Exist", new Object[0]);
            this.encryptionErrorLabel.setText(BUNDLE.getString("Error_Destination_Directory_Does_Not_Exist"));
            this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
            return false;
        }
        if (!destinationDirectory.isDirectory()) {
            this.showErrorPanels("Error_Destination_No_Directory", new Object[0]);
            this.encryptionErrorLabel.setText(BUNDLE.getString("Error_Destination_No_Directory"));
            this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
            return false;
        }
        if (!destinationDirectory.canRead()) {
            this.showErrorPanels("Error_Destination_Directory_Unreadable", new Object[0]);
            this.encryptionErrorLabel.setText(BUNDLE.getString("Error_Destination_Directory_Unreadable"));
            this.showCard(this.encryptionCardPanel, "encryptionErrorPanel");
            return false;
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            this.showErrorPanels("Error_Source_Equals_Destination", new Object[0]);
            return false;
        }
        this.commonDestinationOK = true;
        return true;
    }

    public void maybeUnlock(boolean switchToBackup) {
        if (this.destinationEncrypted && this.encfsMountPoint == null) {
            this.unlock(switchToBackup);
        }
        this.mainTabbedPaneStateChanged(null);
    }

    public void runBackup(Long minFileSize, Long maxFileSize, boolean directSSH, String sshPassword) {
        String sourcePath = this.backupSourceTextField.getText();
        String destinationPath = this.getBackupDestination();
        this.processCancelled = false;
        this.progressLabel.setText(BUNDLE.getString("Backing_Up_Files"));
        this.filenameLabel.setText(null);
        this.shutdownCheckBox.setText(BUNDLE.getString("Shutdown_After_Backup"));
        this.showCard(this, "progressPanel");
        this.cancelButton.requestFocusInWindow();
        this.rdiffBackupRestore = new RdiffBackupRestore();
        this.timeLabel.setText(this.timeFormat.format(new Date(0L)));
        this.currentSwingWorker = new BackupSwingWorker(sourcePath, destinationPath, maxFileSize, minFileSize, directSSH, sshPassword);
        this.currentSwingWorker.execute();
    }

    public boolean isPlainBackupWarningSelected() {
        return this.plainBackupWarning;
    }

    public void setPlainBackupWarning(boolean plainBackupWarning) {
        this.plainBackupWarning = plainBackupWarning;
    }

    private void initComponents() {
        this.restoreLocationButtonGroup = new ButtonGroup();
        this.sourceDirButtonGroup = new ButtonGroup();
        this.destinationLocationButtonGroup = new ButtonGroup();
        this.authenticationButtonGroup = new ButtonGroup();
        this.tempDirButtonGroup = new ButtonGroup();
        this.mainTabbedPane = new JTabbedPane();
        this.backupCardPanel = new JPanel();
        this.backupPanel = new JPanel();
        this.backupButton = new JButton();
        this.separator1 = new JSeparator();
        this.backupConfigPanel = new JPanel();
        this.backupCheckBoxPanel = new JPanel();
        this.compressionCheckBox = new JCheckBox();
        this.excludeCheckBox = new JCheckBox();
        this.backupReminderPanel = new JPanel();
        this.reminderLabel = new JLabel();
        this.reminderTextField = new JTextField();
        this.reminderButton = new JButton();
        this.backupConfigCardPanel = new JPanel();
        this.excludesPanel = new JPanel();
        this.filePatternsPanel = new JPanel();
        this.excludesScrollPane = new JScrollPane();
        this.excludesTextArea = new JTextArea();
        this.addExcludesButton = new JButton();
        this.includesCheckBox = new JCheckBox();
        this.includesPanel = new JPanel();
        this.includesScrollPane = new JScrollPane();
        this.includesTextArea = new JTextArea();
        this.addIncludesButton = new JButton();
        this.checkBoxPanel = new JPanel();
        this.maxSizeCheckBox = new JCheckBox();
        this.maxSizeTextField = new JTextField();
        this.maxSizeComboBox = new JComboBox();
        this.minSizeCheckBox = new JCheckBox();
        this.minSizeTextField = new JTextField();
        this.minSizeComboBox = new JComboBox();
        this.excludeOtherFileSystemsCheckBox = new JCheckBox();
        this.excludeSymlinksCheckBox = new JCheckBox();
        this.excludeDeviceFilesCheckBox = new JCheckBox();
        this.excludeSocketsCheckBox = new JCheckBox();
        this.excludeFifosCheckBox = new JCheckBox();
        this.noExcludesPanel = new JPanel();
        this.backupErrorPanel = new JPanel();
        this.backupErrorLabel = new JLabel();
        this.restoreCardPanel = new JPanel();
        this.restorePanel = new JPanel();
        this.rdiffChooserPanel = new RdiffChooserPanel();
        this.countFilesCheckBox = new JCheckBox();
        this.restoreButton = new JButton();
        this.restoreButtonPanel = new JPanel();
        this.sourceDirectoryRadioButton = new JRadioButton();
        this.otherDirectoryRadioButton = new JRadioButton();
        this.restoreErrorPanel = new JPanel();
        this.restoreErrorLabel = new JLabel();
        this.directoriesPanel = new JPanel();
        this.sourceDirHeaderPanel = new JPanel();
        this.sourceDirSeparator1 = new JSeparator();
        this.backupSourceLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.sourceDirRadioButtonPanel = new JPanel();
        this.userHomeRadioButton = new JRadioButton();
        this.otherSourceRadioButton = new JRadioButton();
        this.sourceDirDetailsPanel = new JPanel();
        this.backupSourceTextField = new JTextField();
        this.backupSourceButton = new JButton();
        this.destinationDirHeaderPanel = new JPanel();
        this.destinationSeparator1 = new JSeparator();
        this.backupDestinationLabel = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.destinationRadioButtonPanel = new JPanel();
        this.localRadioButton = new JRadioButton();
        this.sshRadioButton = new JRadioButton();
        this.smbRadioButton = new JRadioButton();
        this.destinationCardPanel = new JPanel();
        this.localStoragePanel = new JPanel();
        this.localStorageTextField = new JTextField();
        this.localStorageButton = new JButton();
        this.jPanel1 = new JPanel();
        this.sshStoragePanel = new JPanel();
        this.sshServerPanel = new JPanel();
        this.sshServerLabel = new JLabel();
        this.sshServerTextField = new JTextField();
        this.sshUserNameLabel = new JLabel();
        this.sshUserNameTextField = new JTextField();
        this.sshBaseDirLabel = new JLabel();
        this.sshBaseDirTextField = new JTextField();
        this.sshAuthenticationPanel = new JPanel();
        this.sshPasswordRadioButton = new JRadioButton();
        this.sshPasswordField = new JPasswordField();
        this.sshPublicKeyRadioButton = new JRadioButton();
        this.sshLogInOutButton = new JButton();
        this.sshLoginProgressBar = new JProgressBar();
        this.sshStorageLabel = new JLabel();
        this.sshStorageTextField = new JTextField();
        this.sshStorageButton = new JButton();
        this.jPanel3 = new JPanel();
        this.smbStoragePanel = new JPanel();
        this.smbRemoteHeaderPanel = new JPanel();
        this.smbRemoteSeparator = new JSeparator();
        this.smbRemoteLabel = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.smbServerLabel = new JLabel();
        this.smbServerTextField = new JTextField();
        this.smbShareLabel = new JLabel();
        this.smbShareTextField = new JTextField();
        this.smbUserLabel = new JLabel();
        this.smbUserTextField = new JTextField();
        this.smbPasswordLabel = new JLabel();
        this.smbPasswordField = new JPasswordField();
        this.smbLocalHeaderPanel = new JPanel();
        this.smbLocalSeparator = new JSeparator();
        this.smbLocalLabel = new JLabel();
        this.jSeparator5 = new JSeparator();
        this.smbSudoPasswordLabel = new JLabel();
        this.smbSudoPasswordField = new JPasswordField();
        this.smbLoginPanel = new JPanel();
        this.smbLogInOutButton = new JButton();
        this.smbLoginProgressBar = new JProgressBar();
        this.smbStorageLabel = new JLabel();
        this.smbStorageTextField = new JTextField();
        this.smbStorageButton = new JButton();
        this.jPanel2 = new JPanel();
        this.encryptionCardPanel = new JPanel();
        this.encryptionErrorPanel = new JPanel();
        this.encryptionErrorLabel = new JLabel();
        this.encryptionPanel = new JPanel();
        this.encryptionButton = new JButton();
        this.unlockPanel = new JPanel();
        this.lockButton = new JButton();
        this.changePasswordButton = new JButton();
        this.decryptionButton = new JButton();
        this.advancedSettingsPanel = new JPanel();
        this.autoDeletionHeaderPanel = new JPanel();
        this.autoDeletionSeparator1 = new JSeparator();
        this.autoDeletionLabel = new JLabel();
        this.jSeparator8 = new JSeparator();
        this.autoDeletionNumberPanel = new JPanel();
        this.autoDeleteNumberCheckBox = new JCheckBox();
        this.autoDeleteNumberSpinner = new JSpinner();
        this.autoDeleteNumberLabel = new JLabel();
        this.autoDeletionAgePanel = new JPanel();
        this.autoDeleteAgeCheckBox = new JCheckBox();
        this.autoDeleteAgeSpinner = new JSpinner();
        this.autoDeleteAgeComboBox = new JComboBox();
        this.autoDeletionSpacePanel = new JPanel();
        this.autoDeletionSpaceCheckBox = new JCheckBox();
        this.autoDeletionSpaceSpinner = new JSpinner();
        this.autoDeletionSpaceComboBox = new JComboBox();
        this.tempDirHeaderPanel = new JPanel();
        this.tempDirSeparator1 = new JSeparator();
        this.tempDirLabel = new JLabel();
        this.jSeparator6 = new JSeparator();
        this.tempDirRadioButtonPanel = new JPanel();
        this.defaultTempDirRadioButton = new JRadioButton();
        this.customTempDirRadioButton = new JRadioButton();
        this.tempDirDetailsPanel = new JPanel();
        this.tempDirTextField = new JTextField();
        this.tempDirBrowseButton = new JButton();
        this.storageUsageLabel = new JLabel();
        this.storageUsageProgressBar = new JProgressBar();
        this.progressPanel = new JPanel();
        this.progressLabel = new JLabel();
        this.filenameLabel = new JSqueezedLabel();
        this.progressBar = new JProgressBar();
        this.timeLabel = new JLabel();
        this.shutdownPanel = new JPanel();
        this.shutdownCheckBox = new JCheckBox();
        this.shutdownLabel = new JLabel();
        this.shutdownPasswordField = new JPasswordField();
        this.cancelButton = new JButton();
        this.sessionStatisticsPanel = new JPanel();
        this.statisticsLabel = new JLabel();
        this.statisticsTextFieldScrollPane = new JScrollPane();
        this.statisticsTextField = new JTextArea();
        this.continueButton = new JButton();
        this.quitButton = new JButton();
        this.backupRestoredPanel = new JPanel();
        this.restoredLabel = new JLabel();
        this.restoredOKButton = new JButton();
        this.setLayout(new CardLayout());
        this.mainTabbedPane.setName("mainTabbedPane");
        this.mainTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BackupMainPanel.this.mainTabbedPaneStateChanged(evt);
            }
        });
        this.backupCardPanel.setName("backupCardPanel");
        this.backupCardPanel.setLayout(new CardLayout());
        this.backupPanel.setLayout(new GridBagLayout());
        this.backupButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/32x32/kdat_backup.png")));
        this.backupButton.setMnemonic(ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings").getString("BackupMainPanel.backupButton.mnemonic").charAt(0));
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.backupButton.setText(bundle.getString("BackupMainPanel.backupButton.text"));
        this.backupButton.setName("backupButton");
        this.backupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.backupButtonActionPerformed(evt);
            }
        });
        this.backupButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.backupButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.backupButtonFocusLost(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.backupPanel.add((Component)this.backupButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.backupPanel.add((Component)this.separator1, gridBagConstraints);
        this.backupConfigPanel.setLayout(new GridBagLayout());
        this.backupCheckBoxPanel.setLayout(new GridBagLayout());
        this.compressionCheckBox.setSelected(true);
        this.compressionCheckBox.setText(bundle.getString("BackupMainPanel.compressionCheckBox.text"));
        this.compressionCheckBox.setToolTipText(bundle.getString("BackupMainPanel.compressionCheckBox.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.backupCheckBoxPanel.add((Component)this.compressionCheckBox, gridBagConstraints);
        this.excludeCheckBox.setText(bundle.getString("BackupMainPanel.excludeCheckBox.text"));
        this.excludeCheckBox.setName("excludeCheckBox");
        this.excludeCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.excludeCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.backupCheckBoxPanel.add((Component)this.excludeCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.backupConfigPanel.add((Component)this.backupCheckBoxPanel, gridBagConstraints);
        this.backupReminderPanel.setLayout(new GridBagLayout());
        this.reminderLabel.setText(bundle.getString("BackupMainPanel.reminderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.backupReminderPanel.add((Component)this.reminderLabel, gridBagConstraints);
        this.reminderTextField.setColumns(10);
        this.reminderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.backupReminderPanel.add((Component)this.reminderTextField, gridBagConstraints);
        this.reminderButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/configure.png")));
        this.reminderButton.setToolTipText(bundle.getString("BackupMainPanel.reminderButton.toolTipText"));
        this.reminderButton.setMargin(new Insets(2, 2, 2, 2));
        this.reminderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.reminderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.backupReminderPanel.add((Component)this.reminderButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.backupConfigPanel.add((Component)this.backupReminderPanel, gridBagConstraints);
        this.backupConfigCardPanel.setLayout(new CardLayout());
        this.excludesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BackupMainPanel.excludesPanel.border.title")));
        this.excludesPanel.setName("excludesPanel");
        this.excludesPanel.setLayout(new GridBagLayout());
        this.filePatternsPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BackupMainPanel.filePatternsPanel.border.title")));
        this.filePatternsPanel.setLayout(new GridBagLayout());
        this.excludesTextArea.setName("excludesTextArea");
        this.excludesScrollPane.setViewportView(this.excludesTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.filePatternsPanel.add((Component)this.excludesScrollPane, gridBagConstraints);
        this.addExcludesButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/add.png")));
        this.addExcludesButton.setMargin(new Insets(2, 2, 2, 2));
        this.addExcludesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.addExcludesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.filePatternsPanel.add((Component)this.addExcludesButton, gridBagConstraints);
        this.includesCheckBox.setText(bundle.getString("BackupMainPanel.includesCheckBox.text"));
        this.includesCheckBox.setName("includesCheckBox");
        this.includesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.includesCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.filePatternsPanel.add((Component)this.includesCheckBox, gridBagConstraints);
        this.includesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BackupMainPanel.includesPanel.border.title")));
        this.includesPanel.setLayout(new GridBagLayout());
        this.includesTextArea.setName("includesTextArea");
        this.includesScrollPane.setViewportView(this.includesTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.includesPanel.add((Component)this.includesScrollPane, gridBagConstraints);
        this.addIncludesButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/add.png")));
        this.addIncludesButton.setMargin(new Insets(2, 2, 2, 2));
        this.addIncludesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.addIncludesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.includesPanel.add((Component)this.addIncludesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.filePatternsPanel.add((Component)this.includesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.excludesPanel.add((Component)this.filePatternsPanel, gridBagConstraints);
        this.checkBoxPanel.setLayout(new GridBagLayout());
        this.maxSizeCheckBox.setText(bundle.getString("BackupMainPanel.maxSizeCheckBox.text"));
        this.maxSizeCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.maxSizeCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.checkBoxPanel.add((Component)this.maxSizeCheckBox, gridBagConstraints);
        this.maxSizeTextField.setColumns(6);
        this.maxSizeTextField.setHorizontalAlignment(11);
        this.maxSizeTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 15, 0, 0);
        this.checkBoxPanel.add((Component)this.maxSizeTextField, gridBagConstraints);
        this.maxSizeComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        this.checkBoxPanel.add((Component)this.maxSizeComboBox, gridBagConstraints);
        this.minSizeCheckBox.setText(bundle.getString("BackupMainPanel.minSizeCheckBox.text"));
        this.minSizeCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.minSizeCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.checkBoxPanel.add((Component)this.minSizeCheckBox, gridBagConstraints);
        this.minSizeTextField.setColumns(6);
        this.minSizeTextField.setHorizontalAlignment(11);
        this.minSizeTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 15, 0, 0);
        this.checkBoxPanel.add((Component)this.minSizeTextField, gridBagConstraints);
        this.minSizeComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        this.checkBoxPanel.add((Component)this.minSizeComboBox, gridBagConstraints);
        this.excludeOtherFileSystemsCheckBox.setText(bundle.getString("BackupMainPanel.excludeOtherFileSystemsCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.checkBoxPanel.add((Component)this.excludeOtherFileSystemsCheckBox, gridBagConstraints);
        this.excludeSymlinksCheckBox.setText(bundle.getString("BackupMainPanel.excludeSymlinksCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.checkBoxPanel.add((Component)this.excludeSymlinksCheckBox, gridBagConstraints);
        this.excludeDeviceFilesCheckBox.setText(bundle.getString("BackupMainPanel.excludeDeviceFilesCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.checkBoxPanel.add((Component)this.excludeDeviceFilesCheckBox, gridBagConstraints);
        this.excludeSocketsCheckBox.setText(bundle.getString("BackupMainPanel.excludeSocketsCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.checkBoxPanel.add((Component)this.excludeSocketsCheckBox, gridBagConstraints);
        this.excludeFifosCheckBox.setText(bundle.getString("BackupMainPanel.excludeFifosCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.checkBoxPanel.add((Component)this.excludeFifosCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        this.excludesPanel.add((Component)this.checkBoxPanel, gridBagConstraints);
        this.backupConfigCardPanel.add((Component)this.excludesPanel, "excludesPanel");
        this.noExcludesPanel.setLayout(new GridBagLayout());
        this.backupConfigCardPanel.add((Component)this.noExcludesPanel, "noExcludesPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.backupConfigPanel.add((Component)this.backupConfigCardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.backupPanel.add((Component)this.backupConfigPanel, gridBagConstraints);
        this.backupCardPanel.add((Component)this.backupPanel, "backupPanel");
        this.backupErrorPanel.setLayout(new GridBagLayout());
        this.backupErrorLabel.setText(bundle.getString("Error_Not_Logged_In"));
        this.backupErrorLabel.setName("backupErrorLabel");
        this.backupErrorPanel.add((Component)this.backupErrorLabel, new GridBagConstraints());
        this.backupCardPanel.add((Component)this.backupErrorPanel, "backupErrorPanel");
        this.mainTabbedPane.addTab(bundle.getString("BackupMainPanel.backupCardPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/kdat_backup.png")), this.backupCardPanel);
        this.restoreCardPanel.setName("restoreCardPanel");
        this.restoreCardPanel.setLayout(new CardLayout());
        this.restorePanel.setLayout(new GridBagLayout());
        this.rdiffChooserPanel.setName("rdiffChooserPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.restorePanel.add((Component)this.rdiffChooserPanel, gridBagConstraints);
        this.countFilesCheckBox.setText(bundle.getString("BackupMainPanel.countFilesCheckBox.text"));
        this.countFilesCheckBox.setToolTipText(bundle.getString("BackupMainPanel.countFilesCheckBox.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.restorePanel.add((Component)this.countFilesCheckBox, gridBagConstraints);
        this.restoreButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/32x32/kdat_restore.png")));
        this.restoreButton.setMnemonic(ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings").getString("Restore.mnemonic").charAt(0));
        this.restoreButton.setText(bundle.getString("Restore"));
        this.restoreButton.setName("restoreButton");
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.restoreButtonActionPerformed(evt);
            }
        });
        this.restoreButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.restoreButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.restoreButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.restorePanel.add((Component)this.restoreButton, gridBagConstraints);
        this.restoreButtonPanel.setLayout(new GridBagLayout());
        this.restoreLocationButtonGroup.add(this.sourceDirectoryRadioButton);
        this.sourceDirectoryRadioButton.setSelected(true);
        this.sourceDirectoryRadioButton.setText(bundle.getString("BackupMainPanel.sourceDirectoryRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.restoreButtonPanel.add((Component)this.sourceDirectoryRadioButton, gridBagConstraints);
        this.restoreLocationButtonGroup.add(this.otherDirectoryRadioButton);
        this.otherDirectoryRadioButton.setText(bundle.getString("BackupMainPanel.otherDirectoryRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.restoreButtonPanel.add((Component)this.otherDirectoryRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.restorePanel.add((Component)this.restoreButtonPanel, gridBagConstraints);
        this.restoreCardPanel.add((Component)this.restorePanel, "restorePanel");
        this.restoreErrorPanel.setLayout(new GridBagLayout());
        this.restoreErrorLabel.setText(bundle.getString("Error_Not_Logged_In"));
        this.restoreErrorPanel.add((Component)this.restoreErrorLabel, new GridBagConstraints());
        this.restoreCardPanel.add((Component)this.restoreErrorPanel, "restoreErrorPanel");
        this.mainTabbedPane.addTab(bundle.getString("BackupMainPanel.restoreCardPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/kdat_restore.png")), this.restoreCardPanel);
        this.directoriesPanel.setName("directoriesPanel");
        this.directoriesPanel.setLayout(new GridBagLayout());
        this.sourceDirHeaderPanel.setLayout(new GridBagLayout());
        this.sourceDirHeaderPanel.add((Component)this.sourceDirSeparator1, new GridBagConstraints());
        this.backupSourceLabel.setFont(this.backupSourceLabel.getFont().deriveFont(this.backupSourceLabel.getFont().getStyle() | 1));
        this.backupSourceLabel.setText(bundle.getString("BackupMainPanel.backupSourceLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.sourceDirHeaderPanel.add((Component)this.backupSourceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.sourceDirHeaderPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.directoriesPanel.add((Component)this.sourceDirHeaderPanel, gridBagConstraints);
        this.sourceDirRadioButtonPanel.setLayout(new GridBagLayout());
        this.sourceDirButtonGroup.add(this.userHomeRadioButton);
        this.userHomeRadioButton.setSelected(true);
        this.userHomeRadioButton.setText(bundle.getString("BackupMainPanel.userHomeRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.sourceDirRadioButtonPanel.add((Component)this.userHomeRadioButton, gridBagConstraints);
        this.sourceDirButtonGroup.add(this.otherSourceRadioButton);
        this.otherSourceRadioButton.setText(bundle.getString("BackupMainPanel.otherSourceRadioButton.text"));
        this.otherSourceRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.otherSourceRadioButtonItemStateChanged(evt);
            }
        });
        this.otherSourceRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.otherSourceRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.sourceDirRadioButtonPanel.add((Component)this.otherSourceRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.directoriesPanel.add((Component)this.sourceDirRadioButtonPanel, gridBagConstraints);
        this.sourceDirDetailsPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.sourceDirDetailsPanel.setLayout(new GridBagLayout());
        this.backupSourceTextField.setName("backupSourceTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.sourceDirDetailsPanel.add((Component)this.backupSourceTextField, gridBagConstraints);
        this.backupSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.backupSourceButton.setMargin(new Insets(2, 2, 2, 2));
        this.backupSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.backupSourceButtonActionPerformed(evt);
            }
        });
        this.backupSourceButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.backupSourceButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.backupSourceButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.sourceDirDetailsPanel.add((Component)this.backupSourceButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.directoriesPanel.add((Component)this.sourceDirDetailsPanel, gridBagConstraints);
        this.destinationDirHeaderPanel.setLayout(new GridBagLayout());
        this.destinationDirHeaderPanel.add((Component)this.destinationSeparator1, new GridBagConstraints());
        this.backupDestinationLabel.setFont(this.backupDestinationLabel.getFont().deriveFont(this.backupDestinationLabel.getFont().getStyle() | 1));
        this.backupDestinationLabel.setText(bundle.getString("BackupMainPanel.backupDestinationLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.destinationDirHeaderPanel.add((Component)this.backupDestinationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.destinationDirHeaderPanel.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.directoriesPanel.add((Component)this.destinationDirHeaderPanel, gridBagConstraints);
        this.destinationRadioButtonPanel.setLayout(new GridBagLayout());
        this.destinationLocationButtonGroup.add(this.localRadioButton);
        this.localRadioButton.setSelected(true);
        this.localRadioButton.setText(bundle.getString("BackupMainPanel.localRadioButton.text"));
        this.localRadioButton.setName("localRadioButton");
        this.localRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.localRadioButtonItemStateChanged(evt);
            }
        });
        this.localRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.localRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.destinationRadioButtonPanel.add((Component)this.localRadioButton, gridBagConstraints);
        this.destinationLocationButtonGroup.add(this.sshRadioButton);
        this.sshRadioButton.setText(bundle.getString("BackupMainPanel.sshRadioButton.text"));
        this.sshRadioButton.setName("sshRadioButton");
        this.sshRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.sshRadioButtonItemStateChanged(evt);
            }
        });
        this.sshRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.destinationRadioButtonPanel.add((Component)this.sshRadioButton, gridBagConstraints);
        this.destinationLocationButtonGroup.add(this.smbRadioButton);
        this.smbRadioButton.setText(bundle.getString("BackupMainPanel.smbRadioButton.text"));
        this.smbRadioButton.setName("smbRadioButton");
        this.smbRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.smbRadioButtonItemStateChanged(evt);
            }
        });
        this.smbRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.destinationRadioButtonPanel.add((Component)this.smbRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.directoriesPanel.add((Component)this.destinationRadioButtonPanel, gridBagConstraints);
        this.destinationCardPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.destinationCardPanel.setName("destinationCardPanel");
        this.destinationCardPanel.setLayout(new CardLayout());
        this.localStoragePanel.setLayout(new GridBagLayout());
        this.localStorageTextField.setName("localStorageTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.localStoragePanel.add((Component)this.localStorageTextField, gridBagConstraints);
        this.localStorageButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.localStorageButton.setMargin(new Insets(2, 2, 2, 2));
        this.localStorageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.localStorageButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 5);
        this.localStoragePanel.add((Component)this.localStorageButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.localStoragePanel.add((Component)this.jPanel1, gridBagConstraints);
        this.destinationCardPanel.add((Component)this.localStoragePanel, "localStoragePanel");
        this.sshStoragePanel.setLayout(new GridBagLayout());
        this.sshServerPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BackupMainPanel.sshServerPanel.border.title")));
        this.sshServerPanel.setLayout(new GridBagLayout());
        this.sshServerLabel.setText(bundle.getString("BackupMainPanel.sshServerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.sshServerPanel.add((Component)this.sshServerLabel, gridBagConstraints);
        this.sshServerTextField.setName("sshServerTextField");
        this.sshServerTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshServerTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.sshServerPanel.add((Component)this.sshServerTextField, gridBagConstraints);
        this.sshUserNameLabel.setText(bundle.getString("BackupMainPanel.sshUserNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.sshServerPanel.add((Component)this.sshUserNameLabel, gridBagConstraints);
        this.sshUserNameTextField.setName("sshUserNameTextField");
        this.sshUserNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshUserNameTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.sshServerPanel.add((Component)this.sshUserNameTextField, gridBagConstraints);
        this.sshBaseDirLabel.setText(bundle.getString("BackupMainPanel.sshBaseDirLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.sshServerPanel.add((Component)this.sshBaseDirLabel, gridBagConstraints);
        this.sshBaseDirTextField.setName("sshBaseDirTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.sshServerPanel.add((Component)this.sshBaseDirTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.sshStoragePanel.add((Component)this.sshServerPanel, gridBagConstraints);
        this.sshAuthenticationPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BackupMainPanel.sshAuthenticationPanel.border.title")));
        this.sshAuthenticationPanel.setLayout(new GridBagLayout());
        this.authenticationButtonGroup.add(this.sshPasswordRadioButton);
        this.sshPasswordRadioButton.setSelected(true);
        this.sshPasswordRadioButton.setText(bundle.getString("BackupMainPanel.sshPasswordRadioButton.text"));
        this.sshPasswordRadioButton.setName("sshPasswordRadioButton");
        this.sshPasswordRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.sshPasswordRadioButtonItemStateChanged(evt);
            }
        });
        this.sshPasswordRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshPasswordRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.sshAuthenticationPanel.add((Component)this.sshPasswordRadioButton, gridBagConstraints);
        this.sshPasswordField.setName("sshPasswordField");
        this.sshPasswordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshPasswordFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.sshAuthenticationPanel.add((Component)this.sshPasswordField, gridBagConstraints);
        this.authenticationButtonGroup.add(this.sshPublicKeyRadioButton);
        this.sshPublicKeyRadioButton.setText(bundle.getString("BackupMainPanel.sshPublicKeyRadioButton.text"));
        this.sshPublicKeyRadioButton.setName("sshPublicKeyRadioButton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.sshAuthenticationPanel.add((Component)this.sshPublicKeyRadioButton, gridBagConstraints);
        this.sshLogInOutButton.setText(bundle.getString("Login"));
        this.sshLogInOutButton.setName("sshLogInOutButton");
        this.sshLogInOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshLogInOutButtonActionPerformed(evt);
            }
        });
        this.sshLogInOutButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.sshLogInOutButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.sshLogInOutButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.sshAuthenticationPanel.add((Component)this.sshLogInOutButton, gridBagConstraints);
        this.sshLoginProgressBar.setName("sshLoginProgressBar");
        this.sshLoginProgressBar.setString(bundle.getString("Not_Logged_In"));
        this.sshLoginProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.sshAuthenticationPanel.add((Component)this.sshLoginProgressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.sshStoragePanel.add((Component)this.sshAuthenticationPanel, gridBagConstraints);
        this.sshStorageLabel.setText(bundle.getString("BackupMainPanel.sshStorageLabel.text"));
        this.sshStorageLabel.setEnabled(false);
        this.sshStorageLabel.setName("sshStorageLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 8, 5, 0);
        this.sshStoragePanel.add((Component)this.sshStorageLabel, gridBagConstraints);
        this.sshStorageTextField.setEnabled(false);
        this.sshStorageTextField.setName("sshStorageTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.sshStoragePanel.add((Component)this.sshStorageTextField, gridBagConstraints);
        this.sshStorageButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.sshStorageButton.setEnabled(false);
        this.sshStorageButton.setMargin(new Insets(2, 2, 2, 2));
        this.sshStorageButton.setName("sshStorageButton");
        this.sshStorageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.sshStorageButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.sshStoragePanel.add((Component)this.sshStorageButton, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.sshStoragePanel.add((Component)this.jPanel3, gridBagConstraints);
        this.destinationCardPanel.add((Component)this.sshStoragePanel, "sshStoragePanel");
        this.smbStoragePanel.setLayout(new GridBagLayout());
        this.smbRemoteHeaderPanel.setLayout(new GridBagLayout());
        this.smbRemoteHeaderPanel.add((Component)this.smbRemoteSeparator, new GridBagConstraints());
        this.smbRemoteLabel.setFont(this.smbRemoteLabel.getFont().deriveFont(this.smbRemoteLabel.getFont().getStyle() | 1));
        this.smbRemoteLabel.setText(bundle.getString("BackupMainPanel.smbRemoteLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.smbRemoteHeaderPanel.add((Component)this.smbRemoteLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.smbRemoteHeaderPanel.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.smbStoragePanel.add((Component)this.smbRemoteHeaderPanel, gridBagConstraints);
        this.smbServerLabel.setText(bundle.getString("BackupMainPanel.smbServerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbStoragePanel.add((Component)this.smbServerLabel, gridBagConstraints);
        this.smbServerTextField.setName("smbServerTextField");
        this.smbServerTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbServerTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbStoragePanel.add((Component)this.smbServerTextField, gridBagConstraints);
        this.smbShareLabel.setText(bundle.getString("BackupMainPanel.smbShareLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbStoragePanel.add((Component)this.smbShareLabel, gridBagConstraints);
        this.smbShareTextField.setName("smbShareTextField");
        this.smbShareTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbShareTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbStoragePanel.add((Component)this.smbShareTextField, gridBagConstraints);
        this.smbUserLabel.setText(bundle.getString("BackupMainPanel.smbUserLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbStoragePanel.add((Component)this.smbUserLabel, gridBagConstraints);
        this.smbUserTextField.setName("smbUserTextField");
        this.smbUserTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbUserTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbStoragePanel.add((Component)this.smbUserTextField, gridBagConstraints);
        this.smbPasswordLabel.setText(bundle.getString("BackupMainPanel.smbPasswordLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbStoragePanel.add((Component)this.smbPasswordLabel, gridBagConstraints);
        this.smbPasswordField.setName("smbPasswordField");
        this.smbPasswordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbPasswordFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbStoragePanel.add((Component)this.smbPasswordField, gridBagConstraints);
        this.smbLocalHeaderPanel.setLayout(new GridBagLayout());
        this.smbLocalHeaderPanel.add((Component)this.smbLocalSeparator, new GridBagConstraints());
        this.smbLocalLabel.setFont(this.smbLocalLabel.getFont().deriveFont(this.smbLocalLabel.getFont().getStyle() | 1));
        this.smbLocalLabel.setText(bundle.getString("BackupMainPanel.smbLocalLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.smbLocalHeaderPanel.add((Component)this.smbLocalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.smbLocalHeaderPanel.add((Component)this.jSeparator5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.smbStoragePanel.add((Component)this.smbLocalHeaderPanel, gridBagConstraints);
        this.smbSudoPasswordLabel.setText(bundle.getString("BackupMainPanel.smbSudoPasswordLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbStoragePanel.add((Component)this.smbSudoPasswordLabel, gridBagConstraints);
        this.smbSudoPasswordField.setName("smbSudoPasswordField");
        this.smbSudoPasswordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbSudoPasswordFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbStoragePanel.add((Component)this.smbSudoPasswordField, gridBagConstraints);
        this.smbLoginPanel.setLayout(new GridBagLayout());
        this.smbLogInOutButton.setText(bundle.getString("Login"));
        this.smbLogInOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbLogInOutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbLoginPanel.add((Component)this.smbLogInOutButton, gridBagConstraints);
        this.smbLoginProgressBar.setString(bundle.getString("Not_Logged_In"));
        this.smbLoginProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbLoginPanel.add((Component)this.smbLoginProgressBar, gridBagConstraints);
        this.smbStorageLabel.setText(bundle.getString("BackupMainPanel.smbStorageLabel.text"));
        this.smbStorageLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.smbLoginPanel.add((Component)this.smbStorageLabel, gridBagConstraints);
        this.smbStorageTextField.setEnabled(false);
        this.smbStorageTextField.setName("smbStorageTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.smbLoginPanel.add((Component)this.smbStorageTextField, gridBagConstraints);
        this.smbStorageButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.smbStorageButton.setEnabled(false);
        this.smbStorageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.smbStorageButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.smbLoginPanel.add((Component)this.smbStorageButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.smbStoragePanel.add((Component)this.smbLoginPanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.smbStoragePanel.add((Component)this.jPanel2, gridBagConstraints);
        this.destinationCardPanel.add((Component)this.smbStoragePanel, "smbStoragePanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.directoriesPanel.add((Component)this.destinationCardPanel, gridBagConstraints);
        this.encryptionCardPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BackupMainPanel.encryptionCardPanel.border.title")));
        this.encryptionCardPanel.setName("encryptionCardPanel");
        this.encryptionCardPanel.setLayout(new CardLayout());
        this.encryptionErrorPanel.setLayout(new GridBagLayout());
        this.encryptionErrorLabel.setText(bundle.getString("BackupMainPanel.encryptionErrorLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.encryptionErrorPanel.add((Component)this.encryptionErrorLabel, gridBagConstraints);
        this.encryptionCardPanel.add((Component)this.encryptionErrorPanel, "encryptionErrorPanel");
        this.encryptionPanel.setLayout(new GridBagLayout());
        this.encryptionButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/folder_locked.png")));
        this.encryptionButton.setText(bundle.getString("BackupMainPanel.encryptionButton.text"));
        this.encryptionButton.setName("encryptionButton");
        this.encryptionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.encryptionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.encryptionPanel.add((Component)this.encryptionButton, gridBagConstraints);
        this.encryptionCardPanel.add((Component)this.encryptionPanel, "encryptionPanel");
        this.unlockPanel.setLayout(new GridBagLayout());
        this.lockButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/password.png")));
        this.lockButton.setText(bundle.getString("Unlock"));
        this.lockButton.setName("lockButton");
        this.lockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.lockButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.unlockPanel.add((Component)this.lockButton, gridBagConstraints);
        this.changePasswordButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/reload.png")));
        this.changePasswordButton.setText(bundle.getString("BackupMainPanel.changePasswordButton.text"));
        this.changePasswordButton.setName("changePasswordButton");
        this.changePasswordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.changePasswordButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.unlockPanel.add((Component)this.changePasswordButton, gridBagConstraints);
        this.decryptionButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/folder.png")));
        this.decryptionButton.setText(bundle.getString("BackupMainPanel.decryptionButton.text"));
        this.decryptionButton.setName("decryptionButton");
        this.decryptionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.decryptionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.unlockPanel.add((Component)this.decryptionButton, gridBagConstraints);
        this.encryptionCardPanel.add((Component)this.unlockPanel, "unlockPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 10, 8);
        this.directoriesPanel.add((Component)this.encryptionCardPanel, gridBagConstraints);
        this.mainTabbedPane.addTab(bundle.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/folder.png")), this.directoriesPanel);
        this.advancedSettingsPanel.setLayout(new GridBagLayout());
        this.autoDeletionHeaderPanel.setLayout(new GridBagLayout());
        this.autoDeletionHeaderPanel.add((Component)this.autoDeletionSeparator1, new GridBagConstraints());
        this.autoDeletionLabel.setFont(this.autoDeletionLabel.getFont().deriveFont(this.autoDeletionLabel.getFont().getStyle() | 1));
        this.autoDeletionLabel.setText(bundle.getString("BackupMainPanel.autoDeletionLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionHeaderPanel.add((Component)this.autoDeletionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionHeaderPanel.add((Component)this.jSeparator8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.advancedSettingsPanel.add((Component)this.autoDeletionHeaderPanel, gridBagConstraints);
        this.autoDeletionNumberPanel.setLayout(new GridBagLayout());
        this.autoDeleteNumberCheckBox.setText(bundle.getString("BackupMainPanel.autoDeleteNumberCheckBox.text"));
        this.autoDeletionNumberPanel.add((Component)this.autoDeleteNumberCheckBox, new GridBagConstraints());
        this.autoDeleteNumberSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.autoDeleteNumberSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BackupMainPanel.this.autoDeleteNumberSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionNumberPanel.add((Component)this.autoDeleteNumberSpinner, gridBagConstraints);
        this.autoDeleteNumberLabel.setText(bundle.getString("AutoDeleteBackup"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionNumberPanel.add((Component)this.autoDeleteNumberLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.advancedSettingsPanel.add((Component)this.autoDeletionNumberPanel, gridBagConstraints);
        this.autoDeletionAgePanel.setLayout(new GridBagLayout());
        this.autoDeleteAgeCheckBox.setText(bundle.getString("BackupMainPanel.autoDeleteAgeCheckBox.text"));
        this.autoDeletionAgePanel.add((Component)this.autoDeleteAgeCheckBox, new GridBagConstraints());
        this.autoDeleteAgeSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionAgePanel.add((Component)this.autoDeleteAgeSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionAgePanel.add((Component)this.autoDeleteAgeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.advancedSettingsPanel.add((Component)this.autoDeletionAgePanel, gridBagConstraints);
        this.autoDeletionSpacePanel.setLayout(new GridBagLayout());
        this.autoDeletionSpaceCheckBox.setText(bundle.getString("BackupMainPanel.autoDeletionSpaceCheckBox.text"));
        this.autoDeletionSpacePanel.add((Component)this.autoDeletionSpaceCheckBox, new GridBagConstraints());
        this.autoDeletionSpaceSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionSpacePanel.add((Component)this.autoDeletionSpaceSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.autoDeletionSpacePanel.add((Component)this.autoDeletionSpaceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.advancedSettingsPanel.add((Component)this.autoDeletionSpacePanel, gridBagConstraints);
        this.tempDirHeaderPanel.setLayout(new GridBagLayout());
        this.tempDirHeaderPanel.add((Component)this.tempDirSeparator1, new GridBagConstraints());
        this.tempDirLabel.setFont(this.tempDirLabel.getFont().deriveFont(this.tempDirLabel.getFont().getStyle() | 1));
        this.tempDirLabel.setText(bundle.getString("BackupMainPanel.tempDirLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.tempDirHeaderPanel.add((Component)this.tempDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.tempDirHeaderPanel.add((Component)this.jSeparator6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.advancedSettingsPanel.add((Component)this.tempDirHeaderPanel, gridBagConstraints);
        this.tempDirRadioButtonPanel.setLayout(new GridBagLayout());
        this.tempDirButtonGroup.add(this.defaultTempDirRadioButton);
        this.defaultTempDirRadioButton.setSelected(true);
        this.defaultTempDirRadioButton.setText(bundle.getString("BackupMainPanel.defaultTempDirRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.tempDirRadioButtonPanel.add((Component)this.defaultTempDirRadioButton, gridBagConstraints);
        this.tempDirButtonGroup.add(this.customTempDirRadioButton);
        this.customTempDirRadioButton.setText(bundle.getString("BackupMainPanel.customTempDirRadioButton.text"));
        this.customTempDirRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BackupMainPanel.this.customTempDirRadioButtonItemStateChanged(evt);
            }
        });
        this.customTempDirRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.customTempDirRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.tempDirRadioButtonPanel.add((Component)this.customTempDirRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.advancedSettingsPanel.add((Component)this.tempDirRadioButtonPanel, gridBagConstraints);
        this.tempDirDetailsPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.tempDirDetailsPanel.setName("tempDirDetailsPanel");
        this.tempDirDetailsPanel.setLayout(new GridBagLayout());
        this.tempDirTextField.setName("tempDirTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.tempDirDetailsPanel.add((Component)this.tempDirTextField, gridBagConstraints);
        this.tempDirBrowseButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.tempDirBrowseButton.setMargin(new Insets(2, 2, 2, 2));
        this.tempDirBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.tempDirBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 5);
        this.tempDirDetailsPanel.add((Component)this.tempDirBrowseButton, gridBagConstraints);
        this.storageUsageLabel.setText(bundle.getString("BackupMainPanel.storageUsageLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.tempDirDetailsPanel.add((Component)this.storageUsageLabel, gridBagConstraints);
        this.storageUsageProgressBar.setFont(this.storageUsageProgressBar.getFont().deriveFont(this.storageUsageProgressBar.getFont().getStyle() & 0xFFFFFFFE));
        this.storageUsageProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.tempDirDetailsPanel.add((Component)this.storageUsageProgressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.advancedSettingsPanel.add((Component)this.tempDirDetailsPanel, gridBagConstraints);
        this.mainTabbedPane.addTab(bundle.getString("BackupMainPanel.advancedSettingsPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/configure.png")), this.advancedSettingsPanel);
        this.add((Component)this.mainTabbedPane, "mainTabbedPane");
        this.progressPanel.setLayout(new GridBagLayout());
        this.progressLabel.setText(bundle.getString("BackupMainPanel.progressLabel.text"));
        this.progressLabel.setName("progressLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.progressPanel.add((Component)this.progressLabel, gridBagConstraints);
        this.filenameLabel.setFont(this.filenameLabel.getFont().deriveFont(this.filenameLabel.getFont().getStyle() & 0xFFFFFFFE, this.filenameLabel.getFont().getSize() - 1));
        this.filenameLabel.setHorizontalAlignment(0);
        this.filenameLabel.setText(bundle.getString("BackupMainPanel.filenameLabel.text"));
        this.filenameLabel.setName("filenameLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.progressPanel.add((Component)this.filenameLabel, gridBagConstraints);
        this.progressBar.setIndeterminate(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.progressPanel.add((Component)this.progressBar, gridBagConstraints);
        this.timeLabel.setText(bundle.getString("BackupMainPanel.timeLabel.text"));
        this.timeLabel.setName("timeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.progressPanel.add((Component)this.timeLabel, gridBagConstraints);
        this.shutdownCheckBox.setText(bundle.getString("Shutdown_After_Backup"));
        this.shutdownCheckBox.setName("shutdownCheckBox");
        this.shutdownCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BackupMainPanel.this.shutdownCheckBoxStateChanged(evt);
            }
        });
        this.shutdownLabel.setText(bundle.getString("BackupMainPanel.shutdownLabel.text"));
        this.shutdownLabel.setEnabled(false);
        this.shutdownPasswordField.setColumns(10);
        this.shutdownPasswordField.setEnabled(false);
        this.shutdownPasswordField.setName("shutdownPasswordField");
        GroupLayout shutdownPanelLayout = new GroupLayout(this.shutdownPanel);
        this.shutdownPanel.setLayout(shutdownPanelLayout);
        shutdownPanelLayout.setHorizontalGroup(shutdownPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(shutdownPanelLayout.createSequentialGroup().addContainerGap().addGroup(shutdownPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(shutdownPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.shutdownLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shutdownPasswordField, -2, -1, -2)).addComponent(this.shutdownCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        shutdownPanelLayout.setVerticalGroup(shutdownPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(shutdownPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.shutdownCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(shutdownPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.shutdownLabel).addComponent(this.shutdownPasswordField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.progressPanel.add((Component)this.shutdownPanel, gridBagConstraints);
        this.cancelButton.setText(bundle.getString("BackupMainPanel.cancelButton.text"));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.cancelButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.cancelButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.progressPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.add((Component)this.progressPanel, "progressPanel");
        this.sessionStatisticsPanel.setLayout(new GridBagLayout());
        this.statisticsLabel.setText(bundle.getString("BackupMainPanel.statisticsLabel.text"));
        this.statisticsLabel.setName("statisticsLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.sessionStatisticsPanel.add((Component)this.statisticsLabel, gridBagConstraints);
        this.statisticsTextFieldScrollPane.setName("statisticsTextFieldScrollPane");
        this.statisticsTextField.setColumns(35);
        this.statisticsTextField.setEditable(false);
        this.statisticsTextField.setRows(5);
        this.statisticsTextFieldScrollPane.setViewportView(this.statisticsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.sessionStatisticsPanel.add((Component)this.statisticsTextFieldScrollPane, gridBagConstraints);
        this.continueButton.setText(bundle.getString("BackupMainPanel.continueButton.text"));
        this.continueButton.setName("continueButton");
        this.continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.continueButtonActionPerformed(evt);
            }
        });
        this.continueButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.continueButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.continueButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.sessionStatisticsPanel.add((Component)this.continueButton, gridBagConstraints);
        this.quitButton.setText(bundle.getString("BackupMainPanel.quitButton.text"));
        this.quitButton.setName("quitButton");
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.quitButtonActionPerformed(evt);
            }
        });
        this.quitButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.quitButtonFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.sessionStatisticsPanel.add((Component)this.quitButton, gridBagConstraints);
        this.add((Component)this.sessionStatisticsPanel, "sessionStatisticsPanel");
        this.backupRestoredPanel.setLayout(new GridBagLayout());
        this.restoredLabel.setText(bundle.getString("Restoring_Successfull"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.backupRestoredPanel.add((Component)this.restoredLabel, gridBagConstraints);
        this.restoredOKButton.setText(bundle.getString("BackupMainPanel.restoredOKButton.text"));
        this.restoredOKButton.setName("restoredOKButton");
        this.restoredOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BackupMainPanel.this.restoredOKButtonActionPerformed(evt);
            }
        });
        this.restoredOKButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                BackupMainPanel.this.restoredOKButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                BackupMainPanel.this.restoredOKButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.backupRestoredPanel.add((Component)this.restoredOKButton, gridBagConstraints);
        this.add((Component)this.backupRestoredPanel, "backupRestoredPanel");
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        RdiffFile[] selectedFiles = this.rdiffChooserPanel.getSelectedFiles();
        if (selectedFiles == null) {
            this.showError("Error_No_Files_Selected");
            return;
        }
        if (this.sourceDirectoryRadioButton.isSelected()) {
            boolean showWarning = false;
            File sourceDirectory = new File(this.backupSourceTextField.getText());
            if (selectedFiles.length != 1 || selectedFiles[0].getParentFile() != null) {
                for (RdiffFile selectedFile : selectedFiles) {
                    File testFile = new File(sourceDirectory, selectedFile.getPath());
                    if (!testFile.exists()) continue;
                    showWarning = true;
                    break;
                }
            }
            if (showWarning && 0 != JOptionPane.showConfirmDialog(this.parentFrame, BUNDLE.getString("Restore_Warning"), BUNDLE.getString("Warning"), 0, 2)) {
                return;
            }
            this.restore(selectedFiles, sourceDirectory);
        } else {
            SelectRestoreDirectoryDialog dialog = new SelectRestoreDirectoryDialog(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.restoreSelected()) {
                this.restore(selectedFiles, dialog.getSelectedDirectory());
            }
        }
    }

    private void backupButtonActionPerformed(ActionEvent evt) {
        Long minFileSize;
        boolean exclude = this.excludeCheckBox.isSelected();
        Long maxFileSize = exclude && this.maxSizeCheckBox.isSelected() ? Long.valueOf(this.getFileSize(this.maxSizeTextField, this.maxSizeComboBox)) : null;
        Long l = minFileSize = exclude && this.minSizeCheckBox.isSelected() ? Long.valueOf(this.getFileSize(this.minSizeTextField, this.minSizeComboBox)) : null;
        if (maxFileSize != null && maxFileSize <= 0L) {
            this.maxSizeTextField.requestFocusInWindow();
            this.maxSizeTextField.selectAll();
            JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Error_Max_File_Size"), BUNDLE.getString("Error"), 0);
            return;
        }
        if (minFileSize != null && minFileSize <= 0L) {
            this.minSizeTextField.requestFocusInWindow();
            this.minSizeTextField.selectAll();
            JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Error_Min_File_Size"), BUNDLE.getString("Error"), 0);
            return;
        }
        if (maxFileSize != null && minFileSize != null && minFileSize >= maxFileSize) {
            this.maxSizeTextField.requestFocusInWindow();
            this.maxSizeTextField.selectAll();
            JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Error_Min_Max_File_Size"), BUNDLE.getString("Error"), 0);
            return;
        }
        String sshUserName = this.sshUserNameTextField.getText();
        String sshServerName = this.sshServerTextField.getText();
        String sshPassword = this.getSshPassword(sshUserName, sshServerName);
        if (this.destinationEncrypted) {
            this.runBackup(minFileSize, maxFileSize, false, sshPassword);
        } else {
            if (this.encfsEnabled && this.plainBackupWarning) {
                PlaintextBackupWarningDialog dialog = new PlaintextBackupWarningDialog(this.parentFrame);
                dialog.setVisible(true);
                this.plainBackupWarning = dialog.isShowWarningSelected();
                if (dialog.isOkPressed()) {
                    this.mainTabbedPane.setSelectedComponent(this.directoriesPanel);
                    this.encrypt();
                    return;
                }
            }
            if (this.sshfsMounted) {
                BackupServerCheckSwingWorker backupServerCheckSwingWorker = new BackupServerCheckSwingWorker(this.parentFrame, sshUserName, sshServerName, sshPassword, this, minFileSize, maxFileSize);
                backupServerCheckSwingWorker.execute();
            } else {
                this.runBackup(minFileSize, maxFileSize, false, sshPassword);
            }
        }
    }

    private void continueButtonActionPerformed(ActionEvent evt) {
        this.showCard(this, "mainTabbedPane");
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        Object[] options = new Object[]{BUNDLE.getString("Yes"), BUNDLE.getString("No")};
        JOptionPane optionPane = new JOptionPane(BUNDLE.getString("Cancel_Question"), 3, 0, null, options, options[1]);
        JDialog dialog = optionPane.createDialog(this.parentFrame, BUNDLE.getString("Question"));
        dialog.setVisible(true);
        if (options[0] == optionPane.getValue()) {
            this.processCancelled = true;
            this.rdiffBackupRestore.cancelRdiffOperation();
            this.currentSwingWorker.cancel(true);
            this.showCard(this, "mainTabbedPane");
        }
    }

    private void restoredOKButtonActionPerformed(ActionEvent evt) {
        this.showCard(this, "mainTabbedPane");
        this.mainTabbedPane.requestFocusInWindow();
    }

    private void backupSourceButtonActionPerformed(ActionEvent evt) {
        String title = BUNDLE.getString("Select_Source_Directory");
        String currentPath = this.backupSourceTextField.getText();
        if (CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X) {
            FileDialog fileDialog = new FileDialog(this.parentFrame, title, 0);
            fileDialog.setDirectory(currentPath);
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String directory = fileDialog.getDirectory();
            String file = fileDialog.getFile();
            if (directory != null && file != null) {
                this.backupSourceTextField.setText(directory + file + File.separatorChar);
            }
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setApproveButtonText(BUNDLE.getString("Select"));
            fileChooser.addChoosableFileFilter(NO_HIDDEN_FILES_SWING_FILE_FILTER);
            fileChooser.setFileFilter(NO_HIDDEN_FILES_SWING_FILE_FILTER);
            fileChooser.setDialogTitle(title);
            fileChooser.setCurrentDirectory(new File(currentPath));
            int selectedOption = fileChooser.showOpenDialog(this.parentFrame);
            if (selectedOption == 0) {
                String selectedPath = fileChooser.getSelectedFile().getPath();
                this.backupSourceTextField.setText(selectedPath);
            }
        }
    }

    private void sshLogInOutButtonActionPerformed(ActionEvent evt) {
        if (LOGIN.equals(this.sshLogInOutButton.getActionCommand())) {
            this.sshLogin(false);
        } else {
            try {
                String mountPoint;
                RdiffFileDatabase rdiffFileDatabase = this.rdiffChooserPanel.getRdiffFileDatabase();
                if (rdiffFileDatabase != null) {
                    rdiffFileDatabase.close();
                }
                if ((mountPoint = this.getSshfsMountPoint()) != null && FileTools.umountFUSE(new File(mountPoint), true)) {
                    this.setSshMounted(false);
                    this.destinationChanged();
                    this.sshPasswordField.requestFocusInWindow();
                } else {
                    JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Logout_Failed"), BUNDLE.getString("Error"), 0);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void addExcludesButtonActionPerformed(ActionEvent evt) {
        this.addSelectedFiles(BUNDLE.getString("Select_Files_To_Exclude"), new File(this.backupSourceTextField.getText()), this.excludesTextArea);
    }

    private void addIncludesButtonActionPerformed(ActionEvent evt) {
        this.addSelectedFiles(BUNDLE.getString("Select_Exceptions"), new File(this.backupSourceTextField.getText()), this.includesTextArea);
    }

    private void mainTabbedPaneStateChanged(ChangeEvent evt) {
        int selectedIndex = this.mainTabbedPane.getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                String sourcePath = this.backupSourceTextField.getText();
                File sourceDirectory = new File(sourcePath);
                if (!this.checkSourceCommon(sourcePath, sourceDirectory) || !this.checkSourceBackup(sourceDirectory) || !this.checkDestinationCommon() || !this.checkDestinationBackup() || !this.checkTempDirectory()) break;
                this.showCard(this.backupCardPanel, "backupPanel");
                break;
            }
            case 1: {
                String sourcePath = this.backupSourceTextField.getText();
                File sourceDirectory = new File(sourcePath);
                if (!this.checkSourceCommon(sourcePath, sourceDirectory) || !this.checkSourceRestore(sourceDirectory) || !this.checkDestinationCommon() || !this.checkTempDirectory()) break;
                this.showCard(this.restoreCardPanel, "restorePanel");
                this.rdiffChooserPanel.setSelectedDirectory(this.getBackupDestination());
                break;
            }
            case 2: {
                this.directoriesTabFocusHandling();
                break;
            }
            case 3: {
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "unhandled tab index {0}", selectedIndex);
            }
        }
    }

    private void backupButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.backupButton);
    }

    private void backupSourceButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.backupSourceButton);
    }

    private void restoreButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.restoreButton);
    }

    private void cancelButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void continueButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.continueButton);
    }

    private void restoredOKButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.restoredOKButton);
    }

    private void backupButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void backupSourceButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void restoreButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void cancelButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void continueButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void restoredOKButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void sshLogInOutButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.sshLogInOutButton);
    }

    private void sshLogInOutButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void encryptionButtonActionPerformed(ActionEvent evt) {
        this.encrypt();
    }

    private void localStorageButtonActionPerformed(ActionEvent evt) {
        String selectedPath = this.localStorageTextField.getText();
        SelectBackupDirectoryDialog dialog = new SelectBackupDirectoryDialog(this.parentFrame, null, selectedPath, false);
        if (dialog.showDialog() == 0) {
            this.localStorageTextField.setText(dialog.getSelectedPath());
        }
    }

    private void sshStorageButtonActionPerformed(ActionEvent evt) {
        try {
            this.selectRemoteDirectory(this.sshServerTextField.getText(), this.sshStorageTextField, this.getSshfsMountPoint());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void decryptionButtonActionPerformed(ActionEvent evt) {
        String cipherPath;
        block7: {
            cipherPath = this.getRawBackupDestination();
            if (this.encfsMountPoint == null) {
                DecryptEncfsDialog dialog = new DecryptEncfsDialog(this.parentFrame);
                if (0 == dialog.showDialog()) {
                    String password = dialog.getPassword();
                    try {
                        this.encfsMountPoint = FileTools.createTempDirectory(ENCFS_SEARCH_STRING, null).getPath();
                        if (!FileTools.mountEncFs(cipherPath, this.encfsMountPoint, password)) {
                            LOGGER.log(Level.WARNING, "could not mount {0}", cipherPath);
                            return;
                        }
                        break block7;
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                        return;
                    }
                }
                return;
            }
            Object[] options = new Object[]{BUNDLE.getString("Yes"), BUNDLE.getString("No")};
            JOptionPane optionPane = new JOptionPane(BUNDLE.getString("Decryption_Warning"), 2, 0, null, options, options[1]);
            JDialog dialog = optionPane.createDialog(this.parentFrame, BUNDLE.getString("Warning"));
            dialog.setVisible(true);
            if (options[0] != optionPane.getValue()) {
                return;
            }
        }
        File encfsPlainDir = new File(this.encfsMountPoint);
        File encfsCipherDir = new File(cipherPath);
        DirectoryCheckDialog directoryCheckDialog = new DirectoryCheckDialog(this.parentFrame);
        directoryCheckDialog.setFilenameCheckEnabled(false, 0);
        ModalDialogHandler dialogHandler = new ModalDialogHandler(directoryCheckDialog);
        DecryptionCheckSwingWorker decryptionCheckSwingWorker = new DecryptionCheckSwingWorker(this.parentFrame, this, directoryCheckDialog, dialogHandler, encfsCipherDir, encfsPlainDir);
        if (FileTools.isSpaceKnown(encfsCipherDir)) {
            long usableSpace = encfsCipherDir.getUsableSpace();
            directoryCheckDialog.setFreeSpaceKnown(true, usableSpace);
            decryptionCheckSwingWorker.setUsableSpace(usableSpace);
        }
        decryptionCheckSwingWorker.execute();
        dialogHandler.show();
    }

    private void lockButtonActionPerformed(ActionEvent evt) {
        if (UNLOCK.equals(this.lockButton.getActionCommand())) {
            this.unlock(false);
        } else {
            this.lock();
        }
    }

    private void changePasswordButtonActionPerformed(ActionEvent evt) {
        ChangePasswordDialog dialog = new ChangePasswordDialog(this.parentFrame);
        if (0 == dialog.showDialog()) {
            String oldPassword = dialog.getOldPassword();
            String newPassword = dialog.getNewPassword();
            String changePasswordScript = "#!/usr/bin/expect -f" + LINE_SEPARATOR + "set oldPassword [lindex $argv 0]" + LINE_SEPARATOR + "set newPassword [lindex $argv 1]" + LINE_SEPARATOR + "spawn encfsctl passwd \"" + this.getRawBackupDestination() + '\"' + LINE_SEPARATOR + "expect \"EncFS Password: \"" + LINE_SEPARATOR + "send \"$oldPassword\r\"" + LINE_SEPARATOR + "expect \"New Encfs Password: \"" + LINE_SEPARATOR + "send \"$newPassword\r\"" + LINE_SEPARATOR + "expect \"Verify Encfs Password: \"" + LINE_SEPARATOR + "send \"$newPassword\r\"" + LINE_SEPARATOR + "expect eof" + LINE_SEPARATOR + "set ret [lindex [wait] 3]" + LINE_SEPARATOR + "puts \"return value: $ret\"" + LINE_SEPARATOR + "exit $ret";
            Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
            Level level = logger.getLevel();
            logger.setLevel(Level.OFF);
            int returnValue = -1;
            try {
                returnValue = this.processExecutor.executeScript(changePasswordScript, oldPassword, newPassword);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            logger.setLevel(level);
            if (returnValue == 0) {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Password_Changed"), BUNDLE.getString("Information"), 1, IconManager.INFORMATION_ICON);
            } else {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Password_Not_Changed"), BUNDLE.getString("Error"), 0);
            }
        }
    }

    private void sshServerTextFieldActionPerformed(ActionEvent evt) {
        this.sshUserNameTextField.selectAll();
        this.sshUserNameTextField.requestFocusInWindow();
    }

    private void shutdownCheckBoxStateChanged(ChangeEvent evt) {
        boolean enabled = this.shutdownCheckBox.isSelected();
        this.shutdownLabel.setEnabled(enabled);
        this.shutdownPasswordField.setEnabled(enabled);
    }

    private void sshUserNameTextFieldActionPerformed(ActionEvent evt) {
        this.sshPasswordField.selectAll();
        this.sshPasswordField.requestFocusInWindow();
    }

    private void sshPasswordFieldActionPerformed(ActionEvent evt) {
        this.sshLogin(true);
    }

    private void includesCheckBoxItemStateChanged(ItemEvent evt) {
        this.includesPanel.setVisible(this.includesCheckBox.isSelected());
    }

    private void excludeCheckBoxItemStateChanged(ItemEvent evt) {
        if (this.excludeCheckBox.isSelected()) {
            this.showCard(this.backupConfigCardPanel, "excludesPanel");
        } else {
            this.showCard(this.backupConfigCardPanel, "noExcludesPanel");
        }
    }

    private void tempDirBrowseButtonActionPerformed(ActionEvent evt) {
        String title = BUNDLE.getString("Select_Temp_Directory");
        File currentDir = new File(this.tempDirTextField.getText());
        File parentFile = currentDir.getParentFile();
        while (!currentDir.exists() && parentFile != null) {
            currentDir = parentFile;
            parentFile = currentDir.getParentFile();
        }
        if (CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X) {
            FileDialog fileDialog = new FileDialog(this.parentFrame, title, 0);
            fileDialog.setDirectory(currentDir.getPath());
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String directory = fileDialog.getDirectory();
            String file = fileDialog.getFile();
            if (directory != null && file != null) {
                this.tempDirTextField.setText(directory + file + File.separatorChar);
            }
        } else {
            JFileChooser directoryChooser = new JFileChooser();
            directoryChooser.setFileSelectionMode(1);
            directoryChooser.setFileHidingEnabled(false);
            NoHiddenFilesSwingFileFilter noHiddenFilesSwingFilter = NoHiddenFilesSwingFileFilter.getInstance();
            directoryChooser.addChoosableFileFilter(noHiddenFilesSwingFilter);
            directoryChooser.setFileFilter(noHiddenFilesSwingFilter);
            directoryChooser.setCurrentDirectory(currentDir);
            directoryChooser.setDialogTitle(title);
            directoryChooser.setApproveButtonText(BUNDLE.getString("Choose"));
            if (directoryChooser.showOpenDialog(this) == 0) {
                String selectedPath = directoryChooser.getSelectedFile().getPath();
                this.tempDirTextField.setText(selectedPath);
            }
        }
    }

    private void localRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.localRadioButton.isSelected()) {
            this.showCard(this.destinationCardPanel, "localStoragePanel");
            this.destinationChanged();
        }
    }

    private void sshPasswordRadioButtonItemStateChanged(ItemEvent evt) {
        boolean selected = this.sshPasswordRadioButton.isSelected();
        this.sshPasswordField.setEnabled(selected);
        this.sshPasswordField.setEditable(selected);
    }

    private void customTempDirRadioButtonItemStateChanged(ItemEvent evt) {
        this.updateTempDirState();
    }

    private void sshPasswordRadioButtonActionPerformed(ActionEvent evt) {
        this.sshPasswordField.requestFocusInWindow();
    }

    private void customTempDirRadioButtonActionPerformed(ActionEvent evt) {
        this.tempDirTextField.requestFocusInWindow();
    }

    private void localRadioButtonActionPerformed(ActionEvent evt) {
        this.localStorageTextField.requestFocusInWindow();
    }

    private void sshRadioButtonActionPerformed(ActionEvent evt) {
        if (!this.sshFocusHandling() && this.sshStorageTextField.isEnabled()) {
            this.sshStorageTextField.requestFocusInWindow();
        }
    }

    private void reminderButtonActionPerformed(ActionEvent evt) {
        EditReminderDialog dialog = new EditReminderDialog(this.parentFrame, this.showReminder, this.reminderTimeout);
        dialog.setVisible(true);
        if (!dialog.okSelected()) {
            return;
        }
        this.reminderTimeout = dialog.getReminderTimeout();
        boolean newShowReminder = dialog.isReminderSelected();
        if (this.showReminder != newShowReminder) {
            String packageName = JBackpack.class.getPackage().getName();
            String linuxIconFileName = USER_HOME + "/.java/.userPrefs/" + packageName.replace(".", "/") + "/jbackpack.png";
            AutoStarter autoStarter = new AutoStarter("jbackpack", "JBackpack", "JBackpack", "JBackpack", "--reminder");
            this.showReminder = newShowReminder;
            if (this.showReminder) {
                String desktopFileTemplate = "[Desktop Entry]\nType=Application\nName=JBackpack Reminder\nName[de]=JBackpack-Erinnerung\nIcon={0}\nExec={1}\n";
                autoStarter.enableAutoStart("jbackpack", "/ch/fhnw/jbackpack/icons/32x32/icon.png", linuxIconFileName, desktopFileTemplate, "jbackpack-reminder");
            } else {
                autoStarter.disableAutoStart("jbackpack", linuxIconFileName, "jbackpack-reminder");
            }
        }
        this.updateReminderTextField();
    }

    private void maxSizeCheckBoxItemStateChanged(ItemEvent evt) {
        boolean enabled = this.maxSizeCheckBox.isSelected();
        this.maxSizeTextField.setEnabled(enabled);
        this.maxSizeComboBox.setEnabled(enabled);
    }

    private void minSizeCheckBoxItemStateChanged(ItemEvent evt) {
        boolean enabled = this.minSizeCheckBox.isSelected();
        this.minSizeTextField.setEnabled(enabled);
        this.minSizeComboBox.setEnabled(enabled);
    }

    private void otherSourceRadioButtonActionPerformed(ActionEvent evt) {
        this.backupSourceTextField.requestFocusInWindow();
    }

    private void otherSourceRadioButtonItemStateChanged(ItemEvent evt) {
        this.updateSourceDirState();
    }

    private void quitButtonActionPerformed(ActionEvent evt) {
        this.savePreferences();
        System.exit(0);
    }

    private void quitButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.quitButton);
    }

    private void autoDeleteNumberSpinnerStateChanged(ChangeEvent evt) {
        int value = (Integer)this.autoDeleteNumberSpinner.getValue();
        this.autoDeleteNumberLabel.setText(BUNDLE.getString(value == 1 ? "AutoDeleteBackup" : "AutoDeleteBackups"));
    }

    private void sshRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.sshRadioButton.isSelected()) {
            this.showCard(this.destinationCardPanel, "sshStoragePanel");
            this.destinationChanged();
        }
    }

    private void smbRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.smbRadioButton.isSelected()) {
            this.showCard(this.destinationCardPanel, "smbStoragePanel");
            this.destinationChanged();
        }
    }

    private void smbServerTextFieldActionPerformed(ActionEvent evt) {
        this.smbShareTextField.requestFocusInWindow();
    }

    private void smbUserTextFieldActionPerformed(ActionEvent evt) {
        this.smbPasswordField.requestFocusInWindow();
    }

    private void smbPasswordFieldActionPerformed(ActionEvent evt) {
        switch (CurrentOperatingSystem.OS) {
            case Mac_OS_X: 
            case Windows: {
                this.smbLogin(false);
                break;
            }
            default: {
                this.smbSudoPasswordField.requestFocusInWindow();
            }
        }
    }

    private void smbLogInOutButtonActionPerformed(ActionEvent evt) {
        if (LOGIN.equals(this.smbLogInOutButton.getActionCommand())) {
            this.smbLogin(false);
        } else {
            try {
                String mountPoint = this.getSmbfsMountPoint();
                boolean umounted = false;
                switch (CurrentOperatingSystem.OS) {
                    case Linux: {
                        String sudoPassword = new String(this.smbSudoPasswordField.getPassword());
                        umounted = FileTools.umountSudo(mountPoint, sudoPassword);
                        break;
                    }
                    case Mac_OS_X: {
                        int returnValue = this.processExecutor.executeProcess("umount", mountPoint);
                        umounted = returnValue == 0;
                        break;
                    }
                    case Windows: {
                        umounted = FileTools.umountWin(mountPoint);
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
                    }
                }
                if (umounted) {
                    this.setSmbMounted(false);
                    this.destinationChanged();
                    this.smbPasswordField.requestFocusInWindow();
                } else {
                    JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Logout_Failed"), BUNDLE.getString("Error"), 0);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void smbStorageButtonActionPerformed(ActionEvent evt) {
        try {
            this.selectRemoteDirectory(this.smbServerTextField.getText(), this.smbStorageTextField, this.getSmbfsMountPoint());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void smbShareTextFieldActionPerformed(ActionEvent evt) {
        this.smbUserTextField.requestFocusInWindow();
    }

    private void smbSudoPasswordFieldActionPerformed(ActionEvent evt) {
        this.smbLogin(false);
    }

    private void smbRadioButtonActionPerformed(ActionEvent evt) {
        this.smbFocusHandling();
    }

    private String getSshPassword(String sshUserName, String sshServerName) {
        if (this.sshRadioButton.isSelected() && this.sshPasswordRadioButton.isSelected()) {
            char[] sshPassword = this.sshPasswordField.getPassword();
            if (sshPassword == null || sshPassword.length == 0) {
                SshPasswordDialog passwordDialog = new SshPasswordDialog((Window)this.parentFrame, sshUserName, sshServerName);
                passwordDialog.setVisible(true);
                if (passwordDialog.okPressed()) {
                    sshPassword = passwordDialog.getPassword();
                }
            }
            return String.valueOf(sshPassword);
        }
        return null;
    }

    private void selectRemoteDirectory(String server, JTextField directoryTextField, String mountPoint) {
        String selectedPath = directoryTextField.getText();
        try {
            selectedPath = mountPoint + (selectedPath.startsWith(File.separator) ? "" : File.separator) + selectedPath;
            File mountDir = new File(mountPoint);
            ChrootFileSystemView chrootFileSystemView = new ChrootFileSystemView(mountDir, server);
            SelectBackupDirectoryDialog dialog = new SelectBackupDirectoryDialog(this.parentFrame, chrootFileSystemView, selectedPath, false);
            if (dialog.showDialog() == 0) {
                String newPath = dialog.getSelectedPath();
                File newDir = new File(newPath).getCanonicalFile();
                newPath = newDir.getPath();
                if (FileTools.isSubDir(mountDir, newDir)) {
                    newPath = newPath.substring(mountPoint.length());
                    directoryTextField.setText(newPath);
                } else {
                    String errorMessage = BUNDLE.getString("Error_Selected_Directory_Not_On_Server");
                    errorMessage = MessageFormat.format(errorMessage, newPath, server);
                    JOptionPane.showMessageDialog(this.parentFrame, errorMessage, BUNDLE.getString("Error"), 0);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void autoDeletion(File destinationDirectory) throws IOException {
        RdiffFileDatabase rdiffFileDatabase;
        List<Increment> increments = null;
        if (this.autoDeleteNumberCheckBox.isSelected()) {
            rdiffFileDatabase = this.rdiffChooserPanel.getRdiffFileDatabase();
            increments = rdiffFileDatabase.getIncrements();
            Number autoDeleteNumber = (Number)this.autoDeleteNumberSpinner.getValue();
            int autoDeleteCount = autoDeleteNumber.intValue();
            if (increments.size() > autoDeleteCount) {
                Increment lastGoodIncrement = increments.get(autoDeleteCount - 1);
                String rdiffTimestamp = lastGoodIncrement.getRdiffTimestamp();
                this.processExecutor.executeProcess("rdiff-backup", "--force", "--remove-older-than", rdiffTimestamp, destinationDirectory.getPath());
            }
        }
        if (this.autoDeleteAgeCheckBox.isSelected()) {
            String unit;
            int age = ((Number)this.autoDeleteAgeSpinner.getValue()).intValue();
            int selectedIndex = this.autoDeleteAgeComboBox.getSelectedIndex();
            switch (selectedIndex) {
                case 0: {
                    unit = "D";
                    break;
                }
                case 1: {
                    unit = "W";
                    break;
                }
                case 2: {
                    unit = "M";
                    break;
                }
                case 3: {
                    unit = "Y";
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "unsupported age unit {0}", selectedIndex);
                    return;
                }
            }
            this.processExecutor.executeProcess("rdiff-backup", "--force", "--remove-older-than", age + unit, destinationDirectory.getPath());
        }
        if (this.autoDeletionSpaceCheckBox.isSelected()) {
            if (increments == null) {
                rdiffFileDatabase = this.rdiffChooserPanel.getRdiffFileDatabase();
                increments = rdiffFileDatabase.getIncrements();
            }
            Number sizeNumber = (Number)this.autoDeletionSpaceSpinner.getValue();
            int index = this.autoDeletionSpaceComboBox.getSelectedIndex();
            long maxSize = sizeNumber.longValue() * (long)Math.pow(1024.0, index);
            long size = 0L;
            int j = increments.size();
            for (int i = 0; i < j; ++i) {
                String rdiffTimestamp;
                Increment increment = increments.get(i);
                if ((size += increment.getSize().longValue()) <= maxSize) continue;
                boolean showMirrorWarning = false;
                if (i == 0) {
                    rdiffTimestamp = increment.getRdiffTimestamp();
                    showMirrorWarning = true;
                } else {
                    Increment youngerIncrement = increment.getYoungerIncrement();
                    rdiffTimestamp = youngerIncrement.getRdiffTimestamp();
                }
                if (showMirrorWarning && !this.shutdownCheckBox.isSelected()) {
                    String warningMessage = BUNDLE.getString("Warning_Auto_Delete_Space");
                    String sizeString = FileTools.getDataVolumeString(size, 1);
                    String maxSizeString = sizeNumber.toString() + this.autoDeletionSpaceComboBox.getSelectedItem();
                    warningMessage = MessageFormat.format(warningMessage, sizeString, maxSizeString);
                    JOptionPane.showMessageDialog(this.parentFrame, warningMessage, BUNDLE.getString("Warning"), 2);
                }
                this.processExecutor.executeProcess("rdiff-backup", "--force", "--remove-older-than", rdiffTimestamp, destinationDirectory.getPath());
                break;
            }
        }
    }

    private long getFileSize(JTextField textField, JComboBox comboBox) {
        try {
            long size = Long.parseLong(textField.getText());
            long factor = (long)Math.pow(1024.0, comboBox.getSelectedIndex());
            return size * factor;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private void updateReminderTextField() {
        if (this.showReminder) {
            double[] timeouts = new double[]{1.0, 2.0};
            String[] timeoutStrings = new String[]{BUNDLE.getString("Every_Day"), BUNDLE.getString("Every_X_Days")};
            ChoiceFormat choiceFormat = new ChoiceFormat(timeouts, timeoutStrings);
            MessageFormat messageFormat = new MessageFormat("{0}");
            messageFormat.setFormat(0, choiceFormat);
            Object[] arguments = new Object[]{this.reminderTimeout};
            this.reminderTextField.setText(messageFormat.format(arguments));
        } else {
            this.reminderTextField.setText(BUNDLE.getString("None"));
        }
    }

    private void updateSourceDirState() {
        boolean customDir = this.otherSourceRadioButton.isSelected();
        if (!customDir) {
            this.backupSourceTextField.setText(USER_HOME);
        }
        this.backupSourceTextField.setEditable(customDir);
        this.backupSourceButton.setEnabled(customDir);
    }

    private void updateTempDirState() {
        boolean customDir = this.customTempDirRadioButton.isSelected();
        if (!customDir) {
            this.tempDirTextField.setText(System.getProperty("java.io.tmpdir"));
        }
        this.tempDirTextField.setEditable(customDir);
        this.tempDirBrowseButton.setEnabled(customDir);
    }

    private void restore(RdiffFile[] selectedFiles, File restoreDestination) {
        if (!this.destinationEncrypted && this.sshfsMounted) {
            this.runRestore(selectedFiles, restoreDestination);
        } else {
            this.runRestore(selectedFiles, restoreDestination);
        }
    }

    private void runRestore(RdiffFile[] selectedFiles, File restoreDestination) {
        this.rdiffBackupRestore = new RdiffBackupRestore();
        this.processCancelled = false;
        this.shutdownCheckBox.setText(BUNDLE.getString("Shutdown_After_Restore"));
        this.progressLabel.setText(BUNDLE.getString("Restoring_Files"));
        this.filenameLabel.setText(null);
        this.progressBar.setIndeterminate(true);
        this.timeLabel.setText(" ");
        this.showCard(this, "progressPanel");
        this.cancelButton.requestFocusInWindow();
        this.currentSwingWorker = new RestoreSwingWorker(selectedFiles, new File(this.getBackupDestination()), restoreDestination);
        this.currentSwingWorker.execute();
    }

    private void encrypt() {
        NewEncfsDialog passwordDialog = new NewEncfsDialog(this.parentFrame);
        if (0 != passwordDialog.showDialog()) {
            return;
        }
        String destinationPath = this.getRawBackupDestination();
        if (destinationPath == null) {
            return;
        }
        final File destinationDirectory = new File(destinationPath);
        try {
            final File encfsDir = FileTools.createTempDirectory(ENCFS_SEARCH_STRING, null);
            String tmpEncfsMountPoint = encfsDir.getPath();
            File parentDir = destinationDirectory.getParentFile();
            final File tmpCipherDir = FileTools.createTempDirectory(parentDir, destinationDirectory.getName() + ".cipher");
            String tmpCipherPath = tmpCipherDir.getPath();
            final String password = passwordDialog.getPassword();
            File passwordScript = this.processExecutor.createScript("#!/bin/sh" + LINE_SEPARATOR + "echo \"" + password + '\"');
            String passwordScriptPath = passwordScript.getPath();
            String setupScript = "#!/bin/sh" + LINE_SEPARATOR + "echo \"\" | encfs --extpass=" + passwordScriptPath + " \"" + tmpCipherPath + "\" " + tmpEncfsMountPoint;
            this.processExecutor.executeScript(setupScript, new String[0]);
            if (!passwordScript.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", passwordScript);
            }
            if (!FileTools.isEncFS(tmpCipherPath)) {
                LOGGER.log(Level.WARNING, "failed to setup encfs in {0}", tmpCipherPath);
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Encryption_Failed"), BUNDLE.getString("Error"), 0);
                return;
            }
            final FilenameCheckSwingWorker filenameCheckSwingWorker = new FilenameCheckSwingWorker(this.parentFrame, encfsDir);
            filenameCheckSwingWorker.execute();
            new Thread(){

                public void run() {
                    try {
                        int maxFilenameLength = (Integer)filenameCheckSwingWorker.get() - 8;
                        DirectoryCheckDialog directoryCheckDialog = new DirectoryCheckDialog(BackupMainPanel.this.parentFrame);
                        ModalDialogHandler dialogHandler = new ModalDialogHandler(directoryCheckDialog);
                        directoryCheckDialog.setFilenameCheckEnabled(true, maxFilenameLength);
                        EncryptionCheckSwingWorker encryptionCheckSwingWorker = new EncryptionCheckSwingWorker(BackupMainPanel.this.parentFrame, BackupMainPanel.this, directoryCheckDialog, dialogHandler, destinationDirectory, tmpCipherDir, encfsDir, password, maxFilenameLength);
                        if (FileTools.isSpaceKnown(destinationDirectory)) {
                            long usableSpace = destinationDirectory.getUsableSpace();
                            directoryCheckDialog.setFreeSpaceKnown(true, usableSpace);
                            encryptionCheckSwingWorker.setUsableSpace(usableSpace);
                        }
                        encryptionCheckSwingWorker.execute();
                        dialogHandler.show();
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }.start();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void checkForShutdown() {
        if (this.shutdownCheckBox.isSelected()) {
            this.savePreferences();
            String password = String.valueOf(this.shutdownPasswordField.getPassword());
            String shutdownScript = "#!/bin/sh" + LINE_SEPARATOR + "echo " + password + " | sudo -S shutdown -h now";
            try {
                this.processExecutor.executeScript(shutdownScript, new String[0]);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            new Thread(){

                public void run() {
                    try {
                        58.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Shutdown_Failed"), BUNDLE.getString("Error"), 0);
                        }
                    });
                }
            }.start();
        }
    }

    private void systemCheck() {
        this.sshfsEnabled = true;
        this.encfsEnabled = true;
        switch (CurrentOperatingSystem.OS) {
            case Mac_OS_X: 
            case Linux: {
                Color background;
                JEditorPane editorPane;
                int returnValue = this.processExecutor.executeProcess("which", "expect");
                if (returnValue == 0) {
                    returnValue = this.processExecutor.executeProcess("sshfs", "--version");
                    if (returnValue != 0) {
                        editorPane = new JEditorPane("text/html", BUNDLE.getString(CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X ? "Warning_No_SSHFS_OSX" : "Warning_No_SSHFS"));
                        background = UIManager.getDefaults().getColor("Panel.background");
                        editorPane.setBackground(background);
                        JOptionPane.showMessageDialog(this.parentFrame, editorPane, BUNDLE.getString("Warning"), 2);
                        this.disableSshfs();
                        this.sshRadioButton.setToolTipText(BUNDLE.getString("Warning_No_SSHFS"));
                    }
                } else {
                    JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Warning_No_Expect"), BUNDLE.getString("Warning"), 2);
                    this.disableSshfs();
                    this.sshRadioButton.setToolTipText(BUNDLE.getString("Tooltip_No_Expect_SSH"));
                    this.changePasswordButton.setEnabled(false);
                    this.changePasswordButton.setToolTipText(BUNDLE.getString("Tooltip_No_Expect_Password"));
                }
                if ((returnValue = this.processExecutor.executeProcess("which", "encfs")) == 0) {
                    returnValue = this.processExecutor.executeProcess("rsync", "--version");
                    if (returnValue == 0) break;
                    JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Warning_No_Rsync"), BUNDLE.getString("Warning"), 2);
                    this.disableEncfs();
                    this.encryptionButton.setToolTipText(BUNDLE.getString("Warning_No_Rsync"));
                    break;
                }
                editorPane = new JEditorPane("text/html", BUNDLE.getString(CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X ? "Warning_No_ENCFS_OSX" : "Warning_No_ENCFS"));
                background = UIManager.getDefaults().getColor("Panel.background");
                editorPane.setBackground(background);
                JOptionPane.showMessageDialog(this.parentFrame, editorPane, BUNDLE.getString("Warning"), 2);
                this.disableEncfs();
                this.encryptionButton.setToolTipText(BUNDLE.getString("Warning_No_ENCFS"));
                break;
            }
            default: {
                this.disableSshfs();
                this.sshRadioButton.setToolTipText(BUNDLE.getString("Tooltip_SSHFS"));
                this.disableEncfs();
                this.encryptionButton.setToolTipText(BUNDLE.getString("Tooltip_ENCFS"));
                this.shutdownCheckBox.setEnabled(false);
                this.shutdownCheckBox.setToolTipText(BUNDLE.getString("Tooltip_Shutdown"));
            }
        }
    }

    private void disableSshfs() {
        this.sshfsEnabled = false;
        this.localRadioButton.setSelected(true);
        this.sshRadioButton.setEnabled(false);
    }

    private void disableEncfs() {
        this.encfsEnabled = false;
        this.encryptionButton.setEnabled(false);
    }

    private void lock() {
        RdiffFileDatabase rdiffFileDatabase = this.rdiffChooserPanel.getRdiffFileDatabase();
        if (rdiffFileDatabase != null) {
            rdiffFileDatabase.close();
        }
        if (FileTools.umountFUSE(new File(this.encfsMountPoint), true)) {
            this.encfsMountPoint = null;
            this.updateLockButton(false);
        }
    }

    private boolean unlock(boolean switchToBackup) {
        UnlockEncfsDialog dialog = new UnlockEncfsDialog(this.parentFrame);
        if (0 == dialog.showDialog()) {
            String password = dialog.getPassword();
            try {
                File backupDir = new File(this.getRawBackupDestination());
                File encfsMountDir = FileTools.createTempDirectory(ENCFS_SEARCH_STRING, null);
                this.encfsMountPoint = encfsMountDir.getPath();
                if (FileTools.mountEncFs(backupDir.getPath(), this.encfsMountPoint, password)) {
                    JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Destination_Unlocked"), BUNDLE.getString("Information"), 1, IconManager.INFORMATION_ICON);
                    this.checkDestinationCommon();
                    if (switchToBackup) {
                        this.mainTabbedPane.setSelectedComponent(this.backupCardPanel);
                    }
                    return true;
                }
                encfsMountDir.delete();
                this.encfsMountPoint = null;
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Unlocking_Error"), BUNDLE.getString("Error"), 0);
                return this.unlock(switchToBackup);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    private boolean checkSourceCommon(String sourcePath, File sourceDirectory) {
        if (sourcePath.length() == 0) {
            String directoriesTabName = BUNDLE.getString("BackupMainPanel.directoriesPanel.TabConstraints.tabTitle");
            this.showErrorPanels("Error_No_Source_Directory", directoriesTabName);
            return false;
        }
        if (!sourceDirectory.exists()) {
            this.showErrorPanels("Error_Source_Directory_Does_Not_Exist", new Object[0]);
            return false;
        }
        if (!sourceDirectory.isDirectory()) {
            this.showErrorPanels("Error_Source_No_Directory", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkSourceBackup(File sourceDirectory) {
        if (!sourceDirectory.canRead()) {
            this.showBackupErrorPanel(BUNDLE.getString("Error_Source_Directory_Unreadable"));
            return false;
        }
        return true;
    }

    private boolean checkSourceRestore(File sourceDirectory) {
        if (!FileTools.canWrite(sourceDirectory)) {
            this.showRestoreErrorPanel(BUNDLE.getString("Error_Source_Read-Only"));
            return false;
        }
        if (CurrentOperatingSystem.OS != OperatingSystem.Windows) {
            if (sourceDirectory.setWritable(false)) {
                sourceDirectory.setWritable(true);
            } else {
                this.showRestoreErrorPanel(BUNDLE.getString("Error_Source_Directory_Unmodifiable"));
                return false;
            }
        }
        return true;
    }

    private boolean checkDestinationBackup() {
        String destinationPath = this.getBackupDestination();
        if (destinationPath == null) {
            return false;
        }
        File destinationDirectory = new File(destinationPath);
        if (!FileTools.canWrite(destinationDirectory)) {
            this.showBackupErrorPanel(BUNDLE.getString("Error_Destination_Read-Only"));
            return false;
        }
        File rdiffBackupDataDir = new File(destinationDirectory, "rdiff-backup-data");
        if (!(!rdiffBackupDataDir.exists() || rdiffBackupDataDir.canRead() && FileTools.canWrite(rdiffBackupDataDir))) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "can not access {0}{1}rdiff-backup-data", new Object[]{destinationDirectory, Character.valueOf(File.separatorChar)});
            }
            this.showBackupErrorPanel(BUNDLE.getString("Error_Accessing_Backup"));
            return false;
        }
        return true;
    }

    private boolean checkTempDirectory() {
        String tempPath = this.tempDirTextField.getText();
        if (tempPath.isEmpty()) {
            this.showErrorPanels("Error_No_Temp_Directory", new Object[0]);
            return false;
        }
        File tempDir = new File(tempPath);
        if (!tempDir.exists()) {
            this.showErrorPanels("Error_Temp_Directory_Does_Not_Exist", new Object[0]);
            return false;
        }
        if (!tempDir.isDirectory()) {
            this.showErrorPanels("Error_Temp_No_Directory", new Object[0]);
            return false;
        }
        if (!tempDir.canRead()) {
            this.showErrorPanels("Error_Temp_Directory_Unreadable", new Object[0]);
            return false;
        }
        if (!FileTools.canWrite(tempDir)) {
            this.showErrorPanels("Error_Temp_Read-Only", new Object[0]);
            return false;
        }
        return true;
    }

    private void showErrorPanels(String errorMessageKey, Object ... arguments) {
        String errorMessage = BUNDLE.getString(errorMessageKey);
        errorMessage = MessageFormat.format(errorMessage, arguments);
        this.showBackupErrorPanel(errorMessage);
        this.showRestoreErrorPanel(errorMessage);
    }

    private void showBackupErrorPanel(String errorMessage) {
        this.backupErrorLabel.setText(errorMessage);
        this.showCard(this.backupCardPanel, "backupErrorPanel");
    }

    private void showRestoreErrorPanel(String errorMessage) {
        this.restoreErrorLabel.setText(errorMessage);
        this.showCard(this.restoreCardPanel, "restoreErrorPanel");
    }

    private void updateLockButton(boolean mounted) {
        if (mounted) {
            this.lockButton.setText(BUNDLE.getString("Lock"));
            this.lockButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/encrypted.png")));
            this.lockButton.setActionCommand(LOCK);
        } else {
            this.lockButton.setText(BUNDLE.getString("Unlock"));
            this.lockButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/password.png")));
            this.lockButton.setActionCommand(UNLOCK);
        }
    }

    private String getBackupDestination() {
        if (this.destinationEncrypted) {
            return this.encfsMountPoint;
        }
        return this.getRawBackupDestination();
    }

    private String getRawBackupDestination() {
        if (this.localRadioButton.isSelected()) {
            return this.localStorageTextField.getText();
        }
        if (this.sshRadioButton.isSelected()) {
            try {
                return this.getSshfsMountPoint() + File.separatorChar + this.sshStorageTextField.getText();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        } else if (this.smbRadioButton.isSelected()) {
            try {
                return this.getSmbfsMountPoint() + File.separatorChar + this.smbStorageTextField.getText();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private void directoriesTabFocusHandling() {
        if (this.backupSourceTextField.getText().length() == 0) {
            this.backupSourceTextField.requestFocusInWindow();
        } else if (this.localRadioButton.isSelected() && this.localStorageTextField.getText().length() == 0) {
            this.localStorageTextField.requestFocusInWindow();
        } else if (this.sshRadioButton.isSelected()) {
            if (this.sshfsMounted || !this.sshFocusHandling()) {
                if (this.sshStorageTextField.getText().length() == 0) {
                    this.sshStorageTextField.requestFocusInWindow();
                } else {
                    this.backupSourceTextField.requestFocusInWindow();
                }
            }
        } else if (this.smbRadioButton.isSelected() && (this.smbfsMounted || !this.smbFocusHandling())) {
            if (this.smbStorageTextField.getText().length() == 0) {
                this.smbStorageTextField.requestFocusInWindow();
            } else {
                this.backupSourceTextField.requestFocusInWindow();
            }
        }
    }

    private boolean sshFocusHandling() {
        if (this.sshServerTextField.getText().length() == 0) {
            this.sshServerTextField.requestFocusInWindow();
            return true;
        }
        if (this.sshUserNameTextField.getText().length() == 0) {
            this.sshUserNameTextField.requestFocusInWindow();
            return true;
        }
        if (this.sshPasswordRadioButton.isSelected() && this.sshPasswordField.getPassword().length == 0) {
            this.sshPasswordField.requestFocusInWindow();
            return true;
        }
        if (this.sshLogInOutButton.isEnabled() && LOGIN.equals(this.sshLogInOutButton.getActionCommand())) {
            this.sshLogInOutButton.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private boolean smbFocusHandling() {
        if (this.smbServerTextField.getText().length() == 0) {
            this.smbServerTextField.requestFocusInWindow();
            return true;
        }
        if (this.smbShareTextField.getText().length() == 0) {
            this.smbShareTextField.requestFocusInWindow();
            return true;
        }
        if (this.smbUserTextField.getText().length() == 0) {
            this.smbUserTextField.requestFocusInWindow();
            return true;
        }
        if (this.smbPasswordField.getPassword().length == 0) {
            this.smbPasswordField.requestFocusInWindow();
            return true;
        }
        if (this.smbSudoPasswordField.getPassword().length == 0) {
            this.smbSudoPasswordField.requestFocusInWindow();
            return true;
        }
        if (this.smbLogInOutButton.isEnabled() && LOGIN.equals(this.smbLogInOutButton.getActionCommand())) {
            this.smbLogInOutButton.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private boolean checkFUSE() {
        File devFuse;
        if (!(CurrentOperatingSystem.OS != OperatingSystem.Linux || (devFuse = new File("/dev/fuse")).canRead() && devFuse.canWrite())) {
            JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Error_Fuse"), BUNDLE.getString("Error"), 0);
            return false;
        }
        return true;
    }

    private void smbLogin(boolean switchToBackup) {
        String host = this.smbServerTextField.getText();
        if (host == null || host.isEmpty()) {
            this.showError("Error_No_Server");
            this.smbServerTextField.requestFocusInWindow();
            return;
        }
        String share = this.smbShareTextField.getText();
        if (share == null || share.isEmpty()) {
            this.showError("Error_No_Share");
            this.smbShareTextField.requestFocusInWindow();
            return;
        }
        this.smbPasswordField.setEnabled(false);
        this.smbSudoPasswordField.setEnabled(false);
        this.smbLogInOutButton.setEnabled(false);
        this.smbLoginProgressBar.setIndeterminate(true);
        SmbLoginSwingWorker smbLoginSwingWorker = new SmbLoginSwingWorker(host, share, switchToBackup);
        smbLoginSwingWorker.execute();
    }

    private void sshLogin(boolean switchToBackup) {
        if (!this.checkFUSE()) {
            return;
        }
        String host = this.sshServerTextField.getText();
        if (host == null || host.isEmpty()) {
            this.showError("Error_No_Server");
            this.sshServerTextField.requestFocusInWindow();
            return;
        }
        String user = this.sshUserNameTextField.getText();
        if (user == null || user.isEmpty()) {
            this.showError("Error_No_User");
            this.sshUserNameTextField.requestFocusInWindow();
            return;
        }
        this.sshPasswordField.setEnabled(false);
        this.sshLogInOutButton.setEnabled(false);
        this.sshLoginProgressBar.setIndeterminate(true);
        SshLoginSwingWorker sshLoginSwingWorker = new SshLoginSwingWorker(host, user, switchToBackup);
        sshLoginSwingWorker.execute();
    }

    private String getSshfsMountPoint() throws IOException {
        String user = this.sshUserNameTextField.getText();
        String server = this.sshServerTextField.getText();
        return FileTools.getMountPoint(user + '@' + server + ':');
    }

    private String getSmbfsMountPoint() throws IOException {
        String server = this.smbServerTextField.getText();
        String share = this.smbShareTextField.getText();
        String searchString = null;
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                searchString = "//" + server + '/' + share;
                break;
            }
            case Mac_OS_X: {
                searchString = "//";
                String smbUser = this.smbUserTextField.getText();
                if (smbUser != null && !smbUser.isEmpty()) {
                    searchString = searchString + smbUser + "@";
                }
                searchString = searchString + server + '/' + share;
                break;
            }
            case Windows: {
                searchString = "\\\\" + server + '\\' + share;
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
            }
        }
        return FileTools.getMountPoint(searchString);
    }

    private void setSshMounted(boolean mounted) {
        this.sshfsMounted = mounted;
        this.sshServerTextField.setEditable(!mounted);
        this.sshUserNameTextField.setEditable(!mounted);
        this.sshBaseDirTextField.setEditable(!mounted);
        this.sshPasswordRadioButton.setEnabled(!mounted);
        this.sshPasswordField.setEditable(!mounted);
        this.sshPasswordField.setEnabled(!mounted);
        this.sshPublicKeyRadioButton.setEnabled(!mounted);
        if (mounted) {
            this.sshLogInOutButton.setText(BUNDLE.getString("Logout"));
            this.sshLogInOutButton.setActionCommand(LOGOUT);
            this.sshLoginProgressBar.setString(BUNDLE.getString("Logged_In"));
        } else {
            this.sshLogInOutButton.setText(BUNDLE.getString("Login"));
            this.sshLogInOutButton.setActionCommand(LOGIN);
            this.sshLoginProgressBar.setString(BUNDLE.getString("Not_Logged_In"));
        }
        this.sshStorageLabel.setEnabled(mounted);
        this.sshStorageTextField.setEnabled(mounted);
        this.sshStorageButton.setEnabled(mounted);
    }

    private void setSmbMounted(boolean mounted) {
        this.smbfsMounted = mounted;
        this.smbServerTextField.setEditable(!mounted);
        this.smbShareTextField.setEditable(!mounted);
        this.smbUserTextField.setEditable(!mounted);
        this.smbPasswordField.setEditable(!mounted);
        this.smbPasswordField.setEnabled(!mounted);
        if (mounted) {
            this.smbLogInOutButton.setText(BUNDLE.getString("Logout"));
            this.smbLogInOutButton.setActionCommand(LOGOUT);
            this.smbLoginProgressBar.setString(BUNDLE.getString("Logged_In"));
        } else {
            this.smbLogInOutButton.setText(BUNDLE.getString("Login"));
            this.smbLogInOutButton.setActionCommand(LOGIN);
            this.smbLoginProgressBar.setString(BUNDLE.getString("Not_Logged_In"));
        }
        this.smbStorageLabel.setEnabled(mounted);
        this.smbStorageTextField.setEnabled(mounted);
        this.smbStorageButton.setEnabled(mounted);
    }

    private void showError(String messageKey) {
        this.showError(messageKey, null);
    }

    private void showError(String messageKey, JTextField textField) {
        JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString(messageKey), BUNDLE.getString("Error"), 0);
        if (textField != null) {
            this.mainTabbedPane.setSelectedComponent(this.directoriesPanel);
            textField.selectAll();
            textField.requestFocusInWindow();
        }
    }

    private void showCard(Container container, String cardName) {
        LayoutManager layoutManager = container.getLayout();
        if (layoutManager instanceof CardLayout) {
            CardLayout cardLayout = (CardLayout)layoutManager;
            cardLayout.show(container, cardName);
        }
    }

    private void addSelectedFiles(String fileChooserDialogTitle, File baseDirectory, JTextArea list) {
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    fileChooser.setFileHidingEnabled(fileChooser.getFileFilter() == NO_HIDDEN_FILES_SWING_FILE_FILTER);
                    fileChooser.rescanCurrentDirectory();
                }
            }
        });
        fileChooser.setDialogTitle(fileChooserDialogTitle);
        fileChooser.setFileSelectionMode(2);
        fileChooser.addChoosableFileFilter(NO_HIDDEN_FILES_SWING_FILE_FILTER);
        fileChooser.setFileFilter(NO_HIDDEN_FILES_SWING_FILE_FILTER);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setCurrentDirectory(baseDirectory);
        fileChooser.setApproveButtonText(BUNDLE.getString("Choose"));
        if (0 == fileChooser.showOpenDialog(this.parentFrame)) {
            File[] selectedFiles = fileChooser.getSelectedFiles();
            Document document = list.getDocument();
            for (File selectedFile : selectedFiles) {
                try {
                    int length = document.getLength();
                    if (length != 0) {
                        document.insertString(length, LINE_SEPARATOR, null);
                        length = document.getLength();
                    }
                    String path = RdiffBackupRestore.quoteBackup(baseDirectory.getPath(), selectedFile.getPath());
                    document.insertString(length, path, null);
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private String getStatisticsLine(Map<String, String> content, String mapKey, NumberFormat numberFormat, String bundlekey) {
        String rawNumberString = content.get(mapKey);
        long number = Long.parseLong(rawNumberString);
        String formattedNumberString = numberFormat.format(number);
        String line = BUNDLE.getString(bundlekey);
        return MessageFormat.format(line, formattedNumberString);
    }

    private void fillStatisticsTextField(Map<String, String> content, String timeString) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(true);
        StringBuilder stringBuilder = new StringBuilder();
        String newFilesLine = this.getStatisticsLine(content, "NewFiles", numberFormat, "New_Files");
        stringBuilder.append(newFilesLine);
        stringBuilder.append(LINE_SEPARATOR);
        String deletedFilesLine = this.getStatisticsLine(content, "DeletedFiles", numberFormat, "Deleted_Files");
        stringBuilder.append(deletedFilesLine);
        stringBuilder.append(LINE_SEPARATOR);
        String changedFilesLine = this.getStatisticsLine(content, "ChangedFiles", numberFormat, "Changed_Files");
        stringBuilder.append(changedFilesLine);
        stringBuilder.append(LINE_SEPARATOR);
        String rawChangeString = content.get("TotalDestinationSizeChange");
        long totalChange = Long.parseLong(rawChangeString);
        String formattedTotalChange = FileTools.getDataVolumeString(totalChange, 2);
        String totalChangeLine = BUNDLE.getString("Total_Changed_Size");
        totalChangeLine = MessageFormat.format(totalChangeLine, formattedTotalChange);
        stringBuilder.append(totalChangeLine);
        stringBuilder.append(LINE_SEPARATOR);
        String elapsedTimeLine = BUNDLE.getString("Elapsed_Time");
        elapsedTimeLine = MessageFormat.format(elapsedTimeLine, timeString);
        stringBuilder.append(elapsedTimeLine);
        this.statisticsTextField.setText(stringBuilder.toString());
    }

    private void documentChanged(DocumentEvent e) {
        Document document = e.getDocument();
        if (document.equals(this.tempDirTextField.getDocument())) {
            File testFile = new File(this.tempDirTextField.getText());
            FileTools.showSpaceInfo(testFile, this.storageUsageProgressBar);
        } else {
            this.destinationChanged();
        }
    }

    private void destinationChanged() {
        if (this.destinationEncrypted && this.encfsMountPoint != null) {
            this.lock();
        }
        this.checkDestinationCommon();
    }

    private class RestoreActionListener
    implements ActionListener {
        private final long start;
        private final boolean countFiles;

        public RestoreActionListener(long start, boolean countFiles) {
            this.start = start;
            this.countFiles = countFiles;
        }

        public void actionPerformed(ActionEvent e) {
            String currentFile = BackupMainPanel.this.rdiffBackupRestore.getCurrentFile();
            long restoreCounter = BackupMainPanel.this.rdiffBackupRestore.getRestoreCounter();
            RdiffBackupRestore.RestoreState restoreState = BackupMainPanel.this.rdiffBackupRestore.getRestoreState();
            if (restoreState != null) {
                switch (restoreState) {
                    case Counting: {
                        BackupMainPanel.this.progressBar.setIndeterminate(true);
                        String string = BUNDLE.getString("Counting_Files");
                        string = MessageFormat.format(string, restoreCounter);
                        BackupMainPanel.this.progressLabel.setText(string);
                        BackupMainPanel.this.filenameLabel.setText(currentFile);
                        break;
                    }
                    case Restoring: {
                        String string;
                        long fileCounter = BackupMainPanel.this.rdiffBackupRestore.getFileCounter();
                        if (fileCounter <= 0L) break;
                        if (this.countFiles) {
                            BackupMainPanel.this.progressBar.setIndeterminate(false);
                            string = BUNDLE.getString("Restoring_File_Counted");
                            string = MessageFormat.format(string, fileCounter, restoreCounter);
                            BackupMainPanel.this.progressLabel.setText(string);
                            BackupMainPanel.this.filenameLabel.setText(currentFile);
                            if (restoreCounter <= 0L) break;
                            BackupMainPanel.this.progressBar.setValue((int)(fileCounter * 100L / restoreCounter));
                            break;
                        }
                        string = BUNDLE.getString("Restoring_File_Not_Counted");
                        string = MessageFormat.format(string, fileCounter);
                        BackupMainPanel.this.progressLabel.setText(string);
                        BackupMainPanel.this.filenameLabel.setText(currentFile);
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "unsupported restoreState: {0}", (Object)restoreState);
                    }
                }
            }
            long time = System.currentTimeMillis() - this.start;
            String timeString = BackupMainPanel.this.timeFormat.format(new Date(time));
            BackupMainPanel.this.timeLabel.setText(timeString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RestoreSwingWorker
    extends SwingWorker<Boolean, Void> {
        private final long start = System.currentTimeMillis();
        private final RdiffFile[] selectedFiles;
        private final File backupDirectory;
        private final File restoreDirectory;
        private final boolean countFiles;
        private final Timer timer;

        public RestoreSwingWorker(RdiffFile[] selectedFiles, File backupDirectory, File restoreDirectory) {
            this.selectedFiles = selectedFiles;
            this.backupDirectory = backupDirectory;
            this.restoreDirectory = restoreDirectory;
            this.countFiles = BackupMainPanel.this.countFilesCheckBox.isSelected();
            this.timer = new Timer(1000, new RestoreActionListener(this.start, this.countFiles));
            this.timer.setInitialDelay(0);
            this.timer.start();
        }

        @Override
        protected Boolean doInBackground() {
            try {
                Increment increment = this.selectedFiles[0].getIncrement();
                return BackupMainPanel.this.rdiffBackupRestore.restore(increment.getRdiffTimestamp(), this.selectedFiles, this.backupDirectory, this.restoreDirectory, BackupMainPanel.this.tempDirTextField.getText(), this.countFiles);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "restore failed", exception);
                return false;
            }
        }

        @Override
        protected void done() {
            this.timer.stop();
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    BackupMainPanel.this.checkForShutdown();
                    long time = System.currentTimeMillis() - this.start;
                    String timeString = BackupMainPanel.this.timeFormat.format(new Date(time));
                    String text = BUNDLE.getString("Restoring_Successfull");
                    text = MessageFormat.format(text, timeString);
                    BackupMainPanel.this.restoredLabel.setText(text);
                    BackupMainPanel.this.showCard(BackupMainPanel.this, "backupRestoredPanel");
                    BackupMainPanel.this.restoredOKButton.requestFocusInWindow();
                } else {
                    if (BackupMainPanel.this.processCancelled) {
                        LOGGER.warning("restore operation was cancelled");
                    } else {
                        String errorMessage = BackupMainPanel.this.rdiffBackupRestore.getStdErr();
                        ErrorDialog dialog = new ErrorDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Error_Rdiffbackup_Failed"), errorMessage);
                        dialog.setVisible(true);
                    }
                    BackupMainPanel.this.showCard(BackupMainPanel.this, "mainTabbedPane");
                }
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private class BackupActionListener
    implements ActionListener {
        private final long start;

        public BackupActionListener(long start) {
            this.start = start;
        }

        public void actionPerformed(ActionEvent e) {
            long fileCounter = BackupMainPanel.this.rdiffBackupRestore.getFileCounter();
            if (fileCounter > 0L) {
                String string = BUNDLE.getString("Backing_Up_File");
                string = MessageFormat.format(string, fileCounter);
                BackupMainPanel.this.progressLabel.setText(string);
                String currentFile = BackupMainPanel.this.rdiffBackupRestore.getCurrentFile();
                BackupMainPanel.this.filenameLabel.setText(currentFile);
            }
            long time = System.currentTimeMillis() - this.start;
            String timeString = BackupMainPanel.this.timeFormat.format(new Date(time));
            BackupMainPanel.this.timeLabel.setText(timeString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackupSwingWorker
    extends SwingWorker<Boolean, Void> {
        private final long start;
        private final File sourceDirectory;
        private final File destinationDirectory;
        private final String destinationPath;
        private final Long maxFileSize;
        private final Long minFileSize;
        private final Timer backupTimer;
        private final boolean directSSH;
        private final String sshPassword;

        public BackupSwingWorker(String sourcePath, String destinationPath, Long maxFileSize, Long minFileSize, boolean directSSH, String sshPassword) {
            this.sourceDirectory = new File(sourcePath);
            this.destinationDirectory = new File(destinationPath);
            this.destinationPath = destinationPath;
            this.maxFileSize = maxFileSize;
            this.minFileSize = minFileSize;
            this.directSSH = directSSH;
            this.sshPassword = sshPassword;
            this.start = System.currentTimeMillis();
            this.backupTimer = new Timer(1000, new BackupActionListener(this.start));
            this.backupTimer.setInitialDelay(0);
            this.backupTimer.start();
        }

        @Override
        protected Boolean doInBackground() {
            try {
                return this.runJob();
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "backup failed", exception);
                return false;
            }
        }

        @Override
        protected void done() {
            block9: {
                this.backupTimer.stop();
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        long now = System.currentTimeMillis();
                        BackupMainPanel.this.preferences.putLong("last_backup", now);
                        try {
                            LOGGER.log(Level.INFO, "flushing preferences");
                            BackupMainPanel.this.preferences.flush();
                        }
                        catch (BackingStoreException ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                        BackupMainPanel.this.autoDeletion(this.destinationDirectory);
                        BackupMainPanel.this.checkForShutdown();
                        long time = now - this.start;
                        String timeString = BackupMainPanel.this.timeFormat.format(new Date(time));
                        Map<String, String> backupSessionStatistics = BackupMainPanel.this.rdiffBackupRestore.getBackupSessionStatistics(this.destinationPath);
                        BackupMainPanel.this.fillStatisticsTextField(backupSessionStatistics, timeString);
                        BackupMainPanel.this.showCard(BackupMainPanel.this, "sessionStatisticsPanel");
                        BackupMainPanel.this.quitButton.requestFocusInWindow();
                        break block9;
                    }
                    if (!BackupMainPanel.this.processCancelled) {
                        String errorMessage = BackupMainPanel.this.rdiffBackupRestore.getStdErr();
                        ErrorDialog dialog = new ErrorDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Error_Rdiffbackup_Failed"), errorMessage);
                        dialog.setVisible(true);
                    }
                    BackupMainPanel.this.showCard(BackupMainPanel.this, "mainTabbedPane");
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                catch (CancellationException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }

        private Boolean runJob() throws IOException {
            boolean include;
            boolean exclude = BackupMainPanel.this.excludeCheckBox.isSelected();
            String excludes = exclude ? BackupMainPanel.this.excludesTextArea.getText() : "";
            String subDirCheckPath = null;
            if (BackupMainPanel.this.localRadioButton.isSelected()) {
                subDirCheckPath = this.destinationPath;
            } else if (BackupMainPanel.this.sshRadioButton.isSelected()) {
                subDirCheckPath = BackupMainPanel.this.getSshfsMountPoint();
            } else if (BackupMainPanel.this.smbRadioButton.isSelected()) {
                subDirCheckPath = BackupMainPanel.this.getSmbfsMountPoint();
            }
            File subDirCheckFile = new File(subDirCheckPath);
            if (FileTools.isSubDir(this.sourceDirectory, subDirCheckFile)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "{0} is a subdirectory of {1}, adding {0} to exclusions", new Object[]{subDirCheckFile, this.sourceDirectory});
                }
                excludes = excludes == null || excludes.isEmpty() ? subDirCheckPath : excludes + LINE_SEPARATOR + subDirCheckPath;
            }
            boolean bl = include = exclude && BackupMainPanel.this.includesCheckBox.isSelected();
            if (this.directSSH) {
                String sshStorage = BackupMainPanel.this.sshStorageTextField.getText();
                while (sshStorage.startsWith(File.separator)) {
                    sshStorage = sshStorage.substring(File.separator.length());
                }
                String sshBaseDirectory = BackupMainPanel.this.sshBaseDirTextField.getText();
                if (!sshBaseDirectory.isEmpty()) {
                    sshStorage = sshBaseDirectory + '/' + BackupMainPanel.this.sshStorageTextField.getText();
                }
                return BackupMainPanel.this.rdiffBackupRestore.backupViaSSH(this.sourceDirectory, BackupMainPanel.this.sshUserNameTextField.getText(), BackupMainPanel.this.sshServerTextField.getText(), sshStorage, this.sshPassword, BackupMainPanel.this.tempDirTextField.getText(), excludes, include ? BackupMainPanel.this.includesTextArea.getText() : "", BackupMainPanel.this.compressionCheckBox.isSelected(), this.maxFileSize, this.minFileSize, exclude && BackupMainPanel.this.excludeDeviceFilesCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeFifosCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeOtherFileSystemsCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeSocketsCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeSymlinksCheckBox.isSelected());
            }
            return BackupMainPanel.this.rdiffBackupRestore.backupViaFileSystem(this.sourceDirectory, this.destinationDirectory, BackupMainPanel.this.tempDirTextField.getText(), excludes, include ? BackupMainPanel.this.includesTextArea.getText() : "", BackupMainPanel.this.compressionCheckBox.isSelected(), this.maxFileSize, this.minFileSize, exclude && BackupMainPanel.this.excludeDeviceFilesCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeFifosCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeOtherFileSystemsCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeSocketsCheckBox.isSelected(), exclude && BackupMainPanel.this.excludeSymlinksCheckBox.isSelected());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SmbLoginSwingWorker
    extends SwingWorker<Boolean, Void> {
        private final String host;
        private final String share;
        private final boolean switchToBackup;

        public SmbLoginSwingWorker(String host, String share, boolean switchToBackup) {
            this.host = host;
            this.share = share;
            this.switchToBackup = switchToBackup;
        }

        @Override
        protected Boolean doInBackground() {
            String user = BackupMainPanel.this.smbUserTextField.getText();
            String smbPassword = new String(BackupMainPanel.this.smbPasswordField.getPassword());
            int returnValue = -1;
            try {
                switch (CurrentOperatingSystem.OS) {
                    case Linux: {
                        String sudoPassword = new String(BackupMainPanel.this.smbSudoPasswordField.getPassword());
                        returnValue = FileTools.mountSmbLinux(this.host, this.share, user, smbPassword, sudoPassword);
                        break;
                    }
                    case Mac_OS_X: {
                        returnValue = FileTools.mountSmbMacOSX(this.host, this.share, user, smbPassword);
                        break;
                    }
                    case Windows: {
                        returnValue = FileTools.mountSmbWindows(this.host, this.share, user, smbPassword);
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "SMB login failed", exception);
            }
            return returnValue == 0;
        }

        @Override
        protected void done() {
            BackupMainPanel.this.smbLogInOutButton.setEnabled(true);
            BackupMainPanel.this.smbLoginProgressBar.setIndeterminate(false);
            boolean success = false;
            try {
                success = (Boolean)this.get();
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            if (success) {
                BackupMainPanel.this.setSmbMounted(true);
                BackupMainPanel.this.destinationChanged();
                if (BackupMainPanel.this.destinationEncrypted && BackupMainPanel.this.encfsMountPoint == null && !BackupMainPanel.this.unlock(this.switchToBackup)) {
                    return;
                }
                if (this.switchToBackup && BackupMainPanel.this.commonDestinationOK && BackupMainPanel.this.checkDestinationBackup()) {
                    BackupMainPanel.this.mainTabbedPane.setSelectedComponent(BackupMainPanel.this.backupCardPanel);
                }
            } else {
                BackupMainPanel.this.smbPasswordField.setEnabled(true);
                String errorMessage = BackupMainPanel.this.processExecutor.getOutput();
                if (errorMessage != null && errorMessage.length() > 0) {
                    ErrorDialog dialog = new ErrorDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Error_Login_Failed"), errorMessage);
                    dialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Login_Failed"), BUNDLE.getString("Error"), 0);
                }
            }
            BackupMainPanel.this.smbSudoPasswordField.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SshLoginSwingWorker
    extends SwingWorker<Boolean, Void> {
        private final String host;
        private final String user;
        private final boolean switchToBackup;

        public SshLoginSwingWorker(String host, String user, boolean switchToBackup) {
            this.host = host;
            this.user = user;
            this.switchToBackup = switchToBackup;
        }

        @Override
        protected Boolean doInBackground() {
            try {
                String mountPoint = FileTools.createMountPoint(new File(USER_HOME), this.host).getPath();
                String userHostDir = this.user + '@' + this.host + ':';
                String baseDir = BackupMainPanel.this.sshBaseDirTextField.getText();
                if (!baseDir.isEmpty()) {
                    if (!baseDir.startsWith("/")) {
                        userHostDir = userHostDir + '/';
                    }
                    userHostDir = userHostDir + baseDir;
                }
                if (BackupMainPanel.this.sshPublicKeyRadioButton.isSelected()) {
                    int returnValue = BackupMainPanel.this.processExecutor.executeProcess(true, true, "sshfs", "-o", "ServerAliveInterval=15", "-o", "workaround=rename,idmap=user", userHostDir, mountPoint);
                    return returnValue == 0;
                }
                String password = new String(BackupMainPanel.this.sshPasswordField.getPassword());
                String loginScript = "#!/usr/bin/expect -f" + LINE_SEPARATOR + "set password [lindex $argv 0]" + LINE_SEPARATOR + "spawn -ignore HUP sshfs -o " + "workaround=rename,idmap=user " + userHostDir + " " + mountPoint + LINE_SEPARATOR + "while 1 {" + LINE_SEPARATOR + "    expect {" + LINE_SEPARATOR + "        eof {" + LINE_SEPARATOR + "            break" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"continue connecting*\" {" + LINE_SEPARATOR + "            send \"yes\r\"" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"password:\" {" + LINE_SEPARATOR + "            send \"$password\r\"" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "    }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "set ret [lindex [wait] 3]" + LINE_SEPARATOR + "puts \"return value: $ret\"" + LINE_SEPARATOR + "exit $ret";
                Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
                Level level = logger.getLevel();
                logger.setLevel(Level.OFF);
                int returnValue = BackupMainPanel.this.processExecutor.executeScript(loginScript, password);
                logger.setLevel(level);
                return returnValue == 0;
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "SSH login failed", exception);
                return false;
            }
        }

        @Override
        protected void done() {
            BackupMainPanel.this.sshLogInOutButton.setEnabled(true);
            BackupMainPanel.this.sshLoginProgressBar.setIndeterminate(false);
            boolean success = false;
            try {
                success = (Boolean)this.get();
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            if (success) {
                BackupMainPanel.this.setSshMounted(true);
                BackupMainPanel.this.destinationChanged();
                if (BackupMainPanel.this.destinationEncrypted && BackupMainPanel.this.encfsMountPoint == null && !BackupMainPanel.this.unlock(this.switchToBackup)) {
                    return;
                }
                if (this.switchToBackup && BackupMainPanel.this.commonDestinationOK && BackupMainPanel.this.checkDestinationBackup()) {
                    BackupMainPanel.this.mainTabbedPane.setSelectedComponent(BackupMainPanel.this.backupCardPanel);
                }
            } else {
                BackupMainPanel.this.sshPasswordField.setEnabled(true);
                String errorMessage = BackupMainPanel.this.processExecutor.getOutput();
                if (errorMessage != null && errorMessage.length() > 0) {
                    ErrorDialog dialog = new ErrorDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Error_Login_Failed"), errorMessage);
                    dialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(BackupMainPanel.this.parentFrame, BUNDLE.getString("Login_Failed"), BUNDLE.getString("Error"), 0);
                }
            }
        }
    }
}

