/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.PasswordEscaper;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ChangePasswordDialog
extends JDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private int selectedOption = 2;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel infoLabel;
    private JButton okButton;
    private JPasswordField oldPasswordField;
    private JLabel oldPasswordLabel;
    private JPasswordField passwordField1;
    private JPasswordField passwordField2;
    private JLabel passwordLabel1;
    private JLabel passwordLabel2;

    public ChangePasswordDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.selectedOption;
    }

    public String getOldPassword() {
        return PasswordEscaper.escapePassword(this.oldPasswordField.getPassword());
    }

    public String getNewPassword() {
        return PasswordEscaper.escapePassword(this.passwordField1.getPassword());
    }

    private void initComponents() {
        this.oldPasswordLabel = new JLabel();
        this.oldPasswordField = new JPasswordField();
        this.passwordLabel1 = new JLabel();
        this.passwordField1 = new JPasswordField();
        this.passwordLabel2 = new JLabel();
        this.passwordField2 = new JPasswordField();
        this.infoLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("ChangePasswordDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.oldPasswordLabel.setText(bundle.getString("ChangePasswordDialog.oldPasswordLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.oldPasswordLabel, gridBagConstraints);
        this.oldPasswordField.setName("oldPasswordField");
        this.oldPasswordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.oldPasswordFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.oldPasswordField, gridBagConstraints);
        this.passwordLabel1.setText(bundle.getString("ChangePasswordDialog.passwordLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.passwordLabel1, gridBagConstraints);
        this.passwordField1.setName("passwordField1");
        this.passwordField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.passwordField1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.passwordField1, gridBagConstraints);
        this.passwordLabel2.setText(bundle.getString("ChangePasswordDialog.passwordLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.passwordLabel2, gridBagConstraints);
        this.passwordField2.setName("passwordField2");
        this.passwordField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.passwordField2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.passwordField2, gridBagConstraints);
        this.infoLabel.setText(bundle.getString("ChangePasswordDialog.infoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.infoLabel, gridBagConstraints);
        this.okButton.setText(bundle.getString("ChangePasswordDialog.okButton.text"));
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText(bundle.getString("ChangePasswordDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.checkInput();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedOption = 2;
        this.dispose();
    }

    private void passwordField1ActionPerformed(ActionEvent evt) {
        this.passwordField2.requestFocusInWindow();
    }

    private void passwordField2ActionPerformed(ActionEvent evt) {
        this.checkInput();
    }

    private void oldPasswordFieldActionPerformed(ActionEvent evt) {
        this.passwordField1.requestFocusInWindow();
    }

    private void checkInput() {
        char[] oldPassword = this.oldPasswordField.getPassword();
        if (oldPassword.length == 0) {
            JOptionPane.showMessageDialog(this, BUNDLE.getString("Error_No_Old_Password"), BUNDLE.getString("Error"), 0);
            this.oldPasswordField.requestFocusInWindow();
            return;
        }
        char[] password1 = this.passwordField1.getPassword();
        if (password1.length == 0) {
            JOptionPane.showMessageDialog(this, BUNDLE.getString("Error_No_New_Password"), BUNDLE.getString("Error"), 0);
            this.retry();
            return;
        }
        char[] password2 = this.passwordField2.getPassword();
        if (Arrays.equals(password1, password2)) {
            this.selectedOption = 0;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, BUNDLE.getString("New_Passwords_Mismatch"), BUNDLE.getString("Error"), 0);
            this.retry();
        }
    }

    private void retry() {
        this.passwordField1.setText(null);
        this.passwordField2.setText(null);
        this.passwordField1.requestFocusInWindow();
    }
}

