/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.DecryptionSwingWorker;
import ch.fhnw.jbackpack.DirectoryCheckDialog;
import ch.fhnw.util.DirSizeCalculator;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptionCheckSwingWorker
extends SwingWorker<Boolean, Void> {
    private static final Logger LOGGER = Logger.getLogger(DecryptionCheckSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final BackupMainPanel backupMainPanel;
    private final File encfsCipherDir;
    private final File encfsPlainDir;
    private final DirectoryCheckDialog dirCheckDialog;
    private final ModalDialogHandler dialogHandler;
    private final DirSizeCalculator dirSizeCalculator = new DirSizeCalculator();
    private long size;
    private boolean enoughSpaceAvailable;
    private boolean spaceKnown;
    private long usableSpace;

    public DecryptionCheckSwingWorker(Frame parentFrame, BackupMainPanel backupMainPanel, DirectoryCheckDialog dirCheckDialog, ModalDialogHandler dialogHandler, File encfsCipherDir, File encfsPlainDir) {
        this.parentFrame = parentFrame;
        this.backupMainPanel = backupMainPanel;
        this.dirCheckDialog = dirCheckDialog;
        this.dialogHandler = dialogHandler;
        this.encfsCipherDir = encfsCipherDir;
        this.encfsPlainDir = encfsPlainDir;
    }

    public void setUsableSpace(long usableSpace) {
        this.spaceKnown = true;
        this.usableSpace = usableSpace * 95L / 100L;
    }

    @Override
    protected Boolean doInBackground() {
        Thread calculatorThread = new Thread(){

            public void run() {
                try {
                    DecryptionCheckSwingWorker.this.dirSizeCalculator.calculateSize(DecryptionCheckSwingWorker.this.encfsPlainDir);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        };
        calculatorThread.start();
        this.enoughSpaceAvailable = true;
        while (calculatorThread.isAlive()) {
            if (!this.checkSize(this.dirSizeCalculator)) {
                this.enoughSpaceAvailable = false;
                break;
            }
            try {
                calculatorThread.join(300L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        if (!this.checkSize(this.dirSizeCalculator)) {
            this.enoughSpaceAvailable = false;
        }
        return this.enoughSpaceAvailable;
    }

    @Override
    protected void process(List<Void> chunks) {
        this.dirCheckDialog.setFileCount(this.dirSizeCalculator.getFileCounter());
        this.dirCheckDialog.setCurrentFile(this.dirSizeCalculator.getCurrentFile().getPath());
        this.dirCheckDialog.setCurrentSize(this.size);
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        if (this.spaceKnown) {
            if (!this.enoughSpaceAvailable) {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Error_No_Space_For_Decryption"), BUNDLE.getString("Error"), 0);
                return;
            }
        } else {
            String message = BUNDLE.getString("Warning_Unknown_Space");
            String sizeString = FileTools.getDataVolumeString(this.size, 1);
            int returnValue = JOptionPane.showOptionDialog(this.parentFrame, message = MessageFormat.format(message, sizeString), BUNDLE.getString("Warning"), 2, 2, null, null, null);
            if (returnValue != 0) {
                return;
            }
        }
        DecryptionSwingWorker decryptionSwingWorker = new DecryptionSwingWorker(this.parentFrame, this.backupMainPanel, this.encfsCipherDir, this.encfsPlainDir);
        decryptionSwingWorker.execute();
    }

    private boolean checkSize(DirSizeCalculator dirSizeCalculator) {
        this.size = dirSizeCalculator.getCurrentSize();
        if (!this.spaceKnown || this.size < this.usableSpace) {
            this.publish(new Void[0]);
            return true;
        }
        dirSizeCalculator.stop();
        return false;
    }

    public long getSize() {
        return this.size;
    }
}

