/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionCleanupSwingWorker
extends SwingWorker<Void, Void> {
    private static final Logger LOGGER = Logger.getLogger(EncryptionCleanupSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final File encfsPlainDir;
    private final String encfsCipherPath;
    private final boolean cancelled;
    private final ModalDialogHandler dialogHandler;
    private final ProcessExecutor processExecutor;

    public EncryptionCleanupSwingWorker(Frame parentFrame, String encfsCipherPath, File encfsPlainDir, boolean cancelled) {
        this.parentFrame = parentFrame;
        this.encfsCipherPath = encfsCipherPath;
        this.encfsPlainDir = encfsPlainDir;
        this.cancelled = cancelled;
        this.processExecutor = new ProcessExecutor();
        ProgressDialog progressDialog = new ProgressDialog((Window)parentFrame, this.processExecutor);
        progressDialog.setIcon(IconManager.INFORMATION_ICON);
        progressDialog.setMessage(BUNDLE.getString("Deleting_Already_Encrypted_Files"));
        progressDialog.setSpecialIcon(null);
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelButtonVisible(false);
        this.dialogHandler = new ModalDialogHandler(progressDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Void doInBackground() {
        int returnValue = this.processExecutor.executeProcess("rm", "-rf", this.encfsCipherPath);
        if (returnValue != 0) {
            LOGGER.log(Level.WARNING, "could not remove {0}", this.encfsCipherPath);
        }
        FileTools.deleteIfEmpty(this.encfsPlainDir);
        return null;
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        if (!this.cancelled) {
            JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Encryption_Failed"), BUNDLE.getString("Error"), 0);
        }
    }
}

