/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.JSqueezedLabel;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class RsyncCopyDialog
extends JDialog
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(RsyncCopyDialog.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final Pattern overallProgressPattern = Pattern.compile(".*to-check=(.*)/(.*)\\)");
    private static final Pattern fileProgressPattern = Pattern.compile(".* (.*)% .*/s .*:.*:.*");
    private final ProcessExecutor processExecutor;
    private int overallProgress;
    private long fileCounter;
    private String currentFileName;
    private int fileProgress;
    private boolean cancelPressed;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel fileCountLabel;
    private JLabel fileLabel;
    private JProgressBar fileProgressBar;
    private JProgressBar overallProgressBar;
    private JLabel overallProgressLabel;
    private JLabel titleLabel;

    public RsyncCopyDialog(Frame parent, String titleText, Icon titleIcon, ProcessExecutor processExecutor) {
        super(parent, true);
        this.processExecutor = processExecutor;
        this.initComponents();
        this.titleLabel.setText(titleText);
        this.titleLabel.setIcon(titleIcon);
        this.setLocationRelativeTo(parent);
        this.setFileCount(0L);
        this.setCurrentFile(" ");
        Timer statusUpdateTimer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RsyncCopyDialog.this.setOverallProgress(RsyncCopyDialog.this.overallProgress);
                RsyncCopyDialog.this.setFileCount(RsyncCopyDialog.this.fileCounter);
                RsyncCopyDialog.this.setCurrentFile(RsyncCopyDialog.this.currentFileName);
                RsyncCopyDialog.this.setFileProgress(RsyncCopyDialog.this.fileProgress);
            }
        });
        statusUpdateTimer.setInitialDelay(0);
        statusUpdateTimer.start();
    }

    public void setOverallProgress(int progress) {
        this.overallProgressBar.setValue(progress);
        this.overallProgressBar.setString(progress + "%");
    }

    public final void setFileCount(long fileCount) {
        String text = BUNDLE.getString("Copying_File");
        text = MessageFormat.format(text, fileCount);
        this.fileCountLabel.setText(text);
    }

    public final void setCurrentFile(String currentFile) {
        this.fileLabel.setText(currentFile);
    }

    public void setFileProgress(int progress) {
        this.fileProgressBar.setValue(progress);
        this.fileProgressBar.setString(progress + "%");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("line".equals(propertyName)) {
            String line = (String)evt.getNewValue();
            if (line.length() == 0) {
                return;
            }
            if (line.startsWith("sent ")) {
                return;
            }
            if (line.startsWith("total size is ")) {
                return;
            }
            if (line.startsWith("rsync error: received ")) {
                return;
            }
            Matcher matcher = overallProgressPattern.matcher(line);
            try {
                if (matcher.matches()) {
                    String toCheckString = matcher.group(1);
                    String fileCountString = matcher.group(2);
                    int filesToCheck = Integer.parseInt(toCheckString);
                    int fileCount = Integer.parseInt(fileCountString);
                    this.overallProgress = (fileCount - filesToCheck) * 100 / fileCount;
                } else {
                    matcher = fileProgressPattern.matcher(line);
                    if (matcher.matches()) {
                        String progressString = matcher.group(1);
                        this.fileProgress = Integer.parseInt(progressString);
                    } else {
                        ++this.fileCounter;
                        this.currentFileName = line;
                    }
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.WARNING, "could not parse rsync output", ex);
            }
        }
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.overallProgressLabel = new JLabel();
        this.overallProgressBar = new JProgressBar();
        this.fileCountLabel = new JLabel();
        this.fileLabel = new JSqueezedLabel();
        this.fileProgressBar = new JProgressBar();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("RsyncCopyDialog.title"));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/encryption_animation.gif")));
        this.titleLabel.setText(bundle.getString("Encrypting_Destination_Directory"));
        this.titleLabel.setHorizontalTextPosition(0);
        this.titleLabel.setVerticalTextPosition(1);
        this.overallProgressLabel.setText(bundle.getString("RsyncCopyDialog.overallProgressLabel.text"));
        this.overallProgressBar.setStringPainted(true);
        this.fileCountLabel.setText(bundle.getString("Copying_File"));
        this.fileLabel.setFont(this.fileLabel.getFont().deriveFont(this.fileLabel.getFont().getStyle() & 0xFFFFFFFE, this.fileLabel.getFont().getSize() - 1));
        this.fileLabel.setText(bundle.getString("RsyncCopyDialog.fileLabel.text"));
        this.fileProgressBar.setStringPainted(true);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.cancelButton.setText(bundle.getString("RsyncCopyDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RsyncCopyDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel, -1, 401, Short.MAX_VALUE).addComponent(this.overallProgressLabel).addComponent(this.overallProgressBar, -1, 401, Short.MAX_VALUE).addComponent(this.fileCountLabel).addComponent(this.fileProgressBar, -1, 401, Short.MAX_VALUE).addComponent(this.buttonPanel, GroupLayout.Alignment.TRAILING, -1, 401, Short.MAX_VALUE).addComponent(this.fileLabel, -1, 401, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addGap(18, 18, 18).addComponent(this.overallProgressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overallProgressBar, -2, -1, -2).addGap(18, 18, 18).addComponent(this.fileCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileProgressBar, -2, -1, -2).addGap(18, 18, 18).addComponent(this.buttonPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelPressed = true;
        this.processExecutor.destroy();
        this.cancelButton.setEnabled(false);
    }
}

