/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.Increment;
import ch.fhnw.jbackpack.chooser.NoHiddenFilesFileFilter;
import ch.fhnw.jbackpack.chooser.RdiffFile;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class RdiffFileSystemView
extends FileSystemView {
    private static final Logger LOGGER = Logger.getLogger(RdiffFileSystemView.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DOT_SUFFIX = File.separatorChar + ".";
    private static final String DOTDOT_SUFFIX = File.separatorChar + "..";
    private final File[] roots = new File[1];
    private RdiffFile root;

    public void setRoot(RdiffFile root) {
        this.root = root;
        this.roots[0] = root;
    }

    public File createFileObject(File dir, String filename) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "dir: \"{0}\" filename: \"{1}\"", new Object[]{dir, filename});
        }
        File fileObject = null;
        try {
            if (".".equals(filename)) {
                if (dir instanceof RdiffFile) {
                    if (dir.getName().equals(".")) {
                        fileObject = dir;
                    } else {
                        if (dir.getName().equals("..")) {
                            dir = dir.getCanonicalFile();
                        }
                        RdiffFile rdiffFile = (RdiffFile)dir;
                        fileObject = rdiffFile.getDotDirectory();
                    }
                } else {
                    fileObject = dir;
                }
            } else if ("..".equals(filename)) {
                if (dir instanceof RdiffFile) {
                    RdiffFile rdiffFile = (RdiffFile)dir;
                    fileObject = rdiffFile.getDotDotDirectory();
                } else if (dir != null) {
                    fileObject = dir.getParentFile();
                }
            } else {
                String fullPath = (dir == null ? "" : dir.getPath()) + File.separatorChar + filename;
                fileObject = this.root.getChild(fullPath);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "returning \"{0}\"", fileObject == null ? null : fileObject.getAbsolutePath());
        }
        return fileObject;
    }

    public File createFileObject(String path) {
        LOGGER.log(Level.FINE, "path: \"{0}\"", path);
        RdiffFile fileObject = null;
        try {
            if (path.endsWith(DOT_SUFFIX)) {
                String canonicalPath = RdiffFile.canonicalize(path);
                RdiffFile directory = this.root.getChild(canonicalPath);
                if (directory != null) {
                    fileObject = directory.getDotDirectory();
                }
            } else if (path.endsWith(DOTDOT_SUFFIX)) {
                int previousSeparatorIndex = path.lastIndexOf(File.separatorChar, path.length() - DOTDOT_SUFFIX.length() - 1);
                String childPath = previousSeparatorIndex < 1 ? "/" : path.substring(0, previousSeparatorIndex);
                RdiffFile directory = this.root.getChild(childPath);
                fileObject = directory.getDotDotDirectory();
            } else {
                fileObject = this.root.getChild(path);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "returning \"{0}\"", fileObject == null ? null : ((File)fileObject).getAbsolutePath());
        }
        return fileObject;
    }

    protected File createFileSystemRoot(File f) {
        LOGGER.log(Level.INFO, "createFileSystemRoot({0}): returning root", f);
        return this.root;
    }

    public File createNewFolder(File containingDir) throws IOException {
        throw new UnsupportedOperationException("Can not create folders in rdiff file system views");
    }

    public File getChild(File parent, String fileName) {
        File child = null;
        File[] children = this.getFiles(parent, false);
        for (int i = 0; i < children.length; ++i) {
            File tmpChild = children[i];
            if (!tmpChild.getName().equals(fileName)) continue;
            child = tmpChild;
            break;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "getChild({0},{1}): returning {2}", new Object[]{parent, fileName, child});
        }
        return child;
    }

    public File getDefaultDirectory() {
        LOGGER.log(Level.FINEST, "returning root");
        return this.root;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        File[] files;
        File[] fileArray = files = useFileHiding ? dir.listFiles(NoHiddenFilesFileFilter.getInstance()) : dir.listFiles();
        if (LOGGER.isLoggable(Level.FINEST)) {
            String fileList = RdiffFileSystemView.fileArrayToString(files, "\t");
            LOGGER.log(Level.FINEST, "getFiles({0},{1}): returning {2}{3}", new Object[]{dir, useFileHiding, LINE_SEPARATOR, fileList});
        }
        return files;
    }

    public File getHomeDirectory() {
        LOGGER.log(Level.FINEST, "returning root");
        return this.root;
    }

    public File getParentDirectory(File dir) {
        if (dir == null) {
            LOGGER.log(Level.INFO, "directory is null -> returning null");
            return null;
        }
        File parentDirectory = dir.getParentFile();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "returning {0} as parent directory of {1}", new Object[]{parentDirectory, dir});
        }
        return parentDirectory;
    }

    public File[] getRoots() {
        LOGGER.log(Level.FINEST, "returning roots");
        return this.roots;
    }

    public String getSystemDisplayName(File f) {
        String name = f.getName();
        if (name.length() == 0 && f instanceof RdiffFile) {
            name = RdiffFileSystemView.getRootName((RdiffFile)f);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "returning \"{0}\" as system display name for file \"{1}\"", new Object[]{name, f});
        }
        return name;
    }

    public Icon getSystemIcon(File f) {
        return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
    }

    public String getSystemTypeDescription(File f) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "returning \"null\" as system type description for file \"{0}\"", f);
        }
        return null;
    }

    public boolean isComputerNode(File dir) {
        LOGGER.log(Level.FINEST, "{0} is no computer node", dir);
        return false;
    }

    public boolean isDrive(File dir) {
        boolean isDrive;
        boolean bl = isDrive = dir.getParentFile() == null;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0} is{1} drive", new Object[]{dir, isDrive ? " a" : " no"});
        }
        return isDrive;
    }

    public boolean isFileSystem(File f) {
        LOGGER.log(Level.FINEST, "{0} is a real file or directory", f);
        return true;
    }

    public boolean isFileSystemRoot(File dir) {
        boolean isFileSystemRoot;
        boolean bl = isFileSystemRoot = dir == this.root;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0} is{1} a file system root", new Object[]{dir, isFileSystemRoot ? "" : " NOT"});
        }
        return isFileSystemRoot;
    }

    public boolean isFloppyDrive(File dir) {
        LOGGER.log(Level.FINEST, "{0} is no floppy drive", dir);
        return false;
    }

    public boolean isHiddenFile(File f) {
        LOGGER.log(Level.INFO, "{0} is not hidden", f);
        return false;
    }

    public boolean isParent(File folder, File file) {
        boolean isParent = false;
        if (folder != null && file != null) {
            File parentFile;
            String folderPath = folder.getAbsolutePath();
            isParent = "/".equals(folderPath) ? (parentFile = file.getParentFile()) == null || folder.equals(parentFile) : folder.equals(file.getParentFile());
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0} is{1} the parent of {2}", new Object[]{folder, isParent ? "" : " NOT", file});
        }
        return isParent;
    }

    public boolean isRoot(File f) {
        boolean isRoot = super.isRoot(f);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0} is{1} root", new Object[]{f, isRoot ? "" : " NOT"});
        }
        return isRoot;
    }

    public Boolean isTraversable(File f) {
        boolean isTraversable = false;
        if (f instanceof RdiffFile) {
            isTraversable = super.isTraversable(f);
        } else if (f == null) {
            isTraversable = false;
        } else {
            String path = f.getPath();
            if (path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            try {
                RdiffFile rdiffFile = this.root.getChild(path);
                if (rdiffFile == null) {
                    LOGGER.log(Level.WARNING, "could not find \"{0}\" in file system", path);
                } else {
                    isTraversable = super.isTraversable(rdiffFile);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "{0} is{1} traversable", new Object[]{f, isTraversable ? "" : " NOT"});
        }
        return isTraversable;
    }

    public static String getRootName(RdiffFile root) {
        String name = null;
        Increment increment = root.getIncrement();
        if (increment != null) {
            Date timestamp = increment.getTimestamp();
            name = BUNDLE.getString("Backup_Of");
            name = MessageFormat.format(name, DATE_FORMAT.format(timestamp));
        }
        return name;
    }

    private static String fileArrayToString(File[] files, String indentation) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(indentation);
            stringBuilder.append(files[i]);
            if (i >= length - 1) continue;
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }
}

