/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.ChrootFileSystemView;
import ch.fhnw.jbackpack.chooser.NoHiddenFilesSwingFileFilter;
import ch.fhnw.jbackpack.chooser.RdiffChooserPanel;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.OperatingSystem;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SelectBackupDirectoryDialog
extends JDialog
implements DocumentListener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(SelectBackupDirectoryDialog.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final ChrootFileSystemView chrootFileSystemView;
    private final Document directoryTextFieldDocument;
    private final String initialDirectory;
    private String selectedPath;
    private boolean selected;
    private JButton cancelButton;
    private JButton directoryButton;
    private JLabel directoryLabel;
    private JTextField directoryTextField;
    private RdiffChooserPanel rdiffChooserPanel;
    private JButton selectButton;

    public SelectBackupDirectoryDialog(Frame parent, ChrootFileSystemView chrootFileSystemView, String initialDirectory, boolean showRadioButtons) {
        super(parent, true);
        this.chrootFileSystemView = chrootFileSystemView;
        this.initialDirectory = initialDirectory;
        this.initComponents();
        this.rdiffChooserPanel.setRadioButtonsVisible(showRadioButtons);
        this.directoryTextFieldDocument = this.directoryTextField.getDocument();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.init();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.selected ? 0 : 2;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if ("checkRunning".equals(propertyName)) {
            if (newValue instanceof Boolean) {
                if (((Boolean)newValue).booleanValue()) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else {
                LOGGER.log(Level.WARNING, "unsupported value: {0}", newValue);
            }
        } else if ("directorySelectable".equals(propertyName)) {
            if (newValue instanceof Boolean) {
                boolean directorySelectable = (Boolean)newValue;
                this.selectButton.setEnabled(directorySelectable);
            } else {
                LOGGER.log(Level.WARNING, "unsupported value: {0}", newValue);
            }
        }
    }

    private void initComponents() {
        this.directoryLabel = new JLabel();
        this.directoryTextField = new JTextField();
        this.directoryButton = new JButton();
        this.rdiffChooserPanel = new RdiffChooserPanel();
        this.selectButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("RdiffChooserPanel.selectBckDlg"));
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                SelectBackupDirectoryDialog.this.formWindowOpened(evt);
            }
        });
        this.directoryLabel.setText(bundle.getString("RdiffChooserPanel.directoryLabel.text"));
        this.directoryButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/fileopen.png")));
        this.directoryButton.setMargin(new Insets(2, 2, 2, 2));
        this.directoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectBackupDirectoryDialog.this.directoryButtonActionPerformed(evt);
            }
        });
        this.rdiffChooserPanel.setBorder(BorderFactory.createEtchedBorder());
        this.selectButton.setText(bundle.getString("Select"));
        this.selectButton.setName("selectButton");
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectBackupDirectoryDialog.this.selectButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectBackupDirectoryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rdiffChooserPanel, -2, 749, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.directoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryTextField, -1, 573, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.directoryButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.directoryLabel).addComponent(this.directoryTextField, -2, -1, -2).addComponent(this.directoryButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdiffChooserPanel, -1, 415, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.selectButton)).addContainerGap()));
    }

    private void directoryButtonActionPerformed(ActionEvent evt) {
        this.showFileChooser();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selected = false;
        this.dispose();
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        this.selectedPath = this.directoryTextField.getText();
        this.selected = true;
        this.dispose();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.directoryTextField.setText(this.initialDirectory);
        if (this.initialDirectory == null || this.initialDirectory.isEmpty()) {
            this.showFileChooser();
        }
    }

    private void showFileChooser() {
        String title = BUNDLE.getString("Select_Backup_Directory");
        File currentDir = new File(this.directoryTextField.getText());
        File parentFile = currentDir.getParentFile();
        while (!currentDir.exists() && parentFile != null) {
            currentDir = parentFile;
            parentFile = currentDir.getParentFile();
        }
        if (CurrentOperatingSystem.OS == OperatingSystem.Mac_OS_X) {
            FileDialog fileDialog = new FileDialog((Dialog)this, title, 0);
            fileDialog.setDirectory(currentDir.getPath());
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String directory = fileDialog.getDirectory();
            String file = fileDialog.getFile();
            if (directory != null && file != null) {
                this.directoryTextField.setText(directory + file + File.separatorChar);
            }
        } else {
            JFileChooser directoryChooser = new JFileChooser(this.chrootFileSystemView);
            directoryChooser.setFileSelectionMode(1);
            directoryChooser.setFileHidingEnabled(false);
            NoHiddenFilesSwingFileFilter noHiddenFilesFilter = NoHiddenFilesSwingFileFilter.getInstance();
            directoryChooser.addChoosableFileFilter(noHiddenFilesFilter);
            directoryChooser.setFileFilter(noHiddenFilesFilter);
            if (currentDir.exists()) {
                directoryChooser.setCurrentDirectory(currentDir);
            } else {
                directoryChooser.setCurrentDirectory(directoryChooser.getFileSystemView().getRoots()[0]);
            }
            directoryChooser.setDialogTitle(title);
            directoryChooser.setApproveButtonText(BUNDLE.getString("Choose"));
            if (directoryChooser.showOpenDialog(this) == 0) {
                String newSelectedPath = directoryChooser.getSelectedFile().getPath();
                this.directoryTextField.setText(newSelectedPath);
            }
        }
    }

    private void init() {
        this.rdiffChooserPanel.addPropertyChangeListener(this);
        this.rdiffChooserPanel.setParentWindow(this);
        this.directoryTextFieldDocument.addDocumentListener(this);
        this.rdiffChooserPanel.setSelectedDirectory(null);
    }

    private void documentChanged(DocumentEvent e) {
        Document document = e.getDocument();
        if (document == this.directoryTextFieldDocument) {
            File oldDir;
            File newDir;
            String newDirPath = this.directoryTextField.getText();
            if (this.selectedPath != null && (newDir = new File(newDirPath)).equals(oldDir = new File(this.selectedPath))) {
                return;
            }
            this.selectedPath = newDirPath;
            this.rdiffChooserPanel.setSelectedDirectory(this.selectedPath);
        }
    }
}

