/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.util;

import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JProgressBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTools {
    private static final Logger LOGGER = Logger.getLogger(FileTools.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final long UNKNOWN_SPACE = 0xFA00000000L;

    public static boolean canWrite(File directory) {
        try {
            File tmpFile = File.createTempFile("test", null, directory);
            if (!tmpFile.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", tmpFile);
            }
            return true;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, directory + " is not writable", ex);
            return false;
        }
    }

    public static int mountSmbWindows(String host, String share, String user, String password) throws IOException {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("net");
        commandList.add("use");
        commandList.add("*");
        commandList.add("\\\\" + host + "\\" + share);
        if (user != null && !user.isEmpty()) {
            commandList.add("/USER:" + user);
        }
        if (password != null && !password.isEmpty()) {
            commandList.add(password);
        }
        String[] commandArray = commandList.toArray(new String[commandList.size()]);
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeProcess(commandArray);
        logger.setLevel(level);
        return returnValue;
    }

    public static int mountSmbLinux(String host, String share, String user, String smbPassword, String sudoPassword) throws IOException {
        String mountPoint = FileTools.createMountPoint(new File(System.getProperty("user.home")), host).getPath();
        StringBuilder stringBuilder = new StringBuilder("#!/bin/sh" + LINE_SEPARATOR + "UID=$(id -u)" + LINE_SEPARATOR + "GID=$(id -g)" + LINE_SEPARATOR + "echo " + sudoPassword + " | " + "sudo -S mount -t cifs -o ");
        boolean optionSet = false;
        if (user != null && !user.isEmpty()) {
            stringBuilder.append("username=");
            stringBuilder.append(user);
            optionSet = true;
        }
        if (smbPassword != null && !smbPassword.isEmpty()) {
            if (optionSet) {
                stringBuilder.append(',');
                optionSet = true;
            }
            stringBuilder.append("password=");
            stringBuilder.append(smbPassword);
        }
        if (optionSet) {
            stringBuilder.append(',');
        }
        stringBuilder.append("uid=${UID},gid=${GID} //");
        stringBuilder.append(host);
        stringBuilder.append('/');
        stringBuilder.append(share);
        stringBuilder.append(' ');
        stringBuilder.append(mountPoint);
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeScript(stringBuilder.toString(), new String[0]);
        logger.setLevel(level);
        return returnValue;
    }

    public static int mountSmbMacOSX(String host, String share, String user, String smbPassword) throws IOException {
        String mountPoint = FileTools.createMountPoint(new File(System.getProperty("user.home")), host).getPath();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//");
        if (user != null && !user.isEmpty()) {
            stringBuilder.append(user);
            if (smbPassword != null && !smbPassword.isEmpty()) {
                stringBuilder.append(':');
                stringBuilder.append(smbPassword);
            }
            stringBuilder.append('@');
        }
        stringBuilder.append(host);
        stringBuilder.append('/');
        stringBuilder.append(share);
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeProcess("mount", "-t", "smbfs", stringBuilder.toString(), mountPoint);
        logger.setLevel(level);
        return returnValue;
    }

    public static boolean isSubDir(File superDir, File subDir) throws IOException {
        File canonicalSub;
        File canonicalSuper = superDir.getCanonicalFile();
        boolean isSubDir = canonicalSuper.equals(canonicalSub);
        for (canonicalSub = subDir.getCanonicalFile(); canonicalSub != null && !isSubDir; canonicalSub = canonicalSub.getParentFile()) {
            isSubDir = canonicalSuper.equals(canonicalSub);
        }
        return isSubDir;
    }

    public static void showSpaceInfo(File file, JProgressBar progressBar) {
        if (FileTools.isSpaceKnown(file)) {
            long totalSpace = file.getTotalSpace();
            if (totalSpace == 0L) {
                progressBar.setValue(0);
                progressBar.setString("");
            } else {
                long usedSpace = totalSpace - file.getUsableSpace();
                progressBar.setValue((int)(usedSpace * 100L / totalSpace));
                String usedSpaceString = FileTools.getDataVolumeString(usedSpace, 1);
                String totalSpaceString = FileTools.getDataVolumeString(totalSpace, 1);
                String text = BUNDLE.getString("Free_Space");
                text = MessageFormat.format(text, usedSpaceString, totalSpaceString);
                progressBar.setString(text);
            }
        } else {
            progressBar.setValue(0);
            progressBar.setString(BUNDLE.getString("Unknown"));
        }
    }

    public static boolean recursiveDelete(File file, boolean removeFile) throws IOException {
        File[] subFiles;
        if (file.isDirectory() && !FileTools.isSymlink(file) && (subFiles = file.listFiles()) != null) {
            for (File subFile : subFiles) {
                FileTools.recursiveDelete(subFile, true);
            }
        }
        return removeFile ? file.delete() : true;
    }

    public static String getDataVolumeString(long bytes, int fractionDigits) {
        if (bytes >= 1024L) {
            NUMBER_FORMAT.setMaximumFractionDigits(fractionDigits);
            float kbytes = (float)bytes / 1024.0f;
            if (kbytes >= 1024.0f) {
                float mbytes = (float)bytes / 1048576.0f;
                if (mbytes >= 1024.0f) {
                    float gbytes = (float)bytes / 1.0737418E9f;
                    if (gbytes >= 1024.0f) {
                        float tbytes = (float)bytes / 1.0995116E12f;
                        return NUMBER_FORMAT.format(tbytes) + " TiB";
                    }
                    return NUMBER_FORMAT.format(gbytes) + " GiB";
                }
                return NUMBER_FORMAT.format(mbytes) + " MiB";
            }
            return NUMBER_FORMAT.format(kbytes) + " KiB";
        }
        return NUMBER_FORMAT.format(bytes) + " Byte";
    }

    public static boolean isSpaceKnown(File file) {
        long usableSpace = file.getUsableSpace();
        long totalSpace = file.getTotalSpace();
        return usableSpace != 0xFA00000000L || totalSpace != 0xFA00000000L;
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static String getEncfsMountPoint(String searchString) throws IOException {
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                List<String> mounts = FileTools.readFile(new File("/proc/mounts"));
                for (String mount : mounts) {
                    String[] tokens = mount.split(" ");
                    if (!tokens[0].equals("encfs") || !tokens[1].contains(searchString)) continue;
                    return tokens[1];
                }
                break;
            }
            case Mac_OS_X: {
                ProcessExecutor processExecutor = new ProcessExecutor();
                processExecutor.executeProcess(true, true, "mount");
                List<String> mounts = processExecutor.getStdOutList();
                for (String mount : mounts) {
                    String[] tokens = mount.split(" ");
                    if (!tokens[0].startsWith("encfs@fuse") || !tokens[2].contains(searchString)) continue;
                    return tokens[2];
                }
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
            }
        }
        return null;
    }

    public static boolean umountSudo(String mountPoint, String sudoPassword) throws IOException {
        String umountScript = "#!/bin/sh" + LINE_SEPARATOR + "echo " + sudoPassword + " | sudo -S umount " + mountPoint;
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeScript(umountScript, new String[0]);
        logger.setLevel(level);
        return returnValue == 0;
    }

    public static boolean umountWin(String drive) throws IOException {
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeProcess("net", "use", drive, "/delete");
        logger.setLevel(level);
        return returnValue == 0;
    }

    public static boolean umountFUSE(File mountPoint, boolean delete) {
        ProcessExecutor processExecutor = new ProcessExecutor();
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                boolean success;
                int returnValue = processExecutor.executeProcess("fusermount", "-u", mountPoint.getPath());
                boolean bl = success = returnValue == 0;
                if (!success) {
                    LOGGER.log(Level.WARNING, "could not umount {0}", mountPoint);
                }
                if (delete) {
                    FileTools.deleteIfEmpty(mountPoint);
                }
                return success;
            }
            case Mac_OS_X: {
                boolean success;
                int returnValue = processExecutor.executeProcess("umount", mountPoint.getPath());
                boolean bl = success = returnValue == 0;
                if (!success) {
                    LOGGER.log(Level.WARNING, "could not umount {0}", mountPoint);
                }
                if (delete) {
                    FileTools.deleteIfEmpty(mountPoint);
                }
                return success;
            }
        }
        LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
        return false;
    }

    public static boolean deleteIfEmpty(File directory) {
        if (directory.listFiles().length == 0) {
            if (!directory.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", directory);
                return false;
            }
        } else {
            LOGGER.log(Level.WARNING, "encfs mountpoint {0} is not empty", directory);
            return false;
        }
        return true;
    }

    public static boolean mountEncFs(String cipherDir, String plainDir, String password) throws IOException {
        String script = "#!/bin/sh" + LINE_SEPARATOR + "echo \"" + password + "\" | encfs -S \"" + cipherDir + "\" \"" + plainDir + '\"' + LINE_SEPARATOR;
        ProcessExecutor processExecutor = new ProcessExecutor();
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        int returnValue = processExecutor.executeScript(script, new String[0]);
        logger.setLevel(level);
        if (returnValue == 0) {
            return true;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "could not mount {0} to {1}", new Object[]{cipherDir, plainDir});
        }
        return false;
    }

    public static boolean isEncFS(String directory) {
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeProcess("encfsctl", directory);
        return returnValue == 0;
    }

    public static List<String> readFile(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        reader.close();
        return lines;
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File tempDirectory = File.createTempFile(prefix, suffix);
        tempDirectory.delete();
        if (tempDirectory.mkdirs()) {
            LOGGER.log(Level.INFO, "using temporary directory {0}", tempDirectory);
            return tempDirectory;
        }
        throw new IOException("could not create " + tempDirectory);
    }

    public static File createTempDirectory(File parentDir, String name) {
        File tempDir = new File(parentDir, name);
        if (tempDir.exists()) {
            int i = 1;
            while ((tempDir = new File(parentDir, name + i)).exists()) {
                ++i;
            }
        }
        if (!tempDir.mkdirs()) {
            LOGGER.log(Level.WARNING, "can not create {0}", tempDir);
        }
        return tempDir;
    }

    public static File createMountPoint(File directory, String name) throws IOException {
        File mountPoint = new File(directory, name);
        if (mountPoint.exists()) {
            if (FileTools.isMountPoint(mountPoint.getPath()) || mountPoint.listFiles().length != 0) {
                int i = 1;
                while (true) {
                    if ((mountPoint = new File(directory, name + "_" + i)).exists()) {
                        if (!FileTools.isMountPoint(mountPoint.getPath()) && mountPoint.listFiles().length == 0) {
                            return mountPoint;
                        }
                    } else {
                        if (mountPoint.mkdirs()) {
                            return mountPoint;
                        }
                        LOGGER.log(Level.WARNING, "can not create {0}", mountPoint);
                    }
                    ++i;
                }
            }
            return mountPoint;
        }
        if (mountPoint.mkdirs()) {
            return mountPoint;
        }
        LOGGER.log(Level.WARNING, "can not create {0}", mountPoint);
        return null;
    }

    public static boolean isMountPoint(String path) throws IOException {
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                List<String> mounts = FileTools.readFile(new File("/proc/mounts"));
                for (String mount : mounts) {
                    String[] tokens = mount.split(" ");
                    if (!tokens[1].equals(path)) continue;
                    return true;
                }
                break;
            }
            case Mac_OS_X: {
                ProcessExecutor processExecutor = new ProcessExecutor();
                processExecutor.executeProcess(true, true, "mount");
                List<String> mounts = processExecutor.getStdOutList();
                for (String mount : mounts) {
                    String[] tokens = mount.split(" ");
                    if (!tokens[2].equals(path)) continue;
                    return true;
                }
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
            }
        }
        return false;
    }

    public static String getMountPoint(String device) throws IOException {
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                List<String> mounts = FileTools.readFile(new File("/proc/mounts"));
                for (String mount : mounts) {
                    String[] tokens = mount.split(" ");
                    if (!tokens[0].startsWith(device)) continue;
                    return tokens[1];
                }
                break;
            }
            case Mac_OS_X: {
                ProcessExecutor processExecutor = new ProcessExecutor();
                processExecutor.executeProcess(true, true, "mount");
                List<String> mounts = processExecutor.getStdOutList();
                for (String mount : mounts) {
                    String[] tokens = mount.split(" ");
                    if (!tokens[0].startsWith(device)) continue;
                    return tokens[2];
                }
                break;
            }
            case Windows: {
                ProcessExecutor processExecutor = new ProcessExecutor();
                processExecutor.executeProcess(true, true, "net", "use");
                List<String> mounts = processExecutor.getStdOutList();
                Pattern pattern = Pattern.compile(".*(\\S:).*" + Pattern.quote(device.toLowerCase()) + ".*");
                for (String mount : mounts) {
                    Matcher matcher = pattern.matcher(mount.toLowerCase());
                    if (!matcher.matches()) continue;
                    return matcher.group(1);
                }
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "{0} is not supported", (Object)CurrentOperatingSystem.OS);
            }
        }
        return null;
    }

    public static boolean isMounted(String device) throws IOException {
        return FileTools.getMountPoint(device) != null;
    }
}

