/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import net.sourceforge.jnlp.config.ConfiguratonValidator;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.controlpanel.ControlPanel;
import net.sourceforge.jnlp.runtime.Translator;

public class CommandLine {
    public static final int ERROR = 1;
    public static final int SUCCESS = 0;
    public final String PROGRAM_NAME = System.getProperty("icedtea-web.bin.name");
    private static final List<String> allCommands = Arrays.asList("list", "get", "set", "reset", "info", "check");
    DeploymentConfiguration config = new DeploymentConfiguration();

    public CommandLine() {
        try {
            this.config.load(false);
        }
        catch (ConfigurationException e) {
            System.out.println(Translator.R("RConfigurationFatal"));
        }
    }

    public int handleHelpCommand(List<String> args) {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " " + allCommands.toString().replace(',', '|').replaceAll(" ", "") + " [help]");
        System.out.println(Translator.R("CLHelpDescription", this.PROGRAM_NAME));
        return 0;
    }

    public void printListHelp() {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " list [--details]");
        System.out.println(Translator.R("CLListDescription"));
    }

    public int handleListCommand(List<String> args) {
        if (args.contains("help")) {
            this.printListHelp();
            return 0;
        }
        boolean verbose = false;
        if (args.contains("--details")) {
            verbose = true;
            args.remove("--details");
        }
        if (args.size() != 0) {
            this.printListHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        for (String key : all.keySet()) {
            Setting<String> value = all.get(key);
            System.out.println(key + ": " + value.getValue());
            if (!verbose) continue;
            System.out.println("\t" + Translator.R("CLDescription", value.getDescription()));
        }
        return 0;
    }

    public void printGetHelp() {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " get property-name");
        System.out.println(Translator.R("CLGetDescription"));
    }

    public int handleGetCommand(List<String> args) {
        if (args.contains("help")) {
            this.printGetHelp();
            return 0;
        }
        if (args.size() != 1) {
            this.printGetHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        String key = args.get(0);
        String value = null;
        if (all.containsKey(key)) {
            value = all.get(key).getValue();
            System.out.println(value);
            return 0;
        }
        System.out.println(Translator.R("CLUnknownProperty", key));
        return 1;
    }

    public void printSetHelp() {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " set property-name value");
        System.out.println(Translator.R("CLSetDescription"));
    }

    public int handleSetCommand(List<String> args) {
        if (args.contains("help")) {
            this.printSetHelp();
            return 0;
        }
        if (args.size() != 2) {
            this.printSetHelp();
            return 1;
        }
        String key = args.get(0);
        String value = args.get(1);
        if (this.config.getRaw().containsKey(key)) {
            Setting<String> old = this.config.getRaw().get(key);
            if (old.getValidator() != null) {
                try {
                    old.getValidator().validate(value);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(Translator.R("CLIncorrectValue", old.getName(), value, old.getValidator().getPossibleValues()));
                    return 1;
                }
            }
            this.config.setProperty(key, value);
        } else {
            System.out.println(Translator.R("CLWarningUnknownProperty", key));
            this.config.setProperty(key, value);
        }
        try {
            this.config.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void printResetHelp() {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " reset [all|property-name]");
        System.out.println(Translator.R("CLResetDescription"));
    }

    public int handleResetCommand(List<String> args) {
        if (args.contains("help")) {
            this.printResetHelp();
            return 0;
        }
        if (args.size() != 1) {
            this.printResetHelp();
            return 1;
        }
        String key = args.get(0);
        boolean resetAll = false;
        if (key.equals("all")) {
            resetAll = true;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        if (!resetAll && !all.containsKey(key)) {
            System.out.println(Translator.R("CLUnknownProperty", key));
            return 1;
        }
        if (resetAll) {
            for (String aKey : all.keySet()) {
                Setting<String> setting = all.get(aKey);
                setting.setValue(setting.getDefaultValue());
            }
        } else {
            Setting<String> setting = all.get(key);
            setting.setValue(setting.getDefaultValue());
        }
        try {
            this.config.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void printInfoHelp() {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " info property-name");
        System.out.println(Translator.R("CLInfoDescription"));
    }

    public int handleInfoCommand(List<String> args) {
        String key;
        if (args.contains("help")) {
            this.printInfoHelp();
            return 0;
        }
        if (args.size() != 1) {
            this.printInfoHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        Setting<String> value = all.get(key = args.get(0));
        if (value == null) {
            System.out.println(Translator.R("CLNoInfo"));
            return 1;
        }
        System.out.println(Translator.R("CLDescription", value.getDescription()));
        System.out.println(Translator.R("CLValue", value.getValue()));
        if (value.getValidator() != null) {
            System.out.println("\t" + Translator.R("VVPossibleValues", value.getValidator().getPossibleValues()));
        }
        System.out.println(Translator.R("CLValueSource", value.getSource()));
        return 0;
    }

    public void printCheckHelp() {
        System.out.println(Translator.R("Usage"));
        System.out.println("  " + this.PROGRAM_NAME + " check");
        System.out.println(Translator.R("CLCheckDescription"));
    }

    public int handleCheckCommand(List<String> args) {
        if (args.contains("help")) {
            this.printCheckHelp();
            return 0;
        }
        if (args.size() != 0) {
            this.printCheckHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        ConfiguratonValidator validator = new ConfiguratonValidator(all);
        validator.validate();
        boolean allValid = true;
        for (Setting<String> setting : validator.getIncorrectSetting()) {
            System.out.println(Translator.R("CLIncorrectValue", setting.getName(), setting.getValue(), setting.getValidator().getPossibleValues()));
            allValid = false;
        }
        for (Setting<String> setting : validator.getUnrecognizedSetting()) {
            System.out.println(Translator.R("CLUnknownProperty", setting.getName()));
            allValid = false;
        }
        if (allValid) {
            System.out.println(Translator.R("CLNoIssuesFound"));
            return 0;
        }
        return 1;
    }

    public int handle(String[] commandAndArgs) {
        int val;
        if (commandAndArgs == null) {
            throw new NullPointerException("command is null");
        }
        if (commandAndArgs.length == 0) {
            this.handleHelpCommand(new ArrayList<String>());
            return 1;
        }
        String command = commandAndArgs[0];
        String[] argsArray = new String[commandAndArgs.length - 1];
        System.arraycopy(commandAndArgs, 1, argsArray, 0, commandAndArgs.length - 1);
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(argsArray));
        if (command.equals("help")) {
            val = this.handleHelpCommand(arguments);
        } else if (command.equals("list")) {
            val = this.handleListCommand(arguments);
        } else if (command.equals("set")) {
            val = this.handleSetCommand(arguments);
        } else if (command.equals("reset")) {
            val = this.handleResetCommand(arguments);
        } else if (command.equals("get")) {
            val = this.handleGetCommand(arguments);
        } else if (command.equals("info")) {
            val = this.handleInfoCommand(arguments);
        } else if (command.equals("check")) {
            val = this.handleCheckCommand(arguments);
        } else if (allCommands.contains(command)) {
            System.out.println("INTERNAL ERROR: " + command + " should have been implemented");
            val = 1;
        } else {
            System.out.println(Translator.R("CLUnknownCommand", command));
            this.handleHelpCommand(new ArrayList<String>());
            val = 1;
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            ControlPanel.main(new String[0]);
        } else {
            CommandLine cli = new CommandLine();
            int result = cli.handle(args);
            System.exit(result);
        }
    }
}

