/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import sun.misc.Launcher;

public class MoreInfoPane
extends SecurityDialogPanel {
    public MoreInfoPane(SecurityDialog x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.addComponents();
    }

    private void addComponents() {
        ArrayList<String> details = this.certVerifier.getDetails();
        int numLabels = details.size();
        JPanel errorPanel = new JPanel(new GridLayout(numLabels, 1));
        errorPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        errorPanel.setPreferredSize(new Dimension(400, 70 * numLabels));
        for (int i = 0; i < numLabels; ++i) {
            ImageIcon icon = null;
            icon = details.get(i).equals(Translator.R("STrustedCertificate")) ? new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/info-small.png")) : new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning-small.png"));
            errorPanel.add(new JLabel(this.htmlWrap(details.get(i)), icon, 2));
        }
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        JButton certDetails = new JButton(Translator.R("SCertificateDetails"));
        certDetails.addActionListener(new CertInfoButtonListener());
        JButton close = new JButton(Translator.R("ButClose"));
        close.addActionListener(this.createSetValueListener(this.parent, 0));
        buttonsPanel.add((Component)certDetails, "West");
        buttonsPanel.add((Component)close, "East");
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.add((Component)errorPanel, "North");
        this.add((Component)buttonsPanel, "South");
    }

    private class CertInfoButtonListener
    implements ActionListener {
        private CertInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityDialog.showCertInfoDialog(MoreInfoPane.this.parent.getJarSigner(), MoreInfoPane.this.parent);
        }
    }
}

