/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;

class XBasicService
implements BasicService {
    private String command = null;
    private boolean initialized = false;

    protected XBasicService() {
    }

    @Override
    public URL getCodeBase() {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile file = app.getJNLPFile();
            if (file.getCodeBase() != null) {
                return file.getCodeBase();
            }
            JARDesc mainJar = file.getResources().getMainJAR();
            if (mainJar != null) {
                return mainJar.getLocation();
            }
        }
        return null;
    }

    @Override
    public boolean isOffline() {
        URL url = this.findFirstURLFromJNLPFile();
        try {
            url.openConnection().getInputStream().close();
            return false;
        }
        catch (IOException exception) {
            return true;
        }
    }

    private URL findFirstURLFromJNLPFile() {
        URL arbitraryURL;
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile jnlpFile = app.getJNLPFile();
            URL sourceURL = jnlpFile.getSourceLocation();
            if (sourceURL != null) {
                return sourceURL;
            }
            URL codeBaseURL = jnlpFile.getCodeBase();
            if (codeBaseURL != null) {
                return codeBaseURL;
            }
            InformationDesc informationDesc = jnlpFile.getInformation();
            URL homePage = informationDesc.getHomepage();
            if (homePage != null) {
                return homePage;
            }
            int i$ = 0;
            JARDesc[] jarDescs = jnlpFile.getResources().getJARs();
            JARDesc[] arr$ = jarDescs;
            int len$ = arr$.length;
            if (i$ < len$) {
                JARDesc jarDesc = arr$[i$];
                return jarDesc.getLocation();
            }
        }
        try {
            arbitraryURL = new URL("http://icedtea.classpath.org");
        }
        catch (MalformedURLException malformedURL) {
            throw new RuntimeException(malformedURL);
        }
        return arbitraryURL;
    }

    @Override
    public boolean isWebBrowserSupported() {
        this.initialize();
        return this.command != null;
    }

    @Override
    public boolean showDocument(URL url) {
        block6: {
            this.initialize();
            if (url.toString().endsWith(".jnlp")) {
                try {
                    new Launcher().launchExternal(url);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (this.command != null) {
                try {
                    Runtime.getRuntime().exec(this.command + " " + url.toString());
                    return true;
                }
                catch (IOException ex) {
                    if (!JNLPRuntime.isDebug()) break block6;
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initializeBrowserCommand();
        if (JNLPRuntime.isDebug()) {
            System.out.println("browser is " + this.command);
        }
    }

    private void initializeBrowserCommand() {
        if (JNLPRuntime.isWindows()) {
            this.command = "rundll32 url.dll,FileProtocolHandler ";
        } else if (JNLPRuntime.isUnix()) {
            DeploymentConfiguration config = JNLPRuntime.getConfiguration();
            this.command = config.getProperty("deployment.browser.path");
            if (this.command != null) {
                return;
            }
            if (this.posixCommandExists("xdg-open")) {
                this.command = "xdg-open";
                return;
            }
            if (this.posixCommandExists(System.getenv("BROWSER"))) {
                this.command = System.getenv("BROWSER");
                return;
            }
            do {
                this.command = this.promptForCommand(this.command);
            } while (this.command == null || !this.posixCommandExists(this.command));
            config.setProperty("deployment.browser.path", this.command);
            try {
                config.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            DeploymentConfiguration config = JNLPRuntime.getConfiguration();
            this.command = config.getProperty("deployment.browser.path");
            if (this.command == null) {
                this.command = this.promptForCommand(null);
                if (this.command != null) {
                    config.setProperty("deployment.browser.path", this.command);
                    try {
                        config.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private boolean posixCommandExists(String command) {
        if (command == null || command.trim().length() == 0) {
            return false;
        }
        if ((command = command.trim()).contains("\n") || command.contains("\r")) {
            return false;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "type " + command});
            p.waitFor();
            return p.exitValue() == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String promptForCommand(String previousCommand) {
        String message = null;
        message = previousCommand == null ? Translator.R("RBrowserLocationPromptMessage") : Translator.R("RBrowserLocationPromptMessageWithReason", previousCommand);
        return JOptionPane.showInputDialog(new JPanel(), Translator.R("RBrowserLocationPromptTitle"), message, -1);
    }
}

