/*
 * Decompiled with CFR 0.152.
 */
package hr.fjagic.jdosage2.webcomic;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import hr.fjagic.jdosage2.Configuration;
import hr.fjagic.jdosage2.webcomic.ValidationException;
import hr.fjagic.jdosage2.webcomic.WebcomicException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Connection;
import org.jsoup.helper.HttpConnection;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Webcomic
extends Properties {
    private static final long serialVersionUID = -2239765252611641698L;
    private static final char[] FILENAME_CHARS_BLACKLIST = new char[]{'|', '\\', '?', '*', '<', '\"', ':', '>', '+', '[', ']', '/'};
    private static final char PLACEHOLDER = '_';
    private static final String NAME = "name";
    private static final String HOMEPAGE = "homepage";
    private static final String FILE_TEMPLATE = "fileTemplate";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_IMAGE_URL = "imageUrl";
    private static final String METADATA_FILENAME = "filename";
    private static final String METADATA_FILE_EXTENSION = "fileExt";
    private static final String DEFAULT_FILE_TEMPLATE = "${name}/${filename}.${fileExt}";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> progress;
    private Template compiledTemplate;

    public String getName() {
        return StringUtils.trimToNull((String)this.getProperty("name"));
    }

    public String getHomepage() {
        return StringUtils.trimToNull((String)this.getProperty(HOMEPAGE));
    }

    public String getFileTemplate() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{StringUtils.trimToNull((String)this.getProperty(FILE_TEMPLATE)), DEFAULT_FILE_TEMPLATE});
    }

    private Template compileTemplate() throws IOException {
        if (this.compiledTemplate == null) {
            this.compiledTemplate = new Template(FILE_TEMPLATE, (Reader)new StringReader(this.getFileTemplate()), new freemarker.template.Configuration());
        }
        return this.compiledTemplate;
    }

    public Map<String, String> getProgress() {
        if (this.progress == null) {
            this.progress = new HashMap<String, String>();
        }
        return this.progress;
    }

    public void validate() throws ValidationException {
        if (this.getName() == null) {
            throw new ValidationException("name", "name is required");
        }
        if (this.getHomepage() != null) {
            try {
                new URL(this.getHomepage());
            }
            catch (MalformedURLException e) {
                throw new ValidationException(HOMEPAGE, e);
            }
        }
        if (this.getFileTemplate() == null) {
            throw new ValidationException(FILE_TEMPLATE, "fileTemplate is required");
        }
        try {
            this.compileTemplate();
        }
        catch (IOException e) {
            throw new ValidationException(FILE_TEMPLATE, e);
        }
        catch (Exception e) {
            throw new ValidationException(FILE_TEMPLATE, e);
        }
    }

    public abstract boolean downloadNext(Configuration var1) throws IOException, WebcomicException;

    protected boolean isResetWhenFinished() {
        return false;
    }

    protected String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn("Error decoding url " + url, (Throwable)e);
            return url;
        }
    }

    protected String decodeHtml(String s) {
        if (s == null) {
            return null;
        }
        String decoded = StringEscapeUtils.unescapeHtml4((String)s);
        String trimmed = StringUtils.trim((String)decoded.replaceAll("\\s+", " "));
        String replaced = StringUtils.replaceChars((String)trimmed, (String)String.valueOf(FILENAME_CHARS_BLACKLIST), (String)StringUtils.repeat((char)'_', (int)FILENAME_CHARS_BLACKLIST.length));
        return replaced;
    }

    private String processFileTemplate(Map<String, String> metadata) throws WebcomicException {
        this.logger.trace("Processing file template, metadata: {}", metadata);
        try {
            Template template = this.compileTemplate();
            StringWriter writer = new StringWriter();
            template.process(metadata, (Writer)writer);
            String s = FilenameUtils.normalize(writer.toString());
            this.logger.trace("Rendered template: {}", (Object)s);
            return s;
        }
        catch (IOException e) {
            throw new WebcomicException("Error parsing template " + this.getFileTemplate() + " with metadata " + metadata, e);
        }
        catch (TemplateException e) {
            throw new WebcomicException("Error rendering template " + this.getFileTemplate() + " with metadata " + metadata, e);
        }
        catch (Exception e) {
            throw new WebcomicException("Error rendering template " + this.getFileTemplate() + " with metadata " + metadata, e);
        }
    }

    protected Document downloadWebpage(String url, Configuration config) throws IOException {
        Connection connection = HttpConnection.connect((String)url).timeout(config.getConnectionTimeout() * 1000).userAgent(config.getUserAgent());
        Document document = null;
        int i = 0;
        while (i < config.getConnectionRetries()) {
            try {
                document = connection.get();
                break;
            }
            catch (IOException e) {
                if (i >= config.getConnectionRetries() - 1) {
                    throw e;
                }
                this.logger.debug("Error downloading " + url + ", retrying", (Throwable)e);
                ++i;
            }
        }
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean downloadComic(Map<String, String> metadata, String imageUrl, String referrer, Configuration config) throws IOException, WebcomicException {
        try {
            Connection.Response response;
            File targetFile;
            block19: {
                HashMap<String, String> newMetadata = new HashMap<String, String>(metadata);
                String decodedUrl = this.decodeUrl(imageUrl);
                newMetadata.put("name", this.getName());
                newMetadata.put(METADATA_IMAGE_URL, decodedUrl);
                newMetadata.put(METADATA_FILENAME, FilenameUtils.getBaseName(decodedUrl));
                newMetadata.put(METADATA_FILE_EXTENSION, FilenameUtils.getExtension(decodedUrl));
                WebcomicException templateError = null;
                targetFile = null;
                try {
                    targetFile = new File(config.getDownloadDir(), this.processFileTemplate(newMetadata));
                    this.logger.trace("Downloading {} to {}", (Object)imageUrl, (Object)targetFile);
                    if (targetFile.exists()) {
                        this.logger.info("New {} skipped because {} already exists", (Object)this.getName(), (Object)targetFile);
                        return false;
                    }
                }
                catch (WebcomicException e) {
                    templateError = e;
                }
                Connection connection = HttpConnection.connect((String)imageUrl).timeout(config.getConnectionTimeout() * 1000).userAgent(config.getUserAgent()).ignoreContentType(true);
                if (referrer != null) {
                    connection.referrer(referrer);
                }
                response = null;
                int i = 0;
                while (i < config.getConnectionRetries()) {
                    try {
                        response = connection.execute();
                        break;
                    }
                    catch (IOException e) {
                        if (i >= config.getConnectionRetries() - 1) {
                            throw e;
                        }
                        this.logger.debug("Error downloading " + imageUrl + ", retrying", (Throwable)e);
                        ++i;
                    }
                }
                if (response.contentType() != null && !response.contentType().startsWith("image")) {
                    throw new WebcomicException(String.valueOf(imageUrl) + " is " + response.contentType() + ", not an image");
                }
                if (response.hasHeader("Content-Disposition")) {
                    String contentDisposition = response.header("Content-Disposition");
                    this.logger.trace("Found response header Content-Disposition: {}", (Object)contentDisposition);
                    try {
                        ContentDisposition cd = new ContentDisposition(contentDisposition);
                        String filename = cd.getParameter(METADATA_FILENAME);
                        if (!StringUtils.isNotBlank((CharSequence)filename)) break block19;
                        newMetadata.put(METADATA_FILENAME, FilenameUtils.getBaseName(filename));
                        newMetadata.put(METADATA_FILE_EXTENSION, FilenameUtils.getExtension(filename));
                        targetFile = new File(config.getDownloadDir(), this.processFileTemplate(newMetadata));
                        this.logger.trace("Filename changed, downloading {} to {}", (Object)imageUrl, (Object)targetFile);
                        if (targetFile.exists()) {
                            this.logger.info("New {} skipped because {} already exists", (Object)this.getName(), (Object)targetFile);
                            return false;
                        }
                    }
                    catch (ParseException e) {
                        this.logger.warn("Error parsing response header Content-Disposition: " + contentDisposition, (Throwable)e);
                    }
                } else if (templateError != null) {
                    throw templateError;
                }
            }
            File tempFile = new File(targetFile.getParentFile(), String.valueOf(targetFile.getName()) + ".part");
            Thread cleanupThread = new Thread(new CleanupRunnable(tempFile));
            Runtime.getRuntime().addShutdownHook(cleanupThread);
            FileUtils.writeByteArrayToFile(tempFile, response.bodyAsBytes());
            tempFile.renameTo(targetFile);
            Runtime.getRuntime().removeShutdownHook(cleanupThread);
            this.logger.info("New {} downloaded to {}", (Object)this.getName(), (Object)targetFile);
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (WebcomicException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebcomicException("Error downloading " + imageUrl, e);
        }
    }

    private class CleanupRunnable
    implements Runnable {
        private File file;

        public CleanupRunnable(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            if (FileUtils.deleteQuietly(this.file)) {
                Webcomic.this.logger.trace("Deleted incomplete file {}", (Object)this.file);
            }
        }
    }
}

