/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import jedecma.FixedSizePlainDocument;
import jedecma.Jedecma;
import jedecma.MyLock;
import jedecma.Uti1;

public class ProfTable
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String delString = Jedecma.localMessagesBundle.getString("DELETE");
    private static final String newString = Jedecma.localMessagesBundle.getString("NEW");
    private static final String lockCode = "TBLPROF";
    private JButton delBut;
    private JButton newBut;
    private JTextField profCod;
    private JTextField profDes;
    private ProfTableModel model;
    private final JTable table;
    private Vector rows = new Vector();

    public ProfTable() {
        super(Jedecma.mf, Jedecma.localMessagesBundle.getString("JOB_LIST"), true);
        this.model = new ProfTableModel();
        this.table = new JTable(this.model);
        int lockrv = 0;
        if (Jedecma.user != null) {
            lockrv = MyLock.setLock(Jedecma.dbmgr, lockCode, Jedecma.user.userid, true);
        }
        if (lockrv == 0) {
            this.model.addColumn(Jedecma.localMessagesBundle.getString("CODE"));
            this.model.addColumn(Jedecma.localMessagesBundle.getString("DESC"));
            ResultSet resultSet = Jedecma.dbmgr.executeQuery("SELECT PROFCOD, PROFDES FROM TBLPROF ORDER BY PROFCOD");
            try {
                ResultSetMetaData md = resultSet.getMetaData();
                int numberOfColumns = md.getColumnCount();
                while (resultSet.next()) {
                    Vector<Object> nextRow = new Vector<Object>();
                    int i = 1;
                    while (i <= numberOfColumns) {
                        nextRow.addElement(resultSet.getObject(i));
                        ++i;
                    }
                    this.model.addRow(nextRow);
                }
            }
            catch (SQLException ex) {
                System.err.println(ex);
                Uti1.error(Jedecma.localMessagesBundle.getString("SQL_ERROR"), true);
            }
            if (Jedecma.jTableFont != null) {
                this.table.setFont(Jedecma.jTableFont);
            }
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.table.setColumnSelectionAllowed(false);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(0);
            SelectionListener listener = new SelectionListener(this.table);
            this.table.getSelectionModel().addListSelectionListener(listener);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
            TableColumn column = null;
            column = this.table.getColumnModel().getColumn(0);
            column.setMaxWidth(45);
            column = this.table.getColumnModel().getColumn(1);
            column.setCellEditor(new ProfTableCellEditor());
            JScrollPane scrollPan = new JScrollPane(this.table);
            JPanel mainPan = new JPanel();
            mainPan.setLayout(new BoxLayout(mainPan, 1));
            mainPan.add((Component)scrollPan, "Center");
            JPanel butPan = new JPanel();
            butPan.setLayout(new FlowLayout(2));
            butPan.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.profCod = new JTextField(4);
            this.profCod.setDocument(new FixedSizePlainDocument(4));
            this.profCod.setText("");
            this.profCod.addFocusListener(new focusListener());
            butPan.add(this.profCod);
            this.profDes = new JTextField(30);
            this.profDes.setDocument(new FixedSizePlainDocument(30));
            this.profDes.setText("");
            this.profDes.addFocusListener(new focusListener());
            butPan.add(this.profDes);
            this.delBut = new JButton(delString);
            this.delBut.setMnemonic(76);
            this.delBut.addActionListener(new DelListener());
            this.delBut.setActionCommand(delString);
            this.delBut.setEnabled(false);
            butPan.add(this.delBut);
            this.newBut = new JButton(newString);
            this.newBut.addActionListener(new NewListener());
            this.newBut.setActionCommand(newString);
            this.newBut.setMnemonic(78);
            this.newBut.setEnabled(false);
            butPan.add(this.newBut);
            mainPan.add((Component)butPan, "South");
            this.getContentPane().add((Component)mainPan, "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (Jedecma.user != null) {
                        MyLock.delLock(Jedecma.dbmgr, ProfTable.lockCode, Jedecma.user.userid);
                    }
                }
            });
            this.pack();
            this.setVisible(true);
        } else {
            Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("JOB_LIST")) + " " + Jedecma.localMessagesBundle.getString("IN_USE") + " (" + lockrv + ")", false);
        }
    }

    public String getProfDes(String c) {
        String cod = c;
        String des = "";
        ResultSet rs = Jedecma.dbmgr.executeQuery("SELECT PROFCOD, PROFDES FROM TBLPROF WHERE PROFCOD='" + Uti1.escape(cod) + "'");
        int i = 0;
        try {
            while (rs.next()) {
                des = (String)rs.getObject(2);
                ++i;
            }
        }
        catch (SQLException ex) {
            System.err.println(ex);
            Uti1.error(Jedecma.localMessagesBundle.getString("SQL_ERROR"), true);
        }
        if (i > 0) {
            return des;
        }
        return null;
    }

    class DelListener
    implements ActionListener {
        DelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rows = ProfTable.this.table.getRowCount();
            int r = ProfTable.this.table.getSelectedRow();
            int c = ProfTable.this.table.getSelectedColumn();
            if (rows > 0 && r != -1 && !ProfTable.this.model.isCellEditable(r, c)) {
                String va = (String)ProfTable.this.table.getModel().getValueAt(r, 0);
                try {
                    ProfTable.this.model.removeRow(r);
                    ProfTable.this.delBut.setEnabled(false);
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    System.out.println("ArrayIndexOutOfBoundsException indice di riga:" + r + " righe: " + ProfTable.this.table.getRowCount());
                }
                String cod = ProfTable.this.profCod.getText();
                int rc = Jedecma.dbmgr.executeUpdate("DELETE FROM TBLPROF WHERE PROFCOD='" + Uti1.escape(cod) + "'");
                if (rc != 1) {
                    Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("JOB_LIST")) + ": " + Jedecma.localMessagesBundle.getString("INS_UPD_FAILURE"), true);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class NewListener
    implements ActionListener {
        NewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfTable.this.profCod.setText(ProfTable.this.profCod.getText().toUpperCase());
            String cod = ProfTable.this.profCod.getText();
            String des = ProfTable.this.profDes.getText();
            if (!cod.equals("")) {
                if (ProfTable.this.getProfDes(cod) != null) {
                    Toolkit.getDefaultToolkit().beep();
                    Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("CODE")) + ": " + cod + " " + Jedecma.localMessagesBundle.getString("ALREADY_EXISTING"), false);
                } else {
                    try {
                        ProfTable.this.model.addRow(new Object[]{cod, des});
                    }
                    catch (Exception x) {
                        Uti1.error(Jedecma.localMessagesBundle.getString("TMP_TABLE_ERROR"), false);
                    }
                    int rc = Jedecma.dbmgr.executeUpdate("INSERT INTO TBLPROF VALUES ('" + Uti1.escape(cod) + "', '" + Uti1.escape(des) + "')");
                    if (rc != 1) {
                        Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("JOB_LIST")) + ": " + Jedecma.localMessagesBundle.getString("INS_UPD_FAILURE"), true);
                    }
                }
            }
            ProfTable.this.newBut.setEnabled(false);
        }
    }

    public class ProfTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((JTextField)this.component).setText((String)value);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            String text = ((JTextField)this.component).getText();
            if (text.length() > 30) {
                text = text.substring(0, 30);
            }
            return text;
        }
    }

    public class ProfTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        @Override
        public void setValueAt(Object v, int r, int c) {
            Object value = v;
            int row = r;
            int column = c;
            super.setValueAt(value, row, column);
            String cod = (String)ProfTable.this.table.getModel().getValueAt(row, 0);
            String des = (String)ProfTable.this.table.getModel().getValueAt(row, 1);
            int rc = Jedecma.dbmgr.executeUpdate("UPDATE TBLPROF SET PROFDES = '" + Uti1.escape(des) + "' WHERE PROFCOD = '" + Uti1.escape(cod) + "'");
            if (rc != 1) {
                Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("JOB_LIST")) + ": " + Jedecma.localMessagesBundle.getString("INS_UPD_FAILURE"), true);
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int rows = this.table.getRowCount();
            int r = this.table.getSelectedRow();
            int c = this.table.getSelectedColumn();
            ProfTable.this.newBut.setEnabled(false);
            ProfTable.this.delBut.setEnabled(c == 0);
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                if (rows > 0 && r != -1 && !e.getValueIsAdjusting()) {
                    ProfTable.this.profCod.setText((String)this.table.getModel().getValueAt(r, 0));
                    ProfTable.this.profDes.setText((String)this.table.getModel().getValueAt(r, 1));
                }
            } else if (e.getSource() == this.table.getColumnModel().getSelectionModel() && this.table.getColumnSelectionAllowed()) {
                int first = e.getFirstIndex();
                int n = e.getLastIndex();
            }
        }
    }

    class focusListener
    implements FocusListener {
        focusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ProfTable.this.delBut.setEnabled(false);
            ProfTable.this.newBut.setEnabled(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            ProfTable.this.delBut.setEnabled(true);
        }
    }
}

