/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import jedecma.CtrTextField;
import jedecma.FixedSizePlainDocument;
import jedecma.JDBCMgr;
import jedecma.Jedecma;
import jedecma.Menuable;
import jedecma.MyJComboBox;
import jedecma.MyJTextField;
import jedecma.MyJlabel;
import jedecma.Uti1;

public class SQLTool
implements Menuable {
    private JButton qryBut;
    private JButton openBut;
    private JButton loadBut;
    private JButton showTableBut;
    private JButton dmpBut;
    private JPanel mainPan;
    private JPanel qryPan;
    private JPanel qryFilePan;
    private JPanel qryTablePan;
    private JPanel msgTablePan;
    private JPanel dmpPan;
    private JSplitPane sp0;
    private JSplitPane sp1;
    private JTabbedPane tabPan;
    private JTextArea qry;
    private JTextArea qryResult;
    private QryTableModel qryTableModel;
    private JTable qryTable;
    private MyJTextField recFrom;
    private MyJTextField recTo;
    private MyJTextField qryFile;
    private MyJTextField dateFrom;
    private MyJTextField dateTo;
    private final JFileChooser fc = new JFileChooser();
    private MyJComboBox tblCmb;

    @Override
    public void stop() {
        this.saveDoneQry();
        Jedecma.mainPan.remove(this.mainPan);
        Jedecma.mf.repaint();
    }

    @Override
    public void start() {
        this.mainPan = new JPanel();
        this.mainPan.setLayout(new BoxLayout(this.mainPan, 1));
        this.sp0 = new JSplitPane(0);
        this.sp0.setTopComponent(this.tabPan);
        this.sp0.setOneTouchExpandable(true);
        this.mainPan.add(this.sp0);
        this.tabPan = new JTabbedPane(1);
        this.sp0.setTopComponent(this.tabPan);
        this.qryPan = new JPanel();
        this.tabPan.addTab(Jedecma.localMessagesBundle.getString("MANUAL_SQL_CMDS"), this.qryPan);
        GridBagLayout gbQPan = new GridBagLayout();
        GridBagConstraints gbcQPan = new GridBagConstraints();
        this.qryPan.setLayout(gbQPan);
        this.qry = new JTextArea(6, 50);
        this.qry.setDocument(new FixedSizePlainDocument(1024));
        JScrollPane qryScrollPan = new JScrollPane(this.qry);
        this.qry.setLineWrap(true);
        this.qry.setWrapStyleWord(true);
        Uti1.bldConst(gbcQPan, 0, 0, 10, 2, 1, 1, 11, 1);
        gbQPan.setConstraints(qryScrollPan, gbcQPan);
        this.qryPan.add(qryScrollPan);
        this.qryBut = new JButton(Jedecma.localMessagesBundle.getString("EXECUTE"));
        this.qryBut.setMnemonic(69);
        this.qryBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String q = SQLTool.this.qry.getText();
                SQLTool.this.doQuery(q);
                SQLTool.this.qry.setText(q.trim());
            }
        });
        Uti1.bldConst(gbcQPan, 10, 0, 1, 1, 0, 0);
        gbQPan.setConstraints(this.qryBut, gbcQPan);
        this.qryPan.add(this.qryBut);
        this.showTableBut = new JButton("showTables");
        this.showTableBut.setMnemonic(84);
        this.showTableBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String q = SQLTool.this.showTables();
                if (q.length() > 0) {
                    SQLTool.this.doQuery(q);
                }
            }
        });
        Uti1.bldConst(gbcQPan, 10, 1, 1, 1, 0, 0);
        gbQPan.setConstraints(this.showTableBut, gbcQPan);
        this.qryPan.add(this.showTableBut);
        this.qryFilePan = new JPanel();
        GridBagLayout gbFPan = new GridBagLayout();
        GridBagConstraints gbcFPan = new GridBagConstraints();
        this.qryFilePan.setLayout(gbFPan);
        this.tabPan.addTab(Jedecma.localMessagesBundle.getString("FILED_SQL_CMDS"), this.qryFilePan);
        this.openBut = new JButton(Jedecma.localMessagesBundle.getString("BROWSE"));
        this.openBut.setMnemonic(83);
        this.openBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLTool.this.fc.addChoosableFileFilter(new MyFileFilter());
                SQLTool.this.fc.setCurrentDirectory(new File(Uti1.getWrkDir()));
                int returnVal = SQLTool.this.fc.showOpenDialog(null);
                if (returnVal == 0) {
                    String s = SQLTool.this.fc.getSelectedFile().getAbsolutePath();
                    SQLTool.this.qryFile.setText(s);
                }
            }
        });
        Uti1.bldConst(gbcFPan, 0, 1, 5, 1, 1, 0);
        gbFPan.setConstraints(this.openBut, gbcFPan);
        this.qryFilePan.add(this.openBut);
        MyJlabel lab = new MyJlabel(Jedecma.localMessagesBundle.getString("FILE_NAME"));
        Uti1.bldConst(gbcFPan, 0, 0, 4, 1, 1, 1);
        gbFPan.setConstraints(lab, gbcFPan);
        this.qryFilePan.add(lab);
        this.qryFile = new MyJTextField(128, "", new float[0], 0);
        this.qryFile.addFocusListener(new CtrTextField());
        Uti1.bldConst(gbcFPan, 4, 0, 26, 1, 1, 0);
        gbFPan.setConstraints(this.qryFile, gbcFPan);
        this.qryFilePan.add(this.qryFile);
        lab = new MyJlabel(Jedecma.localMessagesBundle.getString("REC_START"));
        Uti1.bldConst(gbcFPan, 5, 1, 3, 1, 1, 1);
        gbFPan.setConstraints(lab, gbcFPan);
        this.qryFilePan.add(lab);
        this.recFrom = new MyJTextField(5, "0", new float[0], 1);
        this.recFrom.addFocusListener(new CtrTextField());
        Uti1.bldConst(gbcFPan, 8, 1, 4, 1, 1, 0);
        gbFPan.setConstraints(this.recFrom, gbcFPan);
        this.qryFilePan.add(this.recFrom);
        lab = new MyJlabel(Jedecma.localMessagesBundle.getString("REC_END"));
        Uti1.bldConst(gbcFPan, 12, 1, 3, 1, 1, 1);
        gbFPan.setConstraints(lab, gbcFPan);
        this.qryFilePan.add(lab);
        this.recTo = new MyJTextField(5, "0", new float[0], 1);
        this.recTo.addFocusListener(new CtrTextField());
        Uti1.bldConst(gbcFPan, 15, 1, 4, 1, 1, 0);
        gbFPan.setConstraints(this.recTo, gbcFPan);
        this.qryFilePan.add(this.recTo);
        this.loadBut = new JButton(Jedecma.localMessagesBundle.getString("EXECUTE"));
        this.loadBut.setMnemonic(85);
        this.loadBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLTool.this.loadFileQry(SQLTool.this.qryFile.getText());
            }
        });
        Uti1.bldConst(gbcFPan, 25, 1, 5, 1, 1, 0);
        gbFPan.setConstraints(this.loadBut, gbcFPan);
        this.qryFilePan.add(this.loadBut);
        this.sp1 = new JSplitPane(0);
        this.sp1.setOneTouchExpandable(true);
        this.sp1.setDividerLocation(200);
        this.sp0.add(this.sp1);
        this.msgTablePan = new JPanel();
        this.sp1.add(this.msgTablePan);
        this.sp1.setTopComponent(this.msgTablePan);
        this.msgTablePan.setBorder(BorderFactory.createTitledBorder(" " + Jedecma.localMessagesBundle.getString("MESSAGES") + " "));
        GridBagLayout gbRPan = new GridBagLayout();
        GridBagConstraints gbcRPan = new GridBagConstraints();
        this.msgTablePan.setLayout(gbRPan);
        this.qryResult = new JTextArea(6, 50);
        JScrollPane qryResPan = new JScrollPane(this.qryResult);
        Uti1.bldConst(gbcRPan, 0, 0, 1, 1, 1, 1, 11, 1);
        gbRPan.setConstraints(qryResPan, gbcRPan);
        this.msgTablePan.add(qryResPan);
        this.qryResult.setEditable(false);
        this.qryTablePan = new JPanel();
        this.sp1.add(this.qryTablePan);
        this.qryTablePan.setBorder(BorderFactory.createTitledBorder(" " + Jedecma.localMessagesBundle.getString("LAST_CMDS") + " "));
        GridBagLayout gbDPan = new GridBagLayout();
        GridBagConstraints gbcDPan = new GridBagConstraints();
        this.qryTablePan.setLayout(gbDPan);
        this.qryTableModel = new QryTableModel();
        this.qryTable = new JTable(this.qryTableModel);
        this.qryTableModel.addColumn("");
        this.qryTable.setColumnSelectionAllowed(false);
        this.qryTable.setRowSelectionAllowed(true);
        this.qryTable.setSelectionMode(0);
        JScrollPane doneQryPan = new JScrollPane(this.qryTable);
        Uti1.bldConst(gbcDPan, 0, 0, 1, 1, 1, 1, 11, 1);
        gbDPan.setConstraints(doneQryPan, gbcDPan);
        this.qryTablePan.add(doneQryPan);
        SelectionListener listener = new SelectionListener(this.qryTable);
        this.qryTable.getSelectionModel().addListSelectionListener(listener);
        this.qryTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.dmpPan = new JPanel();
        GridBagLayout gbDmPan = new GridBagLayout();
        GridBagConstraints gbcDmPan = new GridBagConstraints();
        this.dmpPan.setLayout(gbDmPan);
        this.tabPan.addTab(Jedecma.localMessagesBundle.getString("TABLE_DUMP"), this.dmpPan);
        MyJlabel lab2 = new MyJlabel("Table");
        Uti1.bldConst(gbcDmPan, 0, 0, 3, 2, 1, 1);
        gbDmPan.setConstraints(lab2, gbcDmPan);
        this.dmpPan.add(lab2);
        this.tblCmb = new MyJComboBox(new String[]{"ALL", "TBLPROF", "DIAGTXT", "EDECAN", "EDECMA", "ECOIMG"}, "");
        Uti1.bldConst(gbcDmPan, 3, 0, 6, 1, 1, 0);
        gbDmPan.setConstraints(this.tblCmb, gbcDmPan);
        this.dmpPan.add(this.tblCmb);
        lab2 = new MyJlabel(Jedecma.localMessagesBundle.getString("DATE_START"));
        Uti1.bldConst(gbcDmPan, 0, 1, 3, 1, 0, 0);
        gbDmPan.setConstraints(lab2, gbcDmPan);
        this.dmpPan.add(lab2);
        this.dateFrom = new MyJTextField(10, "", new float[0], 6);
        this.dateFrom.addFocusListener(new CtrTextField());
        Uti1.bldConst(gbcDmPan, 4, 1, 3, 1, 0, 0);
        gbDmPan.setConstraints(this.dateFrom, gbcDmPan);
        this.dmpPan.add(this.dateFrom);
        lab2 = new MyJlabel(Jedecma.localMessagesBundle.getString("DATE_END"));
        Uti1.bldConst(gbcDmPan, 7, 1, 3, 1, 0, 0);
        gbDmPan.setConstraints(lab2, gbcDmPan);
        this.dmpPan.add(lab2);
        this.dateTo = new MyJTextField(10, "", new float[0], 6);
        this.dateTo.addFocusListener(new CtrTextField());
        Uti1.bldConst(gbcDmPan, 10, 1, 3, 1, 0, 0);
        gbDmPan.setConstraints(this.dateTo, gbcDmPan);
        this.dmpPan.add(this.dateTo);
        this.dmpBut = new JButton("dump");
        this.dmpBut.setMnemonic(68);
        this.dmpBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLTool.this.dmpTables(SQLTool.this.tblCmb.getInpValue());
            }
        });
        Uti1.bldConst(gbcDmPan, 13, 0, 3, 1, 0, 0);
        gbDmPan.setConstraints(this.dmpBut, gbcDmPan);
        this.dmpPan.add(this.dmpBut);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Uti1.bldConst(gbc, 0, 0, 1, 1, 1, 1, 11, 1);
        gb.setConstraints(this.mainPan, gbc);
        Jedecma.mainPan.setLayout(gb);
        Jedecma.mainPan.add(this.mainPan);
        this.loadDoneQry();
        Jedecma.mf.pack();
        Jedecma.mf.setVisible(true);
    }

    public void saveDoneQry() {
        if (Jedecma.user != null) {
            String inputFile = Uti1.getWrkDir();
            inputFile = String.valueOf(inputFile) + "sqltool." + Uti1.rightSet(String.valueOf(Jedecma.user.userid), 3, '0');
            FileWriter out = null;
            try {
                out = new FileWriter(inputFile);
                String line = "";
                int rows = this.qryTable.getRowCount();
                int r = 0;
                int i = 0;
                while (i < 50 && i < rows) {
                    r = rows - i - 1;
                    line = (String)this.qryTable.getModel().getValueAt(r, 0);
                    out.write(String.valueOf(line) + '\n');
                    ++i;
                }
                out.close();
            }
            catch (IOException ioex) {
                Uti1.error(Jedecma.localMessagesBundle.getString("IO_WRK_ERROR"), true);
            }
        }
    }

    public int loadDoneQry() {
        if (Jedecma.user != null) {
            String inputFile = Uti1.getWrkDir();
            inputFile = String.valueOf(inputFile) + "sqltool." + Uti1.rightSet(String.valueOf(Jedecma.user.userid), 3, '0');
            try {
                BufferedReader in = new BufferedReader(new FileReader(inputFile));
                String line = "";
                while ((line = in.readLine()) != null) {
                    this.qryTableModel.addRow(new Object[]{line});
                }
                in.close();
            }
            catch (IOException ie) {
                System.err.println(ie);
            }
            int rows = this.qryTableModel.getRowCount();
            return rows;
        }
        return 0;
    }

    public int doQuery(String qs) {
        int status;
        block8: {
            status = -1;
            String q = qs.trim();
            if (q.length() > 0) {
                ResultSet resultSet = null;
                int rc = 0;
                Connection connection = JDBCMgr.connection;
                Statement statement = JDBCMgr.statement;
                try {
                    this.logMessage(q);
                    if (statement.execute(q)) {
                        resultSet = statement.getResultSet();
                        ResultSetMetaData md = resultSet.getMetaData();
                        int columnCount = md.getColumnCount();
                        boolean inLoop = true;
                        Object o = null;
                        while (resultSet.next() && inLoop) {
                            ++rc;
                            String nextRow = "";
                            int i = 1;
                            while (i <= columnCount) {
                                o = resultSet.getObject(i);
                                String s = o == null ? "null" : o.toString();
                                nextRow = String.valueOf(nextRow) + s;
                                if (i < columnCount) {
                                    nextRow = String.valueOf(nextRow) + " ";
                                }
                                ++i;
                            }
                            this.logMessage(nextRow);
                            if (rc < 100) continue;
                            this.logMessage(Jedecma.localMessagesBundle.getString("LIST_TOO_LONG"));
                            inLoop = false;
                        }
                        status = rc;
                        this.logMessage(String.valueOf(rc) + " " + Jedecma.localMessagesBundle.getString("ROWS"));
                        this.qryTableModel.addRow(new Object[]{q});
                        break block8;
                    }
                    status = rc = statement.getUpdateCount();
                    this.logMessage(String.valueOf(rc) + " " + Jedecma.localMessagesBundle.getString("ROWS") + Jedecma.localMessagesBundle.getString("UPDATED"));
                    this.qryTableModel.addRow(new Object[]{q});
                }
                catch (SQLException ex) {
                    this.logMessage(ex.toString());
                }
            } else {
                this.logMessage("no query");
            }
        }
        return status;
    }

    public int loadFileQry(String inputFile) {
        boolean breakOnError = true;
        int rows = 0;
        if (inputFile.length() > 0) {
            int recNo = 0;
            int rec0 = Integer.parseInt(this.recFrom.getText());
            int rec1 = Integer.parseInt(this.recTo.getText());
            try {
                BufferedReader in = new BufferedReader(new FileReader(inputFile));
                String line = "";
                int rc = 0;
                this.logMessage("file: " + inputFile);
                while ((line = in.readLine()) != null) {
                    String tmps;
                    if ((line = line.trim()).length() <= 0 || (tmps = line.substring(0, 2)).equals("--")) continue;
                    tmps = line.substring(line.length() - 1);
                    if (tmps.equals(";")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    if (++recNo < rec0 && rec0 > 0 || recNo > rec1 && rec1 > 0) continue;
                    rc = this.doQuery(line);
                    if (rc < 0) {
                        this.logMessage("rec. " + recNo + " " + Jedecma.localMessagesBundle.getString("QUERY_ERROR"));
                        if (!breakOnError) continue;
                        continue;
                    }
                    ++rows;
                }
                in.close();
                this.logMessage(String.valueOf(rows) + " " + Jedecma.localMessagesBundle.getString("EXECUTED_CMDS"));
            }
            catch (IOException ie) {
                this.logMessage(ie.toString());
            }
        }
        return rows;
    }

    public String showTables() {
        if (Jedecma.dbmgr.getDbType() == 1) {
            return "show tables";
        }
        if (Jedecma.dbmgr.getDbType() == 0) {
            return "SELECT TABLENAME FROM SYS.SYSTABLES WHERE TABLETYPE='T'";
        }
        return "";
    }

    public void logMessage(String m) {
        final String msg = m;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLTool.this.qryResult.append(msg);
                SQLTool.this.qryResult.append("\n");
                SQLTool.this.qryResult.setCaretPosition(SQLTool.this.qryResult.getText().length() - 1);
            }
        });
    }

    void dmpTables(String tables) {
        this.dmpBut.setEnabled(false);
        System.out.println("dumping table: " + tables);
        if (tables.equals("TBLPROF") || tables.equals("ALL")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String q = "SELECT profcod, profdes FROM TBLPROF";
                    File outFile = SQLTool.this.outName("tblprof");
                    System.out.println("dumping TBLPROF to " + outFile);
                    ResultSet rSet = Jedecma.dbmgr.executeQuery(q);
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(outFile);
                        while (rSet.next()) {
                            q = "INSERT INTO TBLPROF (profcod, profdes) VALUES ('" + String.valueOf(Uti1.escape(rSet.getString("profcod"))) + "'" + ", '" + Uti1.escape(rSet.getString("profdes")) + "')";
                            writer.write(String.valueOf(q) + "\n");
                        }
                        writer.close();
                        System.out.println("export to " + outFile);
                        SQLTool.this.logMessage("export to " + outFile);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        Uti1.error("file IO error", true);
                    }
                    catch (SQLException ex) {
                        System.err.println(ex);
                        Uti1.error("SQL error", true);
                    }
                }
            });
        }
        if (tables.equals("ECOIMG") || tables.equals("ALL")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String q = "SELECT datupd, examnr, note, basename FROM ECOIMG WHERE examnr >0";
                    q = SQLTool.this.dateLim(q);
                    File outFile = SQLTool.this.outName("ecoimg");
                    System.out.println("dumping ECOIMG to " + outFile);
                    ResultSet rSet = Jedecma.dbmgr.executeQuery(q);
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(outFile);
                        while (rSet.next()) {
                            q = "INSERT INTO ECOIMG (datupd, examnr, note, basename) VALUES (";
                            Date d = rSet.getDate("datupd");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", " + String.valueOf(rSet.getInt("examnr")) + ", '" + Uti1.escape(rSet.getString("note")) + "'" + ", '" + Uti1.escape(rSet.getString("basename")) + "'" + ")";
                            writer.write(String.valueOf(q) + "\n");
                        }
                        writer.close();
                        System.out.println("export to " + outFile);
                        SQLTool.this.logMessage("export to " + outFile);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        Uti1.error("file IO error", true);
                    }
                    catch (SQLException ex) {
                        System.err.println(ex);
                        Uti1.error("SQL error", true);
                    }
                }
            });
        }
        if (tables.equals("DIAGTXT") || tables.equals("ALL")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String q = "SELECT datupd, examnr, text FROM DIAGTXT WHERE examnr >0";
                    q = SQLTool.this.dateLim(q);
                    File outFile = SQLTool.this.outName("diagtx");
                    System.out.println("dumping DIAGTXT to " + outFile);
                    ResultSet rSet = Jedecma.dbmgr.executeQuery(q);
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(outFile);
                        while (rSet.next()) {
                            q = "INSERT INTO DIAGTXT (datupd, examnr, text) VALUES (";
                            Date d = rSet.getDate("datupd");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", " + String.valueOf(rSet.getInt("examnr")) + ", '" + Uti1.escapeNl(Uti1.escape(rSet.getString("text"))) + "'" + ")";
                            writer.write(String.valueOf(q) + "\n");
                        }
                        writer.close();
                        System.out.println("export to " + outFile);
                        SQLTool.this.logMessage("export to " + outFile);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        Uti1.error("file IO error", true);
                    }
                    catch (SQLException ex) {
                        System.err.println(ex);
                        Uti1.error("SQL error", true);
                    }
                }
            });
        }
        if (tables.equals("EDECAN") || tables.equals("ALL")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String q = "SELECT datupd, ancode, anbrtd, anname, anaddr, ancapc, anloca, anrprv, anbprv, anteln, antel2, email, anprof, annote, anfami, anmena, anchld, an1cha, ansuck, anmens, anmenp, anheig, anweig FROM EDECAN WHERE ancode >0";
                    q = SQLTool.this.dateLim(q);
                    File outFile = SQLTool.this.outName("edecan");
                    System.out.println("dumping EDECAN to " + outFile);
                    ResultSet rSet = Jedecma.dbmgr.executeQuery(q);
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(outFile);
                        while (rSet.next()) {
                            q = "INSERT INTO EDECAN (datupd, ancode, anbrtd, anname, anaddr, ancapc, anloca, anrprv, anbprv, anteln, antel2, email, anprof, annote, anfami, anmena, anchld, an1cha, ansuck, anmens, anmenp, anheig, anweig) VALUES (";
                            Date d = rSet.getDate("datupd");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", DEFAULT, ";
                            d = rSet.getDate("anbrtd");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", '" + Uti1.escape(rSet.getString("anname")) + "', '" + Uti1.escape(rSet.getString("anaddr")) + "', '" + Uti1.escape(rSet.getString("ancapc")) + "', '" + Uti1.escape(rSet.getString("anloca")) + "', '" + Uti1.escape(rSet.getString("anrprv")) + "', '" + Uti1.escape(rSet.getString("anbprv")) + "', '" + Uti1.escape(rSet.getString("anteln")) + "', '" + Uti1.escape(rSet.getString("antel2")) + "', '" + Uti1.escape(rSet.getString("email")) + "', '" + Uti1.escape(rSet.getString("anprof")) + "', '" + Uti1.escape(rSet.getString("annote")) + "', '" + Uti1.escape(rSet.getString("anfami")) + "', " + rSet.getInt("anmena") + ", " + rSet.getInt("anchld") + ", " + rSet.getInt("an1cha") + ", " + rSet.getInt("ansuck") + ", " + rSet.getInt("anmens") + ", " + rSet.getInt("anmenp") + ", " + rSet.getFloat("anheig") + ", " + rSet.getFloat("anweig") + ")";
                            writer.write(String.valueOf(q) + "\n");
                        }
                        writer.close();
                        System.out.println(String.valueOf(Jedecma.localMessagesBundle.getString("EXPORT_EDECAN_MSG")) + outFile);
                        SQLTool.this.logMessage(String.valueOf(Jedecma.localMessagesBundle.getString("EXPORT_EDECAN_MSG")) + outFile);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        Uti1.error("file IO error", true);
                    }
                    catch (SQLException ex) {
                        System.err.println(ex);
                        Uti1.error("SQL error", true);
                    }
                }
            });
        }
        if (tables.equals("EDECMA") || tables.equals("ALL")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String q = "SELECT * FROM EDECMA WHERE numarc >0";
                    q = SQLTool.this.dateLim(q);
                    File f = SQLTool.this.outName("edecma");
                    System.out.println("dumping EDECAN to " + f);
                    ResultSet rSet = Jedecma.dbmgr.executeQuery(q);
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(f);
                        while (rSet.next()) {
                            q = "INSERT INTO EDECMA (datupd, numarc, datesa, cognom, datnas, dgneco, dgnist, dgncit, fampat, termed, terchi, tmsede, tmdime, datums, dtmamm, drmamm, ecbprv, mastse, allatt, citeco, isteco, tmmalg, nmrfgl, menarc, menopa, mstrzn, egmamm, tcapez, tdotti, mpfbcs, tescrc, mpmics, ematic, mpmacs, esmica, vgencs, esmaca, tsttum, tmcomp, tmcont, tmmarg, tmegen, tmattn, tmcono, tmtunn, tmmaca, tmmica, tmtmac, tmtmic, tmcoop, tmegcu, tmsasc, tmsarm, tmegfm, tminfa, tmdopp, taprgh, taregh, taingh, arprol, fibnod, esmamm, mastod, prolid, pesopz, altzpz, spsghi, tmsupe, tmvolu, spsgh1, discut, disfas, discap, opleco, oplmri, oplelg, oplfna, oplbio, dtleco, dtlmri, dtlfna, dtlelg, dtlbio, releco, relmri, relelg, relfna, relbio) VALUES (";
                            Date d = rSet.getDate("datupd");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", " + rSet.getInt("numarc") + ", ";
                            d = rSet.getDate("datesa");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            q = String.valueOf(q) + "'" + Uti1.escape(rSet.getString("cognom")) + "', ";
                            d = rSet.getDate("datnas");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            q = String.valueOf(q) + "'" + Uti1.escape(rSet.getString("dgneco")) + "'" + ", '" + Uti1.escape(rSet.getString("dgnist")) + "'" + ", '" + Uti1.escape(rSet.getString("dgncit")) + "'" + ", '" + Uti1.escape(rSet.getString("fampat")) + "'" + ", '" + Uti1.escape(rSet.getString("termed")) + "'" + ", '" + Uti1.escape(rSet.getString("terchi")) + "'" + ", '" + Uti1.escape(rSet.getString("tmsede")) + "'" + ", '" + Uti1.escape(rSet.getString("tmdime")) + "', ";
                            d = rSet.getDate("datums");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            d = rSet.getDate("dtmamm");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            q = String.valueOf(q) + "'" + Uti1.escape(rSet.getString("drmamm")) + "'" + ", '" + Uti1.escape(rSet.getString("ecbprv")) + "'" + ", '" + Uti1.escape(rSet.getString("mastse")) + "'" + ", " + rSet.getInt("allatt") + ", " + rSet.getInt("citeco") + ", " + rSet.getInt("isteco") + ", " + rSet.getInt("tmmalg") + ", " + rSet.getInt("nmrfgl") + ", " + rSet.getInt("menarc") + ", " + rSet.getInt("menopa") + ", " + rSet.getInt("mstrzn") + ", " + rSet.getInt("egmamm") + ", " + rSet.getInt("tcapez") + ", " + rSet.getInt("tdotti") + ", " + rSet.getInt("mpfbcs") + ", " + rSet.getInt("tescrc") + ", " + rSet.getInt("mpmics") + ", " + rSet.getInt("ematic") + ", " + rSet.getInt("mpmacs") + ", " + rSet.getInt("esmica") + ", " + rSet.getInt("vgencs") + ", " + rSet.getInt("esmaca") + ", " + rSet.getInt("tsttum") + ", " + rSet.getInt("tmcomp") + ", " + rSet.getInt("tmcont") + ", " + rSet.getInt("tmmarg") + ", " + rSet.getInt("tmegen") + ", " + rSet.getInt("tmattn") + ", " + rSet.getInt("tmcono") + ", " + rSet.getInt("tmtunn") + ", " + rSet.getInt("tmmaca") + ", " + rSet.getInt("tmmica") + ", " + rSet.getInt("tmtmac") + ", " + rSet.getInt("tmtmic") + ", " + rSet.getInt("tmcoop") + ", " + rSet.getInt("tmegcu") + ", " + rSet.getInt("tmsasc") + ", " + rSet.getInt("tmsarm") + ", " + rSet.getInt("tmegfm") + ", " + rSet.getInt("tminfa") + ", " + rSet.getInt("tmdopp") + ", " + rSet.getInt("taprgh") + ", " + rSet.getInt("taregh") + ", " + rSet.getInt("taingh") + ", " + rSet.getInt("arprol") + ", " + rSet.getInt("fibnod") + ", " + rSet.getInt("esmamm") + ", " + rSet.getInt("mastod") + ", " + rSet.getInt("prolid") + ", " + rSet.getFloat("pesopz") + ", " + rSet.getFloat("altzpz") + ", " + rSet.getFloat("spsghi") + ", " + rSet.getFloat("tmsupe") + ", " + rSet.getFloat("tmvolu") + ", " + rSet.getFloat("spsgh1") + ", " + rSet.getFloat("discut") + ", " + rSet.getFloat("disfas") + ", " + rSet.getFloat("discap") + ", '" + Uti1.escape(rSet.getString("opleco")) + "'" + ", '" + Uti1.escape(rSet.getString("oplmri")) + "'" + ", '" + Uti1.escape(rSet.getString("oplelg")) + "'" + ", '" + Uti1.escape(rSet.getString("oplfna")) + "'" + ", '" + Uti1.escape(rSet.getString("oplbio")) + "', ";
                            d = rSet.getDate("dtleco");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            d = rSet.getDate("dtlmri");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            d = rSet.getDate("dtlfna");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            d = rSet.getDate("dtlelg");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            d = rSet.getDate("dtlbio");
                            q = !Uti1.isDateNull(d) ? String.valueOf(q) + "'" + Uti1.date2Ansi(d) + "'" : String.valueOf(q) + "null";
                            q = String.valueOf(q) + ", ";
                            q = String.valueOf(q) + rSet.getInt("releco") + ", " + rSet.getInt("relmri") + ", " + rSet.getInt("relelg") + ", " + rSet.getInt("relfna") + ", " + rSet.getInt("relbio") + ")";
                            writer.write(String.valueOf(q) + "\n");
                        }
                        writer.close();
                        System.out.println(String.valueOf(Jedecma.localMessagesBundle.getString("EXPORT_EDECMA_MSG")) + f);
                        SQLTool.this.logMessage(String.valueOf(Jedecma.localMessagesBundle.getString("EXPORT_EDECMA_MSG")) + f);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        Uti1.error("file IO error", true);
                    }
                    catch (SQLException ex) {
                        System.err.println(ex);
                        Uti1.error("SQL error", true);
                    }
                }
            });
        }
        this.dmpBut.setEnabled(true);
    }

    private String dateLim(String q) {
        String tmpDt = this.dateFrom.getText();
        if (tmpDt.length() > 0) {
            q = String.valueOf(q) + " AND datupd >= '" + Uti1.date2Ansi(Uti1.string2Date(tmpDt)) + "'";
        }
        if ((tmpDt = this.dateTo.getText()).length() > 0) {
            q = String.valueOf(q) + " AND datupd <= '" + Uti1.date2Ansi(Uti1.string2Date(tmpDt)) + "'";
        }
        return q;
    }

    private File outName(String bn) {
        File f = new File(String.valueOf(Uti1.getWrkDir()) + bn + ".sql");
        int fileCnt = 0;
        while (f.exists()) {
            f = new File(String.valueOf(Uti1.getWrkDir()) + bn + "-" + ++fileCnt + ".sql");
        }
        return f;
    }

    class MyFileFilter
    extends FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Uti1.getExtension(f);
            if (extension != null) {
                return (extension = extension.toLowerCase()).equals("txt") || extension.equals("asc") || extension.equals("sql") || extension.equals("qry");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "ascii";
        }
    }

    public class QryTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int rows = this.table.getRowCount();
            int r = this.table.getSelectedRow();
            int c = this.table.getSelectedColumn();
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                if (rows > 0 && r != -1 && !e.getValueIsAdjusting()) {
                    SQLTool.this.qry.setText((String)this.table.getModel().getValueAt(r, 0));
                }
            } else if (e.getSource() == this.table.getColumnModel().getSelectionModel() && this.table.getColumnSelectionAllowed()) {
                int first = e.getFirstIndex();
                int n = e.getLastIndex();
            }
        }
    }
}

