/*
	This file is part of jrisk.

	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 15-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */
import java.io.*;


/**
 * Modella un comando generico. Ogni comando per essere
 * accettato dal gioco deve estendere questa classe.
 * 
 * @author Alessio Treglia
 * @version 1.0.0 
 */
public abstract class Comando {
    /**
     * Restituisce il nome del comando
     * 
     * @return una stringa contenente il nome del comando
     */
    abstract public String getNomeComando();
    
    /**
     * Esegue il comando
     * 
     * @param giocatore esecutore del comando
     * @param planisfero riferimento al tabellone di gioco
     */
    abstract public boolean esegui(Giocatore giocatore, Tabellone planisfero)
    	throws IOException;
}

