/*
 	This file is part of jrisk.

    jrisk is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    jrisk is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with jrisk; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/*
 * Created on 15-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

/**
 * Modella un comando di uscita dall'applicazione.
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ComandoEsci extends Comando {
    /** Contiene il nome del comando */
    private final String nomeComando = "esci";
    /* (non-Javadoc)
     * @see Comando#getNomeComando()
     */    
    public String getNomeComando() { return this.nomeComando; }
    
    /* (non-Javadoc)
     * @see Comando#esegui(Giocatore, java.util.Map)
     */    
    public boolean esegui(Giocatore giocatore, Tabellone planisfero) {
        giocatore.schermo.stampaln("Esce dal gioco...");
        return false;
    }

}
