/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 18-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */
import java.util.Set;
import java.util.HashSet;
/**
 * Gestisce il calcolo dei confini fra territori. Calcola
 * i territori confinanti a uno dato in base alla mappa
 * del Risiko standard.
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class GestoreConfini {
    /**
     * <p>Calcola i territori confinanti in base al nome del
     * territorio del parametro. Poich l'associazione di
     * confine viene gestita univocamente,bisogna affidarsi
     * al metodo void setConfinanti(String, Set) della
     * classe Tabellone, il quale imposta una doppia
     * associazione fra un territorio x e un territorio
     * y.</p>
     * 
     * @param t <code>Territorio</code> per il quale calcolare i confini
     * @return una collezione di <code>String</code> contenenti i nomi
     * dei territori confinanti
     */
    public static Set confinaCon(Territorio t) {
        Set confinanti = new HashSet();
        if(ElencoTerritoriContinenti.territorioValido(t.getNome())) {
        	// NORDAMERICA
            if(t.getNome().equals("alaska")) {
        	    confinanti.add("territoridelnordovest");
        	    confinanti.add("kamchatka");
        	    confinanti.add("alberta");
        	    return confinanti;
        	}
        	if(t.getNome().equals("territoridelnordovest")) {
        	    //confinanti.add("alaska");
        	    confinanti.add("groenlandia");
        	    confinanti.add("alberta");
        	    confinanti.add("ontario");
        	    return confinanti;
        	}
        	if(t.getNome().equals("groenlandia")) {
        	    //confinanti.add("territoridelnordovest");
        	    confinanti.add("ontario");
        	    confinanti.add("quebec");
        	    confinanti.add("islanda");
        	    return confinanti;
        	}
        	if(t.getNome().equals("alberta")) {
        	    confinanti.add("ontario");
        	    confinanti.add("usaovest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("ontario")) {
        	    confinanti.add("quebec");
        	    confinanti.add("usaovest");
        	    confinanti.add("usaest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("quebec")) {
        	    confinanti.add("usaest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("usaovest")) {
        	    confinanti.add("usaest");
        	    confinanti.add("americacentrale");
        	    return confinanti;
        	}
        	if(t.getNome().equals("usaest")) {
        	    confinanti.add("americacentrale");
        	    return confinanti;
        	}
        	if(t.getNome().equals("americacentrale")) {
        	    confinanti.add("venezuela");
        	    return confinanti;
        	}
        	//SUDAMERICA
        	if(t.getNome().equals("venezuela")) {
        	    confinanti.add("brasile");
        	    confinanti.add("peru'");
        	    return confinanti;
        	}
        	if(t.getNome().equals("brasile")) {
        	    confinanti.add("peru'");
        	    confinanti.add("argentina");
        	    confinanti.add("africanord");
        	    return confinanti;
        	}
        	if(t.getNome().equals("peru'")) {
        	    confinanti.add("argentina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("argentina")) {
        	    return confinanti;
        	}
        	//AFRICA
        	if(t.getNome().equals("africanord")) {
        	    confinanti.add("europaovest");
        	    confinanti.add("europasud");
        	    confinanti.add("africaest");
        	    confinanti.add("egitto");
        	    confinanti.add("congo");
        	    return confinanti;
        	}
        	if(t.getNome().equals("egitto")) {
        	    confinanti.add("europasud");
        	    confinanti.add("africaest");
        	    confinanti.add("medioriente");
        	    return confinanti;
        	}
        	if(t.getNome().equals("congo")) {
        	    confinanti.add("africaest");
        	    confinanti.add("sudafrica");
        	    return confinanti;
        	}
        	if(t.getNome().equals("africaest")) {
        	    confinanti.add("sudafrica");
        	    confinanti.add("madagascar");
        	    return confinanti;
        	}
        	if(t.getNome().equals("sudafrica")) {
        	    confinanti.add("madagascar");
        	    return confinanti;
        	}
        	if(t.getNome().equals("madagascar")) {
        	    return confinanti;
        	}
        	// EUROPA
        	if(t.getNome().equals("islanda")) {
        	    confinanti.add("uk");
        	    confinanti.add("scandinavia");
        	    return confinanti;
        	}
        	if(t.getNome().equals("uk")) {
        	    confinanti.add("scandinavia");
        	    confinanti.add("europanord");
        	    confinanti.add("europaovest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("scandinavia")) {
        	    confinanti.add("europanord");
        	    confinanti.add("ucraina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("europanord")) {
        	    confinanti.add("europaovest");
        	    confinanti.add("europasud");
        	    confinanti.add("ucraina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("europaovest")) {
        	    confinanti.add("europasud");
        	    return confinanti;
        	}
        	if(t.getNome().equals("europasud")) {
        	    confinanti.add("ucraina");
        	    confinanti.add("medioriente");
        	    return confinanti;
        	}
        	if(t.getNome().equals("ucraina")) {
        	    confinanti.add("medioriente");
        	    confinanti.add("urali");
        	    confinanti.add("afghanistan");
        	    return confinanti;
        	}
        	// ASIA
        	if(t.getNome().equals("kamchatka")) {
        	    confinanti.add("jacuzia");
        	    confinanti.add("cita");
        	    confinanti.add("mongolia");
        	    confinanti.add("giappone");
        	    return confinanti;
        	}
        	if(t.getNome().equals("jacuzia")) {
        	    confinanti.add("siberia");
        	    confinanti.add("cita");
        	    return confinanti;
        	}
        	if(t.getNome().equals("cita")) {
        	    confinanti.add("siberia");
        	    confinanti.add("mongolia");
        	    return confinanti;
        	}
        	if(t.getNome().equals("siberia")) {
        	    confinanti.add("mongolia");
        	    confinanti.add("urali");
        	    confinanti.add("cina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("urali")) {
        	    confinanti.add("afghanistan");
        	    confinanti.add("cina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("afghanistan")) {
        	    confinanti.add("medioriente");
        	    confinanti.add("india");
        	    confinanti.add("cina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("mongolia")) {
        	    confinanti.add("giappone");
        	    confinanti.add("cina");
        	    return confinanti;
        	}
        	if(t.getNome().equals("cina")) {
        	    confinanti.add("india");
        	    confinanti.add("siam");
        	    return confinanti;
        	}
        	if(t.getNome().equals("medioriente")) {
        	    confinanti.add("india");
        	    return confinanti;
        	}
        	if(t.getNome().equals("siam")) {
        	    confinanti.add("india");
        	    confinanti.add("nuovaguinea");
        	    return confinanti;
        	}
        	if(t.getNome().equals("giappone")) {
        	    return confinanti;
        	}
        	if(t.getNome().equals("india")) {
        	    return confinanti;
        	}
        	// OCEANIA
        	if(t.getNome().equals("nuovaguinea")) {
        	    confinanti.add("indonesia");
        	    confinanti.add("australiaovest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("indonesia")) {
        	    confinanti.add("australiaovest");
        	    confinanti.add("australiaest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("australiaovest")) {
        	    confinanti.add("australiaest");
        	    return confinanti;
        	}
        	if(t.getNome().equals("australiaest")) {
        	    return confinanti;
        	}
        }
        return null;
    }
}
