/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class ComandoAttacca
extends Comando {
    private final String nomeComando = "attacca";
    private String partenza;
    private String destinazione;

    public ComandoAttacca(String da, String a) {
        this.partenza = da;
        this.destinazione = a;
    }

    public String getNomeComando() {
        return this.nomeComando;
    }

    public boolean esegui(Giocatore giocatore, Tabellone planisfero) throws IOException {
        if (!ElencoTerritoriContinenti.territorioValido(this.partenza) || !ElencoTerritoriContinenti.territorioValido(this.destinazione)) {
            return new ComandoNonValido().esegui(giocatore, planisfero);
        }
        Giocatore g1 = planisfero.getGiocatoreAt(this.partenza);
        Giocatore g2 = planisfero.getGiocatoreAt(this.destinazione);
        int nDadiAttacco = 0;
        if (giocatore == g1 && giocatore != g2) {
            String risp;
            Territorio a;
            Territorio da = g1.getTerritorio(this.partenza);
            if (!da.confinaCon(a = g2.getTerritorio(this.destinazione))) {
                g1.schermo.stampaln("Possono essere attaccati solo i territori confinanti");
                return false;
            }
            if (da.puoAttaccare()) {
                g1.schermo.stampa("Con quante armate attacchi? (1 - 3) ");
                nDadiAttacco = g1.parser.getInt();
                if (nDadiAttacco == 0) {
                    return false;
                }
                if (!da.puoAttaccare(nDadiAttacco)) {
                    nDadiAttacco = da.maxDadiAttacco();
                }
            } else {
                g1.schermo.stampaln("Non puoi attaccare da " + this.partenza);
                return false;
            }
            g2.schermo.stampaln("L'avversario ti attacca con " + nDadiAttacco + " armate.");
            g2.schermo.stampa("Con quante armate ti difendi? (1 - 3) ");
            int nDadiDifesa = g2.parser.getInt();
            if (nDadiDifesa < 1 || nDadiDifesa > a.maxDadiDifesa()) {
                nDadiDifesa = a.maxDadiDifesa();
            }
            g1.schermo.stampaln("Il difensore difende con " + nDadiDifesa + " dado/i.");
            Battaglia battaglia = new Battaglia(g1, g2, da.getNome(), a.getNome());
            int esitoScontro = battaglia.scontro(nDadiAttacco, nDadiDifesa);
            g1.schermo.stampaln(battaglia.getLancioAttacco().toString());
            g2.schermo.stampaln(battaglia.getLancioDifesa().toString());
            if (esitoScontro > 0) {
                g1.schermo.stampaln(String.valueOf(g1.getColore()) + " ha conquistato " + this.destinazione);
                g1.aggiungiTerritorio(g2.rimuoviTerritorio(a.getNome()));
                this.aggiornaPlanisfero(planisfero, a, g1);
                this.spostamentoPostAttacco(esitoScontro, da, a);
                g1.schermo.stampaln("Vuoi spostare altre armate sul territorio conquistato? ");
                risp = g1.parser.getParola();
                if (risp.equals("si")) {
                    new ComandoSposta(this.partenza, this.destinazione).esegui(g1, planisfero);
                }
                if (g2.eliminato()) {
                    g1.aggiungiCarte(g2.getCarte());
                }
            }
            if (esitoScontro < 0) {
                g2.schermo.stampaln(String.valueOf(g2.getColore()) + " ha conquistato " + this.partenza);
                g2.aggiungiTerritorio(g1.rimuoviTerritorio(da.getNome()));
                this.aggiornaPlanisfero(planisfero, da, g2);
                this.spostamentoPostAttacco(1, a, da);
                g1.schermo.stampaln("Vuoi spostare altre armate sul territorio conquistato? ");
                risp = g2.parser.getParola();
                if (risp.equals("si")) {
                    return new ComandoSposta(this.destinazione, this.partenza).esegui(g2, planisfero);
                }
                if (g1.eliminato()) {
                    g2.aggiungiCarte(g1.getCarte());
                }
            }
        } else {
            g1.schermo.stampa("Non puoi attaccare un tuo territorio!\n");
        }
        return false;
    }

    private void spostamentoPostAttacco(int esito, Territorio source, Territorio dest) {
        source.muovi(esito, dest);
    }

    private void aggiornaPlanisfero(Tabellone p, Territorio t, Giocatore g) {
        p.aggiornaTerritorio(t, g);
    }
}

