/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 15-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

import java.util.Comparator;

/**
 * Confronta due serie di dati.
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ComparatoreSerieDiDadi implements Comparator {
    /* (non-Javadoc)
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */

    /**
     * Confronta due serie di dadi. Prende in considerazione
     * il minor numero x di dadi, i.e.:
     * <pre>
     * ...
     * 
     * SerieDiDadi a = new SerieDiDadi(3);
     * SerieDiDadi b = new SerieDiDadi(2);
     * 
     * int x = ( a.getNumeroDadi() < b.getNumeroDadi() ) ? a.getNumeroDadi() : b.getNumeroDadi();
     * 
     * ...
     * </pre>
     * nel caso sopra descritto x = 2.
     * Stabilito il numero di oggetti da confrontare, esegue il confronto, restituendo un numero
     * pari al numero di <code>Dado</code> pi grandi contenuti nella lista dell'oggetto arg0 rispetto
     * ai Dado contenuti nella lista di arg1, i.e.:
     * 
     * <p>(gli oggetti sono quelli dell'esempio di sopra)</p>
     * <pre>
     * ...
     * 
     * ComparatoreSerieDiDati c = new ComparatoreSerieDiDati();
     * 
     * System.out.println(a);					// Visualizza -->	[ 4 ]	[ 3 ]	[ 3 ]
     * System.out.println(b);					// Visualizza -->	[ 6 ]	[ 3 ]	[ 1 ]
     * 
     * int z = c.compare(a,b);					// Confronta i due oggetti
     * 
     * System.out.println(z);					// Visualizza -->	1
     * </pre>
     * <p>NOTA: in caso di parit di punteggio, viene considerato maggiore il dado di arg1.
     * Per capire il motivo di questa scelta si rimanda alle regole del gioco.</p>
     *
     * @param arg0 operando di sinistra
     * @param arg1 operando di destra
     * @return numero di <code>Dado</code> pi grandi contenuti nella collezione di arg0 rispetto
     * ai <code>Dado</code> della collezione di arg1.
     */
    public int compare(Object arg0, Object arg1) {
        /* Converte gli oggetti generici in due di tipo SerieDiDadi */
        SerieDiDadi a = (SerieDiDadi) arg0;
        SerieDiDadi b = (SerieDiDadi) arg1;
        int nDadiDaConfrontare;					// Numero di dadi da confrontare
        int nDadiMaggiori;						// Numero di dadi maggiori rispetto all'altra serie
        
        /* Calcola quanti dadi confrontare */
        nDadiDaConfrontare = getDadiDaConfrontare(a.getNumeroDadi(),b.getNumeroDadi());
        nDadiMaggiori = 0;
        
        /*
         * Confronta i dadi delle serie in modo parallelo, partendo dalle
         * prime posizioni (in cui si trovano i dati maggiori) e arrivando
         * alle ultime.
         */                
        for(int i=0; i<nDadiDaConfrontare; i++)
            if(a.getDado(i).compareTo(b.getDado(i)) > 0)
                nDadiMaggiori++;
        
        return nDadiMaggiori;					// Restituisci il numero di dadi di a maggiori di quelli di b
    }
    /**
     * Confronta due numeri e sceglie il piccolo.
     * 
     * @param a primo numero
     * @param b secondo numero
     * @return il minore fra i due
     */
    public int getDadiDaConfrontare(int a, int b) {
        return ( ( a < b ) ? a : b );
    }

}
