/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 15-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

import java.io.PrintStream;

/**
 * Modella un display per la visualizzazione dei messaggi del
 * programma. Incapsula un riferimento all'oggetto che gestisce
 * la periferica di output standard del sistema.
 * 
 * @author Alessio Treglia
 * @version 1.0.1
 */
public class Display {
    /** Contiene il riferimento allo schermo del sistema */
    private PrintStream stream;
    /**
     * Inizializza l'oggetto.
     */
    public Display() {
        /* Memorizza il riferimento allo schermo */
        stream = new PrintStream(System.out, true);
    }
    
    /**
     * Stampa una stringa sul supporto di visualizzazione
     * 
     * @param str <code>String</code> da stampare
     */
    public void stampa(String str) {
        //System.out.print(str);
        stream.print(str);
    }
    /**
     * Stampa la descrizione stringa sul supporto di
     * visualizzazione.
     * 
     * @param ob oggetto del quale stampare la descrizione
     * stringa
     */
    public void stampa(Object ob) {
        stampa(ob.toString());
    }
    
    /**
     * Stampa una stringa sul supporto di visualizzazione,
     * pi il carattere di nuova linea.
     * 
     * @param str <code>String</code> da stampare
     */
    public void stampaln(String str) {
        stream.println(str);
    }
    /**
     * Stampa un numero intero sullo schermo.
     * 
     * @param n <code>int</code> da stampare
     */
    public void stampaln(int n) {
        stream.println(n);
    }
    /**
     * Stampa una stringa descrittiva dell'oggetto
     * ob sul supporto di visualizzazione, pi il
     * carattere di nuova linea.
     * @param ob oggetto da stampare
     */
    public void stampaln(Object ob) {
        stampaln(ob.toString());
    }
    /**
     * Stampa un carattere di nuova linea
     */
    public void stampaln() { stream.println(); }
}
