<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_acl_list extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  XFUI::load_lang_res('','acpacl');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $id = XF::sanitize_var(XF::ifset('get','id',''),'action','okifempty');
  $this->gpc = array('id'=>$id);
  unset($id);

  $available_action = array();
  $group = XF::get_group('*');
  $data = array();
  $user = array();

    if ( $this->gpc['id'] !== '' ){
    $sacl = XF::sql_query("SELECT * FROM ".XF::tbl('acl')." WHERE a_action = :id ORDER BY a_use_group DESC, a_key ASC",array(
    'id'=>array($this->gpc['id'],'str')),__METHOD__,__LINE__);
      while ( $r = $sacl->fetchObject() ){
      $r->a_key = intval($r->a_key);
      $r->a_use_group = (bool)$r->a_use_group;
      $r->a_allow = (bool)$r->a_allow;
        if ( !$r->a_use_group )
        $user[(int)$r->a_key] = XF::get_user($r->a_key);
      $data[(int)$r->a_id] = (array)$r;
      }
    $sacl->closeCursor();
    XFUI::ajax_init();
    XF::tan('acp_acl_delete');
    XF::tan('acp_acl_edit');
    XF::tan('acp_acl_new');
    }

  $sacl = XF::sql_query("SELECT a_action FROM ".XF::tbl('acl')." GROUP BY a_action ORDER BY a_action ASC",'',__METHOD__,__LINE__);
    while ( $r = $sacl->fetchObject() )
    $available_action[$r->a_action] = '{:acl_seg_'.$r->a_action.'}';
  $sacl->closeCursor();

  XF::tan('cachemgr');
  XFUI::html_head('{:access_control}');
  XF::$tpl->clear_cache('form_acp_acl.tpl');
  XF::$tpl->assign('link_to_cachemgr',XF::access_control('cachemgr'));
  XF::$tpl->assign('cachemgr_tan',(isset($_SESSION['xf_tan']['cachemgr']))?$_SESSION['xf_tan']['cachemgr']:'');
  XF::$tpl->assign('selected_action',$this->gpc['id']);
  XF::$tpl->assign('action_listing',$available_action);
  XF::$tpl->assign('group_data',$group);
  XF::$tpl->assign('user_data',$user);
  XF::$tpl->assign('acl_data',$data);
  XF::$tpl->display('form_acp_acl.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * list access control entries (done directly in run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>