<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_cfg_edit extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $this->gpc = $input;
  return true;
  }

  /**
  * edit configuration variables
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  XFCache::put('simple','smilies',array(
  array('-@','ext/face-devilish.png'),
  array('-x','ext/face-kiss.png'),
  array(':(','ext/face-sad.png'),
  array(':D','ext/face-grin.png'),
  array(':o','ext/face-surprise.png'),
  array(':)','ext/face-smile.png'),
  array(';)','ext/face-wink.png')
  ));
  $hide = array('_','main_umask','main_uuid','main_version');

    try {
    XF::sql_query("SELECT 1",'',__METHOD__,__LINE__);
    $constraint = XF::get_cfg_data();
    $process = array();
      foreach ( $this->gpc as $k=>$v ){
        if ( preg_match('/^f_([a-z_]+)$/Du',$k,$v) ){
          if ( isset($v[1]) && !isset($constraint[$v[1]]) )
          continue;
        $process[] = XF::$sql->quote($v[1]);
        }
      }
      if ( sizeof($process) === 0 )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('config'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $sacl = XF::sql_query("SELECT * FROM ".XF::tbl('config')." WHERE c_id IN (".implode(',',$process).")",__METHOD__,__LINE__);
      $process = array('info');
        while ( $r = $sacl->fetchObject() ){
          if ( in_array($r->c_id,$hide,true) )
          continue;
        $a = ( isset($constraint[$r->c_id][1]) ) ? $constraint[$r->c_id][1] : '';
          if ( $constraint[$r->c_id][0] === 'bool' ) // well, on form data 'booli' is more useful as we send zero or one per http
          $constraint[$r->c_id][0] = 'booli';
          if ( $constraint[$r->c_id][0] === 'uri' ) // if it contains '{$ROOT_URI}' this fails on checking, therefore use 'str' here
          $constraint[$r->c_id][0] = 'str';
        $b = XF::sanitize_var($this->gpc['f_'.$r->c_id],$constraint[$r->c_id][0],$a);
          if ( $b === false )
          throw new XFE('illegal input in "'.$r->c_id.'" - requires "'.$constraint[$r->c_id][0].'"');
        $c = ( is_numeric($b) ) ? 'int' : 'str';
        $u = XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :value WHERE c_id = :id",array(
        'id'=>array($r->c_id,'str'),
        'value'=>array($b,$c)),__METHOD__,__LINE__);
          if ( $u ){
          $process[] = 'key';
          $process[] = $r->c_id;
          $process[] = 'value';
          $process[] = $b;
          }
        }
      $sacl->closeCursor();
      XFCache::purge('simple','config');
      XF::logger($process);
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_cfg_edit($input){
  $a = new XFAction_acp_cfg_edit();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_cfg_list','',false),'{:edit_cfg_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>